/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectSerializer {
    private static final Log log = LogFactory.getLog(ObjectSerializer.class);

    public static String serialize(Serializable obj) throws IOException {
        if (obj == null) {
            return "";
        }
        try {
            ByteArrayOutputStream serialObj = new ByteArrayOutputStream();
            Deflater def = new Deflater(9);
            ObjectOutputStream objStream = new ObjectOutputStream(new DeflaterOutputStream((OutputStream)serialObj, def));
            objStream.writeObject(obj);
            objStream.close();
            return ObjectSerializer.encodeBytes(serialObj.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Serialization error: " + e.getMessage(), e);
        }
    }

    public static Object deserialize(String str) throws IOException {
        if (str == null || str.length() == 0) {
            return null;
        }
        try {
            ByteArrayInputStream serialObj = new ByteArrayInputStream(ObjectSerializer.decodeBytes(str));
            ObjectInputStream objStream = new ObjectInputStream(new InflaterInputStream(serialObj));
            return objStream.readObject();
        }
        catch (Exception e) {
            throw new IOException("Deserialization error: " + e.getMessage(), e);
        }
    }

    public static String encodeBytes(byte[] bytes) {
        return Base64.encodeBase64URLSafeString((byte[])bytes);
    }

    public static byte[] decodeBytes(String str) {
        return Base64.decodeBase64((String)str);
    }
}

