/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.PreOrderDepthFirstWalker;
import org.joda.time.DateTime;

public class AugmentBaseDataVisitor
extends LogicalRelationalNodesVisitor {
    Map<LOLoad, DataBag> baseData = null;
    Map<LOLoad, DataBag> newBaseData = new HashMap<LOLoad, DataBag>();
    Map<Operator, DataBag> derivedData = null;
    private boolean limit = false;
    private final Map<Operator, PhysicalOperator> logToPhysMap;
    private Map<LOLimit, Long> oriLimitMap;
    Map<Operator, DataBag> outputConstraintsMap = new HashMap<Operator, DataBag>();
    Log log = LogFactory.getLog(this.getClass());

    public AugmentBaseDataVisitor(OperatorPlan plan, Map<Operator, PhysicalOperator> logToPhysMap, Map<LOLoad, DataBag> baseData, Map<Operator, DataBag> derivedData) throws FrontendException {
        super(plan, new PreOrderDepthFirstWalker(plan));
        this.baseData = baseData;
        this.derivedData = derivedData;
        this.logToPhysMap = logToPhysMap;
    }

    public void setLimit() {
        this.limit = true;
    }

    public Map<LOLoad, DataBag> getNewBaseData() throws ExecException {
        MultiMap<FileSpec, DataBag> inputDataMap = new MultiMap<FileSpec, DataBag>();
        for (Map.Entry<LOLoad, DataBag> e : this.newBaseData.entrySet()) {
            inputDataMap.put(e.getKey().getFileSpec(), e.getValue());
        }
        int index = 0;
        for (FileSpec fileSpec : inputDataMap.keySet()) {
            int maxSchemaSize = 0;
            Tuple tupleOfMaxSchemaSize = null;
            for (DataBag bag : inputDataMap.get(fileSpec)) {
                if (bag.size() <= 0L) continue;
                int size = 0;
                Tuple t = null;
                t = bag.iterator().next();
                size = t.size();
                if (size <= maxSchemaSize) continue;
                maxSchemaSize = size;
                tupleOfMaxSchemaSize = t;
            }
            for (DataBag bag : inputDataMap.get(fileSpec)) {
                if (bag.size() <= 0L) continue;
                for (Tuple t : bag) {
                    for (int i = t.size(); i < maxSchemaSize; ++i) {
                        t.append(tupleOfMaxSchemaSize.get(i));
                    }
                }
            }
            ++index;
        }
        for (Map.Entry entry : this.baseData.entrySet()) {
            DataBag bag = this.newBaseData.get(entry.getKey());
            if (bag == null) {
                bag = BagFactory.getInstance().newDefaultBag();
                this.newBaseData.put((LOLoad)entry.getKey(), bag);
            }
            bag.addAll((DataBag)entry.getValue());
        }
        return this.newBaseData;
    }

    public Map<LOLimit, Long> getOriLimitMap() {
        return this.oriLimitMap;
    }

    @Override
    public void visit(LOCogroup cg) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(cg);
        this.outputConstraintsMap.remove(cg);
        boolean ableToHandle = true;
        LinkedList groupSpecs = new LinkedList();
        int numCols = -1;
        for (int index = 0; index < cg.getInputs((LogicalPlan)this.plan).size(); ++index) {
            List<LogicalExpressionPlan> groupByPlans = cg.getExpressionPlans().get(index);
            ArrayList<Integer> groupCols = new ArrayList<Integer>();
            for (LogicalExpressionPlan plan : groupByPlans) {
                Operator leaf = plan.getSinks().get(0);
                if (leaf instanceof ProjectExpression) {
                    groupCols.add(((ProjectExpression)leaf).getColNum());
                    continue;
                }
                ableToHandle = false;
                break;
            }
            if (numCols == -1) {
                numCols = groupCols.size();
            }
            if (groupCols.size() != groupByPlans.size() || groupCols.size() != numCols) break;
            groupSpecs.add(groupCols);
        }
        try {
            if (ableToHandle) {
                int numInputs = cg.getInputs((LogicalPlan)this.plan).size();
                if (outputConstraints != null) {
                    for (Tuple outputConstraint : outputConstraints) {
                        Object groupLabel = outputConstraint.get(0);
                        for (int input = 0; input < numInputs; ++input) {
                            int numInputFields = ((LogicalRelationalOperator)cg.getInputs((LogicalPlan)this.plan).get(input)).getSchema().size();
                            List groupCols = (List)groupSpecs.get(input);
                            DataBag output = this.outputConstraintsMap.get(cg.getInputs((LogicalPlan)this.plan).get(input));
                            if (output == null) {
                                output = BagFactory.getInstance().newDefaultBag();
                                this.outputConstraintsMap.put(cg.getInputs((LogicalPlan)this.plan).get(input), output);
                            }
                            for (int i = 0; i < 2; ++i) {
                                Tuple inputConstraint = this.GetGroupByInput(groupLabel, groupCols, numInputFields);
                                if (inputConstraint == null) continue;
                                output.add(inputConstraint);
                            }
                        }
                    }
                }
                DataBag outputData = this.derivedData.get(cg);
                for (Tuple groupTup : outputData) {
                    Object groupLabel = groupTup.get(0);
                    for (int input = 0; input < numInputs; ++input) {
                        int numInputFields = ((LogicalRelationalOperator)cg.getInputs((LogicalPlan)this.plan).get(input)).getSchema().size();
                        List groupCols = (List)groupSpecs.get(input);
                        DataBag output = this.outputConstraintsMap.get(cg.getInputs((LogicalPlan)this.plan).get(input));
                        if (output == null) {
                            output = BagFactory.getInstance().newDefaultBag();
                            this.outputConstraintsMap.put(cg.getInputs((LogicalPlan)this.plan).get(input), output);
                        }
                        int numTupsToAdd = 2 - (int)((DataBag)groupTup.get(input + 1)).size();
                        for (int i = 0; i < numTupsToAdd; ++i) {
                            Tuple inputConstraint = this.GetGroupByInput(groupLabel, groupCols, numInputFields);
                            if (inputConstraint == null) continue;
                            output.add(inputConstraint);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new FrontendException("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage());
        }
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(join);
        this.outputConstraintsMap.remove(join);
        boolean ableToHandle = true;
        LinkedList groupSpecs = new LinkedList();
        int numCols = -1;
        for (int index = 0; index < join.getInputs((LogicalPlan)this.plan).size(); ++index) {
            List<LogicalExpressionPlan> groupByPlans = join.getExpressionPlans().get(index);
            ArrayList<Integer> groupCols = new ArrayList<Integer>();
            for (LogicalExpressionPlan plan : groupByPlans) {
                Operator leaf = plan.getSinks().get(0);
                if (leaf instanceof ProjectExpression) {
                    groupCols.add(((ProjectExpression)leaf).getColNum());
                    continue;
                }
                ableToHandle = false;
                break;
            }
            if (numCols == -1) {
                numCols = groupCols.size();
            }
            if (groupCols.size() != groupByPlans.size() || groupCols.size() != numCols) break;
            groupSpecs.add(groupCols);
        }
        try {
            if (ableToHandle) {
                DataBag outputData;
                Tuple inputConstraint;
                int numInputs = join.getInputs((LogicalPlan)this.plan).size();
                if (outputConstraints != null) {
                    for (Tuple outputConstraint : outputConstraints) {
                        for (int input = 0; input < numInputs; ++input) {
                            int numInputFields = ((LogicalRelationalOperator)join.getInputs((LogicalPlan)this.plan).get(input)).getSchema().size();
                            List groupCols = (List)groupSpecs.get(input);
                            DataBag output = this.outputConstraintsMap.get(join.getInputs((LogicalPlan)this.plan).get(input));
                            if (output == null) {
                                output = BagFactory.getInstance().newDefaultBag();
                                this.outputConstraintsMap.put(join.getInputs((LogicalPlan)this.plan).get(input), output);
                            }
                            if ((inputConstraint = this.GetJoinInput(outputConstraint, groupCols, numInputFields)) == null) continue;
                            output.add(inputConstraint);
                        }
                    }
                }
                if ((outputData = this.derivedData.get(join)).size() == 0L) {
                    DataBag output0 = this.outputConstraintsMap.get(join.getInputs((LogicalPlan)this.plan).get(0));
                    if (output0 == null || output0.size() == 0L) {
                        output0 = this.derivedData.get(join.getInputs((LogicalPlan)this.plan).get(0));
                    }
                    Tuple inputConstraint0 = output0.iterator().next();
                    for (int input = 1; input < numInputs; ++input) {
                        DataBag output = this.outputConstraintsMap.get(join.getInputs((LogicalPlan)this.plan).get(input));
                        if (output == null) {
                            output = BagFactory.getInstance().newDefaultBag();
                            this.outputConstraintsMap.put(join.getInputs((LogicalPlan)this.plan).get(input), output);
                        }
                        int numInputFields = ((LogicalRelationalOperator)join.getInputs((LogicalPlan)this.plan).get(input)).getSchema().size();
                        inputConstraint = this.GetJoinInput(inputConstraint0, (List)groupSpecs.get(0), (List)groupSpecs.get(input), numInputFields);
                        if (inputConstraint == null) continue;
                        output.add(inputConstraint);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new FrontendException("Error visiting Cogroup during Augmentation phase of Example Generator! " + e.getMessage());
        }
    }

    @Override
    public void visit(LOCross cs) throws FrontendException {
    }

    @Override
    public void visit(LODistinct dt) throws FrontendException {
        Iterator<Tuple> it;
        boolean emptyInputConstraints;
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(dt);
        this.outputConstraintsMap.remove(dt);
        DataBag inputConstraints = this.outputConstraintsMap.get(dt.getInput((LogicalPlan)this.plan));
        if (inputConstraints == null) {
            inputConstraints = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(dt.getInput((LogicalPlan)this.plan), inputConstraints);
        }
        if (outputConstraints != null && outputConstraints.size() > 0L) {
            Iterator<Tuple> it2 = outputConstraints.iterator();
            while (it2.hasNext()) {
                inputConstraints.add(it2.next());
            }
        }
        boolean bl = emptyInputConstraints = inputConstraints.size() == 0L;
        if (emptyInputConstraints) {
            DataBag inputData = this.derivedData.get(dt.getInput((LogicalPlan)this.plan));
            it = inputData.iterator();
            while (it.hasNext()) {
                inputConstraints.add(it.next());
            }
        }
        HashSet<Tuple> distinctSet = new HashSet<Tuple>();
        it = inputConstraints.iterator();
        while (it.hasNext() && distinctSet.add(it.next())) {
        }
        if (!it.hasNext()) {
            if (inputConstraints.size() > 0L) {
                Tuple src = ((ExampleTuple)inputConstraints.iterator().next()).toTuple();
                Tuple tgt = TupleFactory.getInstance().newTuple(src.getAll());
                ExampleTuple inputConstraint = new ExampleTuple(tgt);
                inputConstraint.synthetic = true;
                inputConstraints.add(inputConstraint);
            } else if (emptyInputConstraints) {
                inputConstraints.clear();
            }
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(filter);
        this.outputConstraintsMap.remove(filter);
        LogicalExpressionPlan filterCond = filter.getFilterPlan();
        DataBag inputConstraints = this.outputConstraintsMap.get(filter.getInput((LogicalPlan)this.plan));
        if (inputConstraints == null) {
            inputConstraints = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(filter.getInput((LogicalPlan)this.plan), inputConstraints);
        }
        DataBag outputData = this.derivedData.get(filter);
        DataBag inputData = this.derivedData.get(filter.getInput((LogicalPlan)this.plan));
        try {
            ExampleTuple inputConstraint;
            if (outputConstraints != null && outputConstraints.size() > 0L) {
                for (Tuple outputConstraint : outputConstraints) {
                    ExampleTuple inputConstraint2 = this.GenerateMatchingTuple(outputConstraint, filterCond, false);
                    if (inputConstraint2 == null) continue;
                    inputConstraints.add(inputConstraint2);
                }
            } else if (outputData.size() == 0L && (inputConstraint = this.GenerateMatchingTuple(filter.getSchema(), filterCond, false)) != null) {
                inputConstraints.add(inputConstraint);
            }
            if (outputData.size() == inputData.size() && (inputConstraint = this.GenerateMatchingTuple(filter.getSchema(), filterCond, true)) != null) {
                inputConstraints.add(inputConstraint);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()), (Throwable)e);
            throw new FrontendException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage(), e);
        }
    }

    @Override
    public void visit(LOForEach forEach) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(forEach);
        this.outputConstraintsMap.remove(forEach);
        LogicalPlan plan = forEach.getInnerPlan();
        boolean ableToHandle = true;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        boolean cast = false;
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            return;
        }
        Operator op = plan.getSinks().get(0);
        if (op instanceof CastExpression) {
            cast = true;
            op = ((CastExpression)op).getExpression();
        }
        if (!(op instanceof ProjectExpression)) {
            ableToHandle = false;
        } else {
            cols.add(((ProjectExpression)op).getColNum());
        }
        if (ableToHandle) {
            DataBag output = BagFactory.getInstance().newDefaultBag();
            for (Tuple outputConstraint : outputConstraints) {
                try {
                    Tuple inputConstraint = this.BackPropConstraint(outputConstraint, cols, ((LogicalRelationalOperator)plan.getPredecessors(forEach).get(0)).getSchema(), cast);
                    output.add(inputConstraint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new FrontendException("Operator error during Augmenting Phase in Example Generator " + e.getMessage());
                }
            }
            this.outputConstraintsMap.put(plan.getPredecessors(forEach).get(0), output);
        }
    }

    @Override
    public void visit(LOLoad load) throws FrontendException {
        LogicalSchema schema;
        DataBag inputData = this.baseData.get(load);
        if (inputData == null || inputData.size() == 0L) {
            this.log.error((Object)"No (valid) input data found!");
            throw new RuntimeException("No (valid) input data found!");
        }
        DataBag newInputData = this.newBaseData.get(load);
        if (newInputData == null) {
            newInputData = BagFactory.getInstance().newDefaultBag();
            this.newBaseData.put(load, newInputData);
        }
        try {
            schema = load.getSchema();
            if (schema == null) {
                throw new RuntimeException("Example Generator requires a schema. Please provide a schema while loading data");
            }
        }
        catch (FrontendException e) {
            this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()));
            throw new FrontendException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
        }
        Tuple exampleTuple = inputData.iterator().next();
        DataBag outputConstraints = this.outputConstraintsMap.get(load);
        this.outputConstraintsMap.remove(load);
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            outputConstraints = BagFactory.getInstance().newDefaultBag();
            outputConstraints.add(TupleFactory.getInstance().newTuple(schema.getFields().size()));
        }
        System.out.println(exampleTuple.toString());
        boolean newInput = false;
        for (Tuple outputConstraint : outputConstraints) {
            if (outputConstraint.size() != schema.getFields().size()) {
                throw new RuntimeException("Internal error: incorrect number of fields in constraint tuple.");
            }
            Tuple inputT = TupleFactory.getInstance().newTuple(outputConstraint.size());
            ExampleTuple inputTuple = new ExampleTuple(inputT);
            try {
                for (int i = 0; i < inputTuple.size(); ++i) {
                    Object d = outputConstraint.get(i);
                    if (d == null && i < exampleTuple.size()) {
                        d = exampleTuple.get(i);
                    }
                    inputTuple.set(i, d);
                }
                inputTuple.synthetic = outputConstraint instanceof ExampleTuple ? ((ExampleTuple)outputConstraint).synthetic : true;
            }
            catch (ExecException e) {
                this.log.error((Object)("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage()));
                throw new FrontendException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
            }
            try {
                if (!inputTuple.synthetic && this.inInput(inputTuple, inputData, schema)) continue;
                inputTuple.synthetic = true;
                newInputData.add(inputTuple);
                if (newInput) continue;
                newInput = true;
            }
            catch (ExecException e) {
                throw new FrontendException("Error visiting Load during Augmentation phase of Example Generator! " + e.getMessage());
            }
        }
    }

    private boolean inInput(Tuple newTuple, DataBag input, LogicalSchema schema) throws ExecException {
        Iterator<Tuple> iter = input.iterator();
        while (iter.hasNext()) {
            boolean result = true;
            Tuple tmp = iter.next();
            for (int i = 0; i < schema.size(); ++i) {
                if (newTuple.get(i).equals(tmp.get(i))) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(LOSort s) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(s);
        this.outputConstraintsMap.remove(s);
        if (outputConstraints == null) {
            this.outputConstraintsMap.put(s.getInput((LogicalPlan)this.plan), BagFactory.getInstance().newDefaultBag());
        } else {
            this.outputConstraintsMap.put(s.getInput((LogicalPlan)this.plan), outputConstraints);
        }
    }

    @Override
    public void visit(LOSplit split) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
    }

    @Override
    public void visit(LOStore store) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(store);
        if (outputConstraints == null) {
            this.outputConstraintsMap.put(this.plan.getPredecessors(store).get(0), BagFactory.getInstance().newDefaultBag());
        } else {
            this.outputConstraintsMap.remove(store);
            this.outputConstraintsMap.put(this.plan.getPredecessors(store).get(0), outputConstraints);
        }
    }

    @Override
    public void visit(LOUnion u) throws FrontendException {
        if (this.limit && !((PreOrderDepthFirstWalker)this.currentWalker).getBranchFlag()) {
            return;
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(u);
        this.outputConstraintsMap.remove(u);
        if (outputConstraints == null || outputConstraints.size() == 0L) {
            for (Operator op : u.getInputs((LogicalPlan)this.plan)) {
                DataBag constraints = BagFactory.getInstance().newDefaultBag();
                this.outputConstraintsMap.put(op, constraints);
            }
            return;
        }
        int count = 0;
        List<Operator> inputs = u.getInputs((LogicalPlan)this.plan);
        int noInputs = inputs.size();
        for (Operator op : inputs) {
            DataBag constraint = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(op, constraint);
        }
        Iterator<Tuple> it = outputConstraints.iterator();
        while (it.hasNext()) {
            DataBag constraint = this.outputConstraintsMap.get(inputs.get(count));
            constraint.add(it.next());
            count = (count + 1) % noInputs;
        }
    }

    @Override
    public void visit(LOLimit lm) throws FrontendException {
        if (!this.limit) {
            return;
        }
        if (this.oriLimitMap == null) {
            this.oriLimitMap = new HashMap<LOLimit, Long>();
        }
        DataBag outputConstraints = this.outputConstraintsMap.get(lm);
        this.outputConstraintsMap.remove(lm);
        DataBag inputConstraints = this.outputConstraintsMap.get(lm.getInput((LogicalPlan)this.plan));
        if (inputConstraints == null) {
            inputConstraints = BagFactory.getInstance().newDefaultBag();
            this.outputConstraintsMap.put(lm.getInput((LogicalPlan)this.plan), inputConstraints);
        }
        DataBag inputData = this.derivedData.get(lm.getInput((LogicalPlan)this.plan));
        if (outputConstraints != null && outputConstraints.size() > 0L) {
            Iterator<Tuple> it = outputConstraints.iterator();
            while (it.hasNext()) {
                inputConstraints.add(it.next());
                if (inputConstraints.size() != 1L) continue;
                inputConstraints.add(inputData.iterator().next());
                ((PreOrderDepthFirstWalker)this.currentWalker).setBranchFlag();
            }
        } else if (inputConstraints.size() == 0L) {
            inputConstraints.addAll(inputData);
            if (inputConstraints.size() == 1L) {
                inputConstraints.add(inputData.iterator().next());
                ((PreOrderDepthFirstWalker)this.currentWalker).setBranchFlag();
            }
        }
        POLimit poLimit = (POLimit)this.logToPhysMap.get(lm);
        this.oriLimitMap.put(lm, poLimit.getLimit());
        poLimit.setLimit(inputConstraints.size() - 1L);
        lm.setLimit(poLimit.getLimit());
    }

    Tuple GetGroupByInput(Object groupLabel, List<Integer> groupCols, int numFields) throws ExecException {
        Tuple t = TupleFactory.getInstance().newTuple(numFields);
        if (groupCols.size() == 1) {
            t.set(groupCols.get(0), groupLabel);
        } else {
            if (!(groupLabel instanceof Tuple)) {
                throw new RuntimeException("Unrecognized group label!");
            }
            Tuple group = (Tuple)groupLabel;
            for (int i = 0; i < groupCols.size(); ++i) {
                t.set(groupCols.get(i), group.get(i));
            }
        }
        return t;
    }

    Tuple GetJoinInput(Tuple group, List<Integer> groupCols0, List<Integer> groupCols, int numFields) throws ExecException {
        Tuple t = TupleFactory.getInstance().newTuple(numFields);
        if (groupCols.size() == 1) {
            t.set(groupCols.get(0), group.get(groupCols0.get(0)));
        } else {
            if (!(group instanceof Tuple)) {
                throw new RuntimeException("Unrecognized group label!");
            }
            for (int i = 0; i < groupCols.size(); ++i) {
                t.set(groupCols.get(i), group.get(groupCols0.get(i)));
            }
        }
        return t;
    }

    Tuple GetJoinInput(Tuple group, List<Integer> groupCols, int numFields) throws ExecException {
        Tuple t = TupleFactory.getInstance().newTuple(numFields);
        if (groupCols.size() == 1) {
            t.set(groupCols.get(0), group);
        } else {
            if (!(group instanceof Tuple)) {
                throw new RuntimeException("Unrecognized group label!");
            }
            for (int i = 0; i < groupCols.size(); ++i) {
                t.set(groupCols.get(i), group.get(i));
            }
        }
        return t;
    }

    Tuple BackPropConstraint(Tuple outputConstraint, List<Integer> cols, LogicalSchema inputSchema, boolean cast) throws ExecException {
        Tuple inputConst = TupleFactory.getInstance().newTuple(inputSchema.getFields().size());
        ExampleTuple inputConstraint = new ExampleTuple(inputConst);
        for (int outCol = 0; outCol < outputConstraint.size(); ++outCol) {
            int inCol = cols.get(outCol);
            Object outVal = outputConstraint.get(outCol);
            Object inVal = inputConstraint.get(inCol);
            if (inVal == null && outVal != null) {
                inputConstraint.set(inCol, cast ? new DataByteArray(outVal.toString().getBytes()) : outVal);
                continue;
            }
            if (outVal == null) continue;
            return null;
        }
        return inputConstraint;
    }

    ExampleTuple GenerateMatchingTuple(LogicalSchema schema, LogicalExpressionPlan plan, boolean invert) throws FrontendException, ExecException {
        return this.GenerateMatchingTuple(TupleFactory.getInstance().newTuple(schema.getFields().size()), plan, invert);
    }

    ExampleTuple GenerateMatchingTuple(Tuple constraint, LogicalExpressionPlan predicate, boolean invert) throws ExecException, FrontendException {
        Tuple t = TupleFactory.getInstance().newTuple(constraint.size());
        ExampleTuple tOut = new ExampleTuple(t);
        for (int i = 0; i < t.size(); ++i) {
            tOut.set(i, constraint.get(i));
        }
        this.GenerateMatchingTupleHelper((Tuple)tOut, predicate.getSources().get(0), invert);
        tOut.synthetic = true;
        return tOut;
    }

    void GenerateMatchingTupleHelper(Tuple t, Operator pred, boolean invert) throws FrontendException, ExecException {
        if (pred instanceof BinaryExpression) {
            this.GenerateMatchingTupleHelper(t, (BinaryExpression)pred, invert);
        } else if (pred instanceof NotExpression) {
            this.GenerateMatchingTupleHelper(t, (NotExpression)pred, invert);
        } else if (pred instanceof IsNullExpression) {
            this.GenerateMatchingTupleHelper(t, (IsNullExpression)pred, invert);
        } else if (pred instanceof UserFuncExpression) {
            t = null;
        } else {
            throw new FrontendException("Unknown operator in filter predicate");
        }
    }

    void GenerateMatchingTupleHelper(Tuple t, BinaryExpression pred, boolean invert) throws FrontendException, ExecException {
        Object d;
        if (pred instanceof AndExpression) {
            this.GenerateMatchingTupleHelper(t, (AndExpression)pred, invert);
            return;
        }
        if (pred instanceof OrExpression) {
            this.GenerateMatchingTupleHelper(t, (OrExpression)pred, invert);
            return;
        }
        boolean leftIsConst = false;
        boolean rightIsConst = false;
        Object leftConst = null;
        Object rightConst = null;
        byte leftDataType = 0;
        byte rightDataType = 0;
        int leftCol = -1;
        int rightCol = -1;
        if (pred instanceof AddExpression || pred instanceof SubtractExpression || pred instanceof MultiplyExpression || pred instanceof DivideExpression || pred instanceof ModExpression || pred instanceof RegexExpression) {
            return;
        }
        if (pred.getLhs() instanceof ConstantExpression) {
            leftIsConst = true;
            leftConst = ((ConstantExpression)pred.getLhs()).getValue();
        } else {
            LogicalExpression lhs = pred.getLhs();
            if (lhs instanceof CastExpression) {
                lhs = ((CastExpression)lhs).getExpression();
            }
            if (!(lhs instanceof ProjectExpression)) {
                return;
            }
            leftCol = ((ProjectExpression)lhs).getColNum();
            leftDataType = ((ProjectExpression)lhs).getType();
            d = t.get(leftCol);
            if (d != null) {
                leftIsConst = true;
                leftConst = d;
            }
        }
        if (pred.getRhs() instanceof ConstantExpression) {
            rightIsConst = true;
            rightConst = ((ConstantExpression)pred.getRhs()).getValue();
        } else {
            LogicalExpression rhs = pred.getRhs();
            if (rhs instanceof CastExpression) {
                rhs = ((CastExpression)rhs).getExpression();
            }
            if (!(rhs instanceof ProjectExpression)) {
                return;
            }
            rightCol = ((ProjectExpression)rhs).getColNum();
            rightDataType = ((ProjectExpression)rhs).getType();
            d = t.get(rightCol);
            if (d != null) {
                rightIsConst = true;
                rightConst = d;
            }
        }
        if (leftIsConst && rightIsConst) {
            return;
        }
        if (!invert) {
            if (pred instanceof EqualExpression) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, leftConst.toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, rightConst.toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "0"));
                }
            } else if (pred instanceof NotEqualExpression) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetUnequalValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetUnequalValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "1"));
                }
            } else if (pred instanceof GreaterThanExpression || pred instanceof GreaterThanEqualExpression) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetSmallerValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetLargerValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "1"));
                    t.set(rightCol, this.generateData(rightDataType, "0"));
                }
            } else if (pred instanceof LessThanExpression || pred instanceof LessThanEqualExpression) {
                if (leftIsConst) {
                    t.set(rightCol, this.generateData(rightDataType, this.GetLargerValue(leftConst).toString()));
                } else if (rightIsConst) {
                    t.set(leftCol, this.generateData(leftDataType, this.GetSmallerValue(rightConst).toString()));
                } else {
                    t.set(leftCol, this.generateData(leftDataType, "0"));
                    t.set(rightCol, this.generateData(rightDataType, "1"));
                }
            }
        } else if (pred instanceof EqualExpression) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetUnequalValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetUnequalValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "1"));
            }
        } else if (pred instanceof NotEqualExpression) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, leftConst.toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, rightConst.toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "0"));
            }
        } else if (pred instanceof GreaterThanExpression || pred instanceof GreaterThanEqualExpression) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetLargerValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetSmallerValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "0"));
                t.set(rightCol, this.generateData(rightDataType, "1"));
            }
        } else if (pred instanceof LessThanExpression || pred instanceof LessThanEqualExpression) {
            if (leftIsConst) {
                t.set(rightCol, this.generateData(rightDataType, this.GetSmallerValue(leftConst).toString()));
            } else if (rightIsConst) {
                t.set(leftCol, this.generateData(leftDataType, this.GetLargerValue(rightConst).toString()));
            } else {
                t.set(leftCol, this.generateData(leftDataType, "1"));
                t.set(rightCol, this.generateData(rightDataType, "0"));
            }
        }
    }

    void GenerateMatchingTupleHelper(Tuple t, AndExpression op, boolean invert) throws FrontendException, ExecException {
        LogicalExpression input = op.getLhs();
        this.GenerateMatchingTupleHelper(t, input, invert);
        input = op.getRhs();
        this.GenerateMatchingTupleHelper(t, input, invert);
    }

    void GenerateMatchingTupleHelper(Tuple t, OrExpression op, boolean invert) throws FrontendException, ExecException {
        LogicalExpression input = op.getLhs();
        this.GenerateMatchingTupleHelper(t, input, invert);
        input = op.getRhs();
        this.GenerateMatchingTupleHelper(t, input, invert);
    }

    void GenerateMatchingTupleHelper(Tuple t, NotExpression op, boolean invert) throws FrontendException, ExecException {
        LogicalExpression input = op.getExpression();
        this.GenerateMatchingTupleHelper(t, input, !invert);
    }

    void GenerateMatchingTupleHelper(Tuple t, IsNullExpression op, boolean invert) throws FrontendException, ExecException {
        byte type = op.getExpression().getType();
        if (!invert) {
            t.set(0, null);
        } else {
            t.set(0, this.generateData(type, "0"));
        }
    }

    Object GetUnequalValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        Object zero = this.generateData(type, "0");
        if (v.equals(zero)) {
            return this.generateData(type, "1");
        }
        return zero;
    }

    Object GetSmallerValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        switch (type) {
            case 55: {
                String str = (String)v;
                if (str.length() > 0) {
                    return str.substring(0, str.length() - 1);
                }
                return null;
            }
            case 50: {
                DataByteArray data = (DataByteArray)v;
                if (data.size() > 0) {
                    return new DataByteArray(data.get(), 0, data.size() - 1);
                }
                return null;
            }
            case 10: {
                return (Integer)v - 1;
            }
            case 15: {
                return (Long)v - 1L;
            }
            case 20: {
                return Float.valueOf(((Float)v).floatValue() - 1.0f);
            }
            case 25: {
                return (Double)v - 1.0;
            }
            case 30: {
                DateTime dt = (DateTime)v;
                if (dt.getMillisOfSecond() != 0) {
                    return dt.minusMillis(1);
                }
                if (dt.getSecondOfMinute() != 0) {
                    return dt.minusSeconds(1);
                }
                if (dt.getMinuteOfHour() != 0) {
                    return dt.minusMinutes(1);
                }
                if (dt.getHourOfDay() != 0) {
                    return dt.minusHours(1);
                }
                return dt.minusDays(1);
            }
        }
        return null;
    }

    Object GetLargerValue(Object v) {
        byte type = DataType.findType(v);
        if (type == 120 || type == 110 || type == 100) {
            return null;
        }
        switch (type) {
            case 55: {
                return (String)v + "0";
            }
            case 50: {
                String str = ((DataByteArray)v).toString();
                str = str + "0";
                return new DataByteArray(str);
            }
            case 10: {
                return (Integer)v + 1;
            }
            case 15: {
                return (Long)v + 1L;
            }
            case 20: {
                return Float.valueOf(((Float)v).floatValue() + 1.0f);
            }
            case 25: {
                return (Double)v + 1.0;
            }
            case 30: {
                DateTime dt = (DateTime)v;
                if (dt.getMillisOfSecond() != 0) {
                    return dt.plusMillis(1);
                }
                if (dt.getSecondOfMinute() != 0) {
                    return dt.plusSeconds(1);
                }
                if (dt.getMinuteOfHour() != 0) {
                    return dt.plusMinutes(1);
                }
                if (dt.getHourOfDay() != 0) {
                    return dt.plusHours(1);
                }
                return dt.plusDays(1);
            }
        }
        return null;
    }

    Object generateData(byte type, String data) {
        switch (type) {
            case 5: {
                if (data.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (data.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case 50: {
                return new DataByteArray(data.getBytes());
            }
            case 25: {
                return Double.valueOf(data);
            }
            case 20: {
                return Float.valueOf(data);
            }
            case 10: {
                return Integer.valueOf(data);
            }
            case 15: {
                return Long.valueOf(data);
            }
            case 30: {
                return new DateTime((Object)data);
            }
            case 55: {
                return data;
            }
        }
        return null;
    }
}

