/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.CloudStorageAccount;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobListingDetails;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlobDirectory;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import com.microsoft.windowsazure.storage.blob.CopyState;
import com.microsoft.windowsazure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.windowsazure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.fs.azurenative.StorageInterface;

class StorageInterfaceImpl
extends StorageInterface {
    private CloudBlobClient serviceClient;

    StorageInterfaceImpl() {
    }

    @Override
    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.serviceClient.setRetryPolicyFactory(retryPolicyFactory);
    }

    @Override
    public void setTimeoutInMs(int timeoutInMs) {
        this.serviceClient.setTimeoutInMs(timeoutInMs);
    }

    @Override
    public void createBlobClient(CloudStorageAccount account) {
        this.serviceClient = account.createCloudBlobClient();
    }

    @Override
    public void createBlobClient(URI baseUri) {
        this.serviceClient = new CloudBlobClient(baseUri);
    }

    @Override
    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        this.serviceClient = new CloudBlobClient(baseUri, credentials);
    }

    @Override
    public StorageCredentials getCredentials() {
        return this.serviceClient.getCredentials();
    }

    @Override
    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String uri) throws URISyntaxException, StorageException {
        return new CloudBlobContainerWrapperImpl(this.serviceClient.getContainerReference(uri));
    }

    static class CloudBlockBlobWrapperImpl
    extends StorageInterface.CloudBlockBlobWrapper {
        private final CloudBlockBlob blob;

        @Override
        public URI getUri() {
            return this.blob.getUri();
        }

        public CloudBlockBlobWrapperImpl(CloudBlockBlob blob) {
            this.blob = blob;
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.blob.getMetadata();
        }

        @Override
        public void startCopyFromBlob(StorageInterface.CloudBlockBlobWrapper sourceBlob, OperationContext opContext) throws StorageException, URISyntaxException {
            this.blob.startCopyFromBlob((CloudBlob)((CloudBlockBlobWrapperImpl)sourceBlob).blob, null, null, null, opContext);
        }

        @Override
        public void delete(OperationContext opContext) throws StorageException {
            this.blob.delete(DeleteSnapshotsOption.NONE, null, null, opContext);
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.blob.exists(null, null, opContext);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.blob.downloadAttributes(null, null, opContext);
        }

        @Override
        public BlobProperties getProperties() {
            return this.blob.getProperties();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.blob.setMetadata(metadata);
        }

        @Override
        public InputStream openInputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return this.blob.openInputStream(null, options, opContext);
        }

        @Override
        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return this.blob.openOutputStream(null, options, opContext);
        }

        @Override
        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.blob.upload(sourceStream, 0L, null, null, opContext);
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.blob.getContainer();
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.blob.getParent();
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.blob.uploadMetadata(null, null, opContext);
        }

        @Override
        public void uploadProperties(OperationContext opContext) throws StorageException {
            this.blob.uploadProperties(null, null, opContext);
        }

        @Override
        public void setStreamMinimumReadSizeInBytes(int minimumReadSizeBytes) {
            this.blob.setStreamMinimumReadSizeInBytes(minimumReadSizeBytes);
        }

        @Override
        public void setWriteBlockSizeInBytes(int writeBlockSizeBytes) {
            this.blob.setStreamWriteSizeInBytes(writeBlockSizeBytes);
        }

        public StorageUri getStorageUri() {
            return this.blob.getStorageUri();
        }

        @Override
        public CopyState getCopyState() {
            return this.blob.getCopyState();
        }
    }

    static class CloudBlobContainerWrapperImpl
    extends StorageInterface.CloudBlobContainerWrapper {
        private final CloudBlobContainer container;

        public CloudBlobContainerWrapperImpl(CloudBlobContainer container) {
            this.container = container;
        }

        @Override
        public String getName() {
            return this.container.getName();
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.container.exists(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void create(OperationContext opContext) throws StorageException {
            this.container.create(null, opContext);
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.container.getMetadata();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.container.setMetadata(metadata);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.container.downloadAttributes(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.container.uploadMetadata(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public StorageInterface.CloudBlobDirectoryWrapper getDirectoryReference(String relativePath) throws URISyntaxException, StorageException {
            CloudBlobDirectory dir = this.container.getDirectoryReference(relativePath);
            return new CloudBlobDirectoryWrapperImpl(dir);
        }

        @Override
        public StorageInterface.CloudBlockBlobWrapper getBlockBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new CloudBlockBlobWrapperImpl(this.container.getBlockBlobReference(relativePath));
        }
    }

    static class CloudBlobDirectoryWrapperImpl
    extends StorageInterface.CloudBlobDirectoryWrapper {
        private final CloudBlobDirectory directory;

        public CloudBlobDirectoryWrapperImpl(CloudBlobDirectory directory) {
            this.directory = directory;
        }

        @Override
        public URI getUri() {
            return this.directory.getUri();
        }

        @Override
        public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
            return WrappingIterator.Wrap(this.directory.listBlobs(prefix, useFlatBlobListing, listingDetails, options, opContext));
        }

        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.directory.getContainer();
        }

        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.directory.getParent();
        }

        public StorageUri getStorageUri() {
            return this.directory.getStorageUri();
        }
    }

    private static class WrappingIterator
    implements Iterator<ListBlobItem> {
        private final Iterator<ListBlobItem> present;

        public WrappingIterator(Iterator<ListBlobItem> present) {
            this.present = present;
        }

        public static Iterable<ListBlobItem> Wrap(final Iterable<ListBlobItem> present) {
            return new Iterable<ListBlobItem>(){

                @Override
                public Iterator<ListBlobItem> iterator() {
                    return new WrappingIterator(present.iterator());
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.present.hasNext();
        }

        @Override
        public ListBlobItem next() {
            ListBlobItem unwrapped = this.present.next();
            if (unwrapped instanceof CloudBlobDirectory) {
                return new CloudBlobDirectoryWrapperImpl((CloudBlobDirectory)unwrapped);
            }
            if (unwrapped instanceof CloudBlockBlob) {
                return new CloudBlockBlobWrapperImpl((CloudBlockBlob)unwrapped);
            }
            return unwrapped;
        }

        @Override
        public void remove() {
            this.present.remove();
        }
    }
}

