/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints;

import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDomainStatusMessage;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.services.interfaces.IRDO;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IPluginDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IStatusMessageDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.responses.IterablePluginOperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.StringOperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.base.OperationResultDTO;
import org.pentaho.marketplace.endpoints.dtos.responses.base.StatusMessageDTO;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/marketplace/api")
public class MarketplaceService {
    private IRDO RDO;
    private IPluginDTOMapper pluginDTOMapper;
    private IStatusMessageDTOMapper statusMessageDTOMapper;

    @Autowired
    public MarketplaceService(IRDO rdo, IPluginDTOMapper pluginDTOMapper, IStatusMessageDTOMapper statusMessageDTOMapper) {
        this.RDO = rdo;
        this.pluginDTOMapper = pluginDTOMapper;
        this.statusMessageDTOMapper = statusMessageDTOMapper;
    }

    @GET
    @Path(value="/hello")
    @Produces(value={"application/json"})
    public StringOperationResultDTO hello() {
        StringOperationResultDTO result = new StringOperationResultDTO();
        result.string = "Hello World from Marketplace!";
        result.statusMessage.code = "OK_CODE";
        result.statusMessage.message = "OK_MESSAGE";
        return result;
    }

    @GET
    @Path(value="/plugins")
    @Produces(value={"application/json"})
    public IterablePluginOperationResultDTO getPlugins() {
        Collection<IPlugin> plugins = this.RDO.getPluginService().getPlugins();
        IterablePluginOperationResultDTO result = new IterablePluginOperationResultDTO();
        result.plugins = this.pluginDTOMapper.toDTOs(plugins);
        result.statusMessage.code = "OK_CODE";
        result.statusMessage.message = "OK_MESSAGE";
        return result;
    }

    @POST
    @Path(value="/plugin/{pluginId}/{versionBranch}")
    @Produces(value={"application/json"})
    public OperationResultDTO installPlugin(@PathParam(value="pluginId") String pluginId, @PathParam(value="versionBranch") String versionBranch) {
        IDomainStatusMessage statusMessage = this.RDO.getPluginService().installPlugin(pluginId, versionBranch);
        OperationResultDTO result = new OperationResultDTO();
        result.statusMessage = (StatusMessageDTO)this.statusMessageDTOMapper.toDTO(statusMessage);
        return result;
    }

    @DELETE
    @Path(value="/plugin/{pluginId}")
    @Produces(value={"application/json"})
    public OperationResultDTO uninstallPlugin(@PathParam(value="pluginId") String pluginId) {
        IDomainStatusMessage statusMessage = this.RDO.getPluginService().uninstallPlugin(pluginId);
        OperationResultDTO result = new OperationResultDTO();
        result.statusMessage = (StatusMessageDTO)this.statusMessageDTOMapper.toDTO(statusMessage);
        return result;
    }
}

