/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints.dtos.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginFactory;
import org.pentaho.marketplace.endpoints.dtos.entities.CategoryDTO;
import org.pentaho.marketplace.endpoints.dtos.entities.PluginDTO;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.ICategoryDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IPluginDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IPluginVersionDTOMapper;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginDTOMapper
implements IPluginDTOMapper {
    IPluginFactory pluginFactory;
    IPluginVersionDTOMapper pluginVersionDTOMapper;
    ICategoryDTOMapper categoryDTOMapper;

    @Autowired
    public PluginDTOMapper(IPluginFactory pluginFactory, IPluginVersionDTOMapper pluginVersionDTOMapper, ICategoryDTOMapper categoryDTOMapper) {
        this.pluginFactory = pluginFactory;
        this.pluginVersionDTOMapper = pluginVersionDTOMapper;
        this.categoryDTOMapper = categoryDTOMapper;
    }

    @Override
    public IPlugin toEntity(PluginDTO dto) {
        IPlugin plugin = (IPlugin)this.pluginFactory.create();
        plugin.setId(dto.id);
        plugin.setName(dto.name);
        plugin.setImg(dto.img);
        plugin.setSmallImg(dto.smallImg);
        plugin.setDocumentationUrl(dto.documentationUrl);
        plugin.setDescription(dto.description);
        plugin.setAuthorName(dto.authorName);
        plugin.setAuthorUrl(dto.authorUrl);
        plugin.setAuthorLogo(dto.authorLogo);
        plugin.setInstalledBranch(dto.installedBranch);
        plugin.setInstalledVersion(dto.installedVersion);
        plugin.setInstalledBuildId(dto.installedBuildId);
        plugin.setInstallationNotes(dto.installationNotes);
        plugin.setInstalled(dto.installed);
        plugin.setVersions(this.pluginVersionDTOMapper.toEntities(dto.versions));
        plugin.setScreenshots(dto.screenshots);
        plugin.setDependencies(dto.dependencies);
        plugin.setLicense(dto.license);
        return plugin;
    }

    @Override
    public PluginDTO toDTO(IPlugin plugin) {
        PluginDTO dto = new PluginDTO();
        dto.id = plugin.getId();
        dto.name = plugin.getName();
        dto.img = plugin.getImg();
        dto.smallImg = plugin.getSmallImg();
        dto.documentationUrl = plugin.getDocumentationUrl();
        dto.description = plugin.getDescription();
        dto.authorName = plugin.getAuthorName();
        dto.authorUrl = plugin.getAuthorUrl();
        dto.authorLogo = plugin.getAuthorLogo();
        dto.installedBranch = plugin.getInstalledBranch();
        dto.installedVersion = plugin.getInstalledVersion();
        dto.installedBuildId = plugin.getInstalledBuildId();
        dto.installationNotes = plugin.getInstallationNotes();
        dto.installed = plugin.isInstalled();
        dto.versions = this.pluginVersionDTOMapper.toDTOs(plugin.getVersions());
        dto.screenshots = plugin.getScreenshots();
        dto.dependencies = plugin.getDependencies();
        dto.license = plugin.getLicense();
        dto.category = (CategoryDTO)this.categoryDTOMapper.toDTO(plugin.getCategory());
        return dto;
    }

    @Override
    public Collection<IPlugin> toEntities(List<PluginDTO> dtos) {
        ArrayList<IPlugin> plugins = new ArrayList<IPlugin>();
        for (PluginDTO dto : dtos) {
            plugins.add(this.toEntity(dto));
        }
        return plugins;
    }

    @Override
    public List<PluginDTO> toDTOs(Collection<IPlugin> plugins) {
        ArrayList<PluginDTO> pluginDTOs = new ArrayList<PluginDTO>();
        for (IPlugin plugin : plugins) {
            pluginDTOs.add(this.toDTO(plugin));
        }
        return pluginDTOs;
    }
}

