/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.endpoints.dtos.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.marketplace.domain.model.entities.interfaces.IDomainStatusMessage;
import org.pentaho.marketplace.domain.model.factories.interfaces.IDomainStatusMessageFactory;
import org.pentaho.marketplace.endpoints.dtos.mappers.interfaces.IStatusMessageDTOMapper;
import org.pentaho.marketplace.endpoints.dtos.responses.base.StatusMessageDTO;
import org.springframework.beans.factory.annotation.Autowired;

public class StatusMessageDTOMapper
implements IStatusMessageDTOMapper {
    IDomainStatusMessageFactory statusMessageFactory;

    @Autowired
    public StatusMessageDTOMapper(IDomainStatusMessageFactory domainStatusMessageFactory) {
        this.statusMessageFactory = domainStatusMessageFactory;
    }

    @Override
    public IDomainStatusMessage toEntity(StatusMessageDTO dto) {
        IDomainStatusMessage statusMessage = (IDomainStatusMessage)this.statusMessageFactory.create();
        statusMessage.setCode(dto.code);
        statusMessage.setMessage(dto.message);
        return statusMessage;
    }

    @Override
    public StatusMessageDTO toDTO(IDomainStatusMessage statusMessage) {
        StatusMessageDTO dto = new StatusMessageDTO();
        dto.code = statusMessage.getCode();
        dto.message = statusMessage.getMessage();
        return dto;
    }

    @Override
    public Collection<IDomainStatusMessage> toEntities(List<StatusMessageDTO> dtos) {
        ArrayList<IDomainStatusMessage> statusMessages = new ArrayList<IDomainStatusMessage>();
        for (StatusMessageDTO dto : dtos) {
            statusMessages.add(this.toEntity(dto));
        }
        return statusMessages;
    }

    @Override
    public List<StatusMessageDTO> toDTOs(Collection<IDomainStatusMessage> statusMessages) {
        ArrayList<StatusMessageDTO> statusMessageDTOs = new ArrayList<StatusMessageDTO>();
        for (IDomainStatusMessage statusMessage : statusMessages) {
            statusMessageDTOs.add(this.toDTO(statusMessage));
        }
        return statusMessageDTOs;
    }
}

