/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.telemetry.ITelemetryDataProvider;
import org.pentaho.telemetry.TelemetryHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BaPluginTelemetry {
    private static Log logger = LogFactory.getLog(TelemetryHelper.class);
    private ITelemetryDataProvider baPluginTelemetryDataProvider;
    private final String pluginName;
    private final String pluginVersion;
    protected static final VersionInfo versionInfo;

    public BaPluginTelemetry(String pluginName) {
        this.pluginName = pluginName;
        this.pluginVersion = this.getPluginVersion();
    }

    public boolean sendTelemetryRequest(final TelemetryHelper.TelemetryEventType eventType, final Map<String, String> extraInfo) {
        this.baPluginTelemetryDataProvider = new ITelemetryDataProvider(){

            @Override
            public String getPlatformVersion() {
                return versionInfo.getVersionNumber();
            }

            @Override
            public String getPluginName() {
                return BaPluginTelemetry.this.pluginName;
            }

            @Override
            public String getPluginVersion() {
                return BaPluginTelemetry.this.pluginVersion;
            }

            @Override
            public Map<String, String> getExtraInformation() {
                return extraInfo;
            }

            @Override
            public TelemetryHelper.TelemetryEventType getEventType() {
                return eventType;
            }

            @Override
            public boolean isTelemetryEnabled() {
                return BaPluginTelemetry.this.isPluginTelemetryEnabled();
            }

            @Override
            public String getBaseUrl() {
                return BaPluginTelemetry.this.getTelemetryBaseUrlFromPlugin();
            }
        };
        TelemetryHelper th = new TelemetryHelper();
        th.setDataProvider(this.baPluginTelemetryDataProvider);
        return th.publishTelemetryEvent();
    }

    public boolean isPluginTelemetryEnabled() {
        return Boolean.parseBoolean(PentahoSystem.getSystemSetting((String)"telemetry", (String)"true"));
    }

    protected String getTelemetryBaseUrlFromPlugin() {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String baseUrl = null;
        try {
            baseUrl = resLoader.getPluginSetting(this.getClass(), "settings/telemetry-site");
        }
        catch (Exception e) {
            logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (baseUrl == null || "".equals(baseUrl)) {
            logger.warn((Object)("Telemetry url is not set for plugin " + this.pluginName + ". Defaulting to a bogus local url"));
            baseUrl = "https://localhost:8080/pentaho/telemetry";
        }
        return baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPluginVersion() {
        block18: {
            String string;
            String versionPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + this.pluginName + "/version.xml");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            InputStreamReader reader = null;
            try {
                File file = new File(versionPath);
                if (!file.exists()) {
                    String string2 = "Unknown";
                    return string2;
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new InputSource(reader = new FileReader(versionPath)));
                NodeList versionElements = dom.getElementsByTagName("version");
                if (versionElements.getLength() < 1) break block18;
                Element versionElement = (Element)versionElements.item(0);
                string = versionElement.getAttribute("branch") + "-" + versionElement.getTextContent();
            }
            catch (Exception e) {
                logger.error((Object)("Error while trying to read plugin version for " + this.pluginName), (Throwable)e);
                break block18;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {}
            }
            return string;
        }
        return "Unknown";
    }

    static {
        IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
        versionInfo = versionHelper != null ? VersionHelper.getVersionInfo(versionHelper.getClass()) : VersionHelper.getVersionInfo(PentahoSystem.class);
    }
}

