/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.telemetry.TelemetryEvent;

public class TelemetryEventSender
implements Runnable {
    private static final int DAYS_TO_KEEP_FILES = 5;
    private static final int BLOCK_SIZE = 50;
    private static final Log logger = LogFactory.getLog(TelemetryEventSender.class);
    protected static PostMethod defaultHttpMethod;
    protected static HttpClient defaultHttpClient;
    protected File lastSubmissionDir;
    private File telemetryDir;

    public TelemetryEventSender(File lastSubmissionDir, File telemetryDir) {
        this.lastSubmissionDir = lastSubmissionDir;
        this.telemetryDir = telemetryDir;
    }

    protected static HttpClient getHttpClient() {
        return defaultHttpClient != null ? defaultHttpClient : new HttpClient();
    }

    protected static PostMethod getHttpMethod() {
        return defaultHttpMethod != null ? defaultHttpMethod : new PostMethod();
    }

    protected void sendRequest(File[] blockToSend) {
        Object baseUrl = null;
        HashMap<String, StringBuffer> urlsAndPostData = new HashMap<String, StringBuffer>();
        HashMap<String, ArrayList<File>> urlsAndFiles = new HashMap<String, ArrayList<File>>();
        for (File f : blockToSend) {
            if (f == null) break;
            try {
                FileInputStream fin = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fin);
                TelemetryEvent event = (TelemetryEvent)ois.readObject();
                ois.close();
                StringBuffer postData = (StringBuffer)urlsAndPostData.get(event.getUrlToCall());
                if (postData == null) {
                    postData = new StringBuffer().append("[");
                } else {
                    postData.append(", ");
                }
                postData.append(event.encodeEvent());
                urlsAndPostData.put(event.getUrlToCall(), postData);
                ArrayList<File> filesForThisUrl = (ArrayList<File>)urlsAndFiles.get(event.getUrlToCall());
                if (filesForThisUrl == null) {
                    filesForThisUrl = new ArrayList<File>();
                }
                filesForThisUrl.add(f);
                urlsAndFiles.put(event.getUrlToCall(), filesForThisUrl);
            }
            catch (EOFException eofe) {
                logger.warn((Object)"EOF caught while deserializing telemetry event. Probably a corrupt save. Deleting event.", (Throwable)eofe);
                f.delete();
            }
            catch (IOException ioe) {
                logger.error((Object)"Error caught while deserializing telemetry event.", (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                logger.error((Object)"Class not found while deserializing telemetry event.", (Throwable)cnfe);
            }
        }
        for (String url : urlsAndPostData.keySet()) {
            StringBuffer postData = (StringBuffer)urlsAndPostData.get(url);
            postData.append("]");
            postData.append(System.getProperty("line.separator"));
            boolean success = true;
            try {
                HttpClient httpClient = TelemetryEventSender.getHttpClient();
                PostMethod httpMethod = TelemetryEventSender.getHttpMethod();
                int timeout = 30000;
                httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
                httpMethod.setURI(new URI(url, true));
                Part[] parts = new Part[]{new StringPart("body", postData.toString())};
                httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(postData.toString(), "application/json", "UTF8"));
                logger.info((Object)("Calling " + url));
                logger.info((Object)("Data: " + postData.toString()));
                int resultCode = httpClient.executeMethod((HttpMethod)httpMethod);
                if (resultCode != 200) {
                    logger.error((Object)("Invalid Result Code Returned: " + resultCode));
                    success = false;
                } else {
                    String resultXml = httpMethod.getResponseBodyAsString();
                    if (resultXml.indexOf("<result>OK</result>") < 0) {
                        logger.warn((Object)("Telemetry request had unexpected result: " + resultXml + "."));
                        success = false;
                    }
                }
                httpMethod.releaseConnection();
            }
            catch (Exception e) {
                logger.warn((Object)"Exception caught while making telemetry request.", (Throwable)e);
                success = false;
            }
            if (!success) continue;
            for (File f : blockToSend) {
                if (f == null) continue;
                File newFile = new File(this.lastSubmissionDir, f.getName());
                f.renameTo(newFile);
                f.delete();
            }
        }
    }

    @Override
    public void run() {
        File[] submittedFiles;
        for (File f : submittedFiles = this.lastSubmissionDir.listFiles()) {
            f.delete();
        }
        File[] unsubmittedRequests = this.telemetryDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".tel");
            }
        });
        File[] block = new File[50];
        int blockIndex = 0;
        Calendar cld = Calendar.getInstance();
        cld.add(6, -5);
        for (File f : unsubmittedRequests) {
            if (f.lastModified() < cld.getTime().getTime()) {
                f.delete();
                continue;
            }
            if (blockIndex > 0 && blockIndex % 50 == 0) {
                this.sendRequest(block);
                block = new File[50];
                blockIndex = 0;
                continue;
            }
            block[blockIndex] = f;
            ++blockIndex;
        }
        if (blockIndex > 0) {
            this.sendRequest(block);
        }
    }
}

