/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NetworkNode;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;

public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.partitionId = (RuleBasePartitionId)in.readObject();
        this.partitionsEnabled = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.partitionId);
        out.writeBoolean(this.partitionsEnabled);
    }

    public int getId() {
        return this.id;
    }

    public abstract void attach();

    public abstract void attach(InternalWorkingMemory[] var1);

    public abstract void networkUpdated();

    public void remove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.doRemove(context, builder, node, workingMemories);
        if (!this.isInUse()) {
            builder.getIdGenerator().releaseId(this.getId());
        }
    }

    protected abstract void doRemove(RuleRemovalContext var1, ReteooBuilder var2, BaseNode var3, InternalWorkingMemory[] var4);

    public abstract boolean isInUse();

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }
}

