/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.haivvreo;

import com.linkedin.haivvreo.AvroGenericRecordWritable;
import com.linkedin.haivvreo.HaivvreoException;
import com.linkedin.haivvreo.HaivvreoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AvroGenericRecordReader
implements RecordReader<NullWritable, AvroGenericRecordWritable>,
JobConfigurable {
    private static final Log LOG = LogFactory.getLog(AvroGenericRecordReader.class);
    private final FileReader<GenericRecord> reader;
    private final long start;
    private final long stop;
    protected JobConf jobConf;

    public AvroGenericRecordReader(JobConf job, FileSplit split, Reporter reporter) throws IOException {
        Schema latest;
        this.jobConf = job;
        try {
            latest = this.getSchema(job, split);
        }
        catch (HaivvreoException e) {
            throw new IOException((Throwable)((Object)e));
        }
        GenericDatumReader gdr = new GenericDatumReader();
        if (latest != null) {
            gdr.setExpected(latest);
        }
        this.reader = new DataFileReader((SeekableInput)new FsInput(split.getPath(), (Configuration)job), (DatumReader)gdr);
        this.reader.sync(split.getStart());
        this.start = this.reader.tell();
        this.stop = split.getStart() + split.getLength();
    }

    private Schema getSchema(JobConf job, FileSplit split) throws HaivvreoException, IOException {
        String s = job.get("haivvreo.schema");
        if (s != null) {
            return Schema.parse((String)s);
        }
        if (Utilities.getHiveJobID((Configuration)job) != null) {
            MapredWork mapRedWork = Utilities.getMapRedWork((Configuration)job);
            for (Map.Entry pathsAndParts : mapRedWork.getPathToPartitionInfo().entrySet()) {
                Properties props;
                String partitionPath = (String)pathsAndParts.getKey();
                if (!this.pathIsInPartition(split, partitionPath)) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Matching partition " + partitionPath + " with input split " + split));
                }
                if ((props = ((PartitionDesc)pathsAndParts.getValue()).getProperties()).containsKey("schema.literal") || props.containsKey("schema.url")) {
                    return HaivvreoUtils.determineSchemaOrThrowException(props);
                }
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Unable to match filesplit " + split + " with a partition."));
            }
        }
        return null;
    }

    private boolean pathIsInPartition(FileSplit split, String partitionPath) {
        return split.getPath().toString().startsWith(partitionPath);
    }

    public boolean next(NullWritable nullWritable, AvroGenericRecordWritable record) throws IOException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.stop)) {
            return false;
        }
        GenericData.Record r = (GenericData.Record)this.reader.next();
        record.setRecord((GenericRecord)r);
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public AvroGenericRecordWritable createValue() {
        return new AvroGenericRecordWritable();
    }

    public long getPos() throws IOException {
        return this.reader.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException {
        return this.stop == this.start ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.stop - this.start));
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }
}

