/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectUtilities {
    private static final Log LOGGER = LogFactory.getLog(ObjectUtilities.class);
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;
    private static final Integer[] EMPTY_VERSIONS;

    private ObjectUtilities() {
    }

    public static String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static void setClassLoaderSource(String classLoaderSource) {
        ObjectUtilities.classLoaderSource = classLoaderSource;
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static boolean equals(File file1, File file2) {
        if (file1 == file2) {
            return true;
        }
        if (file1 != null && file2 != null) {
            try {
                return file1.getCanonicalFile().equals(file2.getCanonicalFile());
            }
            catch (IOException ioe) {
                return file1.equals(file2);
            }
        }
        return false;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        Class<?> aClass = object.getClass();
        if (aClass.isArray()) {
            int length = Array.getLength(object);
            Object clone = Array.newInstance(aClass.getComponentType(), length);
            System.arraycopy(object, 0, clone, 0, length);
            return object;
        }
        try {
            Method method = aClass.getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, (Object[])null);
            }
            throw new CloneNotSupportedException("Failed to clone: Method 'clone()' is not public on class " + aClass);
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn((Object)("Object without clone() method is impossible on class " + aClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn((Object)("Object.clone(): unable to call method 'clone()'  on class " + aClass), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn((Object)("Object without clone() method is impossible on class " + aClass), (Throwable)e);
        }
        throw new CloneNotSupportedException("Failed to clone: Clone caused an Exception while cloning type " + aClass);
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(Class c) {
        Class<ObjectUtilities> clazz = ObjectUtilities.class;
        synchronized (ObjectUtilities.class) {
            ClassLoader threadLoader;
            if (classLoader != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return classLoader;
            }
            String localClassLoaderSource = classLoaderSource;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (THREAD_CONTEXT.equals(localClassLoaderSource) && (threadLoader = Thread.currentThread().getContextClassLoader()) != null) {
                return threadLoader;
            }
            ClassLoader applicationCL = c.getClassLoader();
            if (applicationCL == null) {
                return ClassLoader.getSystemClassLoader();
            }
            return applicationCL;
        }
    }

    public static URL getResource(String name, Class c) {
        if (name == null) {
            throw new NullPointerException();
        }
        ClassLoader cl = ObjectUtilities.getClassLoader(c);
        if (cl == null) {
            return null;
        }
        return cl.getResource(name);
    }

    public static URL getResourceRelative(String name, Class c) {
        if (name == null) {
            throw new NullPointerException();
        }
        ClassLoader cl = ObjectUtilities.getClassLoader(c);
        String cname = ObjectUtilities.convertName(name, c);
        if (cl == null) {
            return null;
        }
        return cl.getResource(cname);
    }

    private static String convertName(String name, Class c) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            return name.substring(1);
        }
        while (c.isArray()) {
            c = c.getComponentType();
        }
        String baseName = c.getName();
        int index = baseName.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        String pkgName = baseName.substring(0, index);
        return pkgName.replace('.', '/') + '/' + name;
    }

    public static InputStream getResourceAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResource(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getResourceRelativeAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResourceRelative(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Object loadAndInstantiate(String className, Class source) {
        return ObjectUtilities.loadAndInstantiate(className, source, null);
    }

    public static <T> T loadAndInstantiate(String className, Class source, Class<T> type) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c = Class.forName(className, false, loader);
            if (type != null && !type.isAssignableFrom(c)) {
                LOGGER.warn((Object)("Specified class " + className + " is not of expected type " + type));
                return null;
            }
            return (T)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Specified class " + className + " does not exist."), (Throwable)e);
            }
        }
        catch (NoClassDefFoundError e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Specified class " + className + " cannot be loaded [NOCLASSDEFERROR]."), (Throwable)e);
            }
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info((Object)("Specified class " + className + " failed to instantiate correctly."), e);
            }
            LOGGER.info((Object)("Specified class " + className + " failed to instantiate correctly."));
        }
        return null;
    }

    public static boolean isJDK14() {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ObjectUtilities.class);
            if (loader != null) {
                try {
                    Class.forName("java.util.RandomAccess", false, loader);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String version = System.getProperty("java.vm.specification.version");
            if (version == null) {
                return false;
            }
            Integer[] versions = ObjectUtilities.parseVersions(version);
            Integer[] target = new Integer[]{new Integer(1), new Integer(4)};
            return ObjectUtilities.compareVersionArrays(versions, target) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int compareVersionArrays(Integer[] a1, Integer[] a2) {
        int length = Math.min(a1.length, a2.length);
        for (int i = 0; i < length; ++i) {
            Integer o1 = a1[i];
            Integer o2 = a2[i];
            if (o1 == null && o2 == null) continue;
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int retval = o1.compareTo(o2);
            if (retval == 0) continue;
            return retval;
        }
        return 0;
    }

    public static Integer[] parseVersions(String version) {
        if (version == null) {
            return EMPTY_VERSIONS;
        }
        ArrayList<Integer> versions = new ArrayList<Integer>();
        StringTokenizer strtok = new StringTokenizer(version, ".");
        while (strtok.hasMoreTokens()) {
            try {
                versions.add(new Integer(strtok.nextToken()));
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        return versions.toArray(new Integer[versions.size()]);
    }

    public static boolean equalArray(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        return Arrays.equals(array1, array2);
    }

    public static int hashCode(Object[] array1) {
        if (array1 == null) {
            return 0;
        }
        return Arrays.hashCode(array1);
    }

    static {
        EMPTY_VERSIONS = new Integer[0];
    }
}

