/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import pt.webdetails.cpf.RequestHandler;
import pt.webdetails.cpf.ResponseWrapper;
import pt.webdetails.cpf.RestRequestHandler;
import pt.webdetails.cpf.http.ICommonParameterProvider;
import pt.webdetails.cpf.scripting.IGlobalScope;
import pt.webdetails.cpf.utils.CharsetHelper;

public class Router
implements RestRequestHandler {
    private Map<Key, Callable> javaScriptHandlers = new HashMap<Key, Callable>();
    private Map<Key, RequestHandler> javaHandlers = new HashMap<Key, RequestHandler>();
    private static Router _instance;
    protected static final Log logger;
    private static IGlobalScope globalScope;

    public static synchronized Router getBaseRouter() {
        if (_instance == null) {
            _instance = new Router(globalScope);
        }
        return _instance;
    }

    public static synchronized Router resetBaseRouter() {
        _instance = new Router(globalScope);
        return _instance;
    }

    public Router(IGlobalScope globalScope) {
        Router.globalScope = globalScope;
    }

    public void call(OutputStream out, ICommonParameterProvider pathParams, ICommonParameterProvider requestParams) {
        this.route(RestRequestHandler.HttpMethod.GET, "", out, pathParams, requestParams);
    }

    @Override
    public boolean canHandle(RestRequestHandler.HttpMethod method, String path) {
        Key key = new Key(method, path);
        return this.javaScriptHandlers.containsKey(key) || this.javaHandlers.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void route(RestRequestHandler.HttpMethod method, String path, OutputStream out, ICommonParameterProvider pathParams, ICommonParameterProvider requestParams) {
        Key key = new Key(method, path);
        if (this.javaScriptHandlers.containsKey(key)) {
            Callable handler = this.javaScriptHandlers.get(key);
            Context cx = globalScope.getContextFactory().enterContext();
            try {
                IGlobalScope scope = globalScope.getInstance();
                ResponseWrapper r = new ResponseWrapper((HttpServletResponse)pathParams.getParameter("httpresponse"));
                Scriptable thiz = cx.getWrapFactory().wrapAsJavaObject(cx, (Scriptable)scope, (Object)r, null);
                Scriptable pParams = cx.getWrapFactory().wrapAsJavaObject(cx, (Scriptable)scope, (Object)pathParams, null);
                Scriptable rParams = cx.getWrapFactory().wrapAsJavaObject(cx, (Scriptable)scope, (Object)requestParams, null);
                Object[] params = new Object[]{out, pParams, rParams};
                handler.call(cx, (Scriptable)scope, thiz, params).toString().getBytes(CharsetHelper.getEncoding());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                Context.exit();
            }
        } else if (this.javaHandlers.containsKey(key)) {
            RequestHandler handler = this.javaHandlers.get(key);
            handler.call(out, pathParams, requestParams);
        }
    }

    public void registerHandler(RestRequestHandler.HttpMethod method, String path, Callable handler) {
        this.javaScriptHandlers.put(new Key(method, path), handler);
    }

    public void registerHandler(RestRequestHandler.HttpMethod method, String path, RequestHandler handler) {
        this.javaHandlers.put(new Key(method, path), handler);
    }

    @Override
    public String getResponseMimeType() {
        return "text/html";
    }

    static {
        logger = LogFactory.getLog(Router.class);
    }

    class Key {
        private String path;
        private RestRequestHandler.HttpMethod method;

        public Key(RestRequestHandler.HttpMethod method, String path) {
            this.method = method;
            this.path = path;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.method == null ? other.method != null : !this.method.equals((Object)other.method)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.method != null ? this.method.hashCode() : 0);
            hash = 83 * hash + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }
    }
}

