/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.messaging;

import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.persistence.Persistable;

public class PluginEvent
implements Persistable {
    private long timeStamp;
    private String eventType;
    private String plugin;
    private String name;
    private String key;

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public PluginEvent(JSONObject json) throws JSONException {
        this.fromJSON(json);
    }

    public PluginEvent(String plugin, String eventType, String name) throws JSONException {
        this.timeStamp = System.currentTimeMillis();
        this.plugin = plugin;
        this.eventType = eventType;
        this.name = name;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("eventType", (Object)this.getEventType());
        obj.put("plugin", (Object)this.getPlugin());
        obj.put("name", (Object)this.getName());
        obj.put("timestamp", this.getTimeStamp());
        return obj;
    }

    public String toString() {
        try {
            return this.toJSON().toString(2);
        }
        catch (JSONException e) {
            return "bad json: " + e.getMessage();
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void fromJSON(JSONObject json) throws JSONException {
        this.setTimeStamp(json.getLong("timestamp"));
        this.setPlugin(json.getString("plugin"));
        this.setName(json.getString("name"));
        this.setEventType(json.getString("eventType"));
        try {
            this.setKey(json.getString("key"));
        }
        catch (JSONException jse) {
            this.setKey(null);
        }
    }

    public static class Fields {
        public static final String TIMESTAMP = "timestamp";
        public static final String EVENT_TYPE = "eventType";
        public static final String PLUGIN = "plugin";
        public static final String NAME = "name";
        public static final String KEY = "key";
    }
}

