/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.hadoopbackport.TotalOrderPartitioner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class HFileOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, KeyValue> {
    static Log LOG = LogFactory.getLog(HFileOutputFormat.class);

    public RecordWriter<ImmutableBytesWritable, KeyValue> getRecordWriter(final TaskAttemptContext context) throws IOException, InterruptedException {
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        final Path outputdir = new FileOutputCommitter(outputPath, context).getWorkPath();
        Configuration conf = context.getConfiguration();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x10000000L);
        final int blocksize = conf.getInt("hbase.mapreduce.hfileoutputformat.blocksize", 65536);
        final String compression = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        return new RecordWriter<ImmutableBytesWritable, KeyValue>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes(System.currentTimeMillis());

            public void write(ImmutableBytesWritable row, KeyValue kv) throws IOException {
                long length = kv.getLength();
                byte[] family = kv.getFamily();
                WriterLength wl = this.writers.get(family);
                if (wl == null || length + wl.written >= maxsize && Bytes.compareTo(this.previousRow, 0, this.previousRow.length, kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) != 0) {
                    Path basedir = new Path(outputdir, Bytes.toString(family));
                    if (wl == null) {
                        wl = new WriterLength();
                        this.writers.put(family, wl);
                        if (this.writers.size() > 1) {
                            throw new IOException("One family only");
                        }
                        if (!fs.exists(basedir)) {
                            fs.mkdirs(basedir);
                        }
                    }
                    wl.writer = this.getNewWriter(wl.writer, basedir);
                    LOG.info((Object)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                    wl.written = 0L;
                }
                kv.updateLatestStamp(this.now);
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = kv.getRow();
            }

            private HFile.Writer getNewWriter(HFile.Writer writer, Path familydir) throws IOException {
                this.close(writer);
                return new HFile.Writer(fs, StoreFile.getUniqueFile(fs, familydir), blocksize, compression, KeyValue.KEY_COMPARATOR);
            }

            private void close(HFile.Writer w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes(System.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes(context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(true));
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (Map.Entry<byte[], WriterLength> e : this.writers.entrySet()) {
                    this.close(e.getValue().writer);
                }
            }
        };
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(HTable table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!first.equals(HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary(first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);
        try {
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
        finally {
            writer.close();
        }
    }

    public static void configureIncrementalLoad(Job job, HTable table) throws IOException {
        URI cacheUri;
        Configuration conf = job.getConfiguration();
        job.setPartitionerClass(TotalOrderPartitioner.class);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(KeyValueSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else {
            LOG.warn((Object)("Unknown map output value type:" + job.getMapOutputValueClass()));
        }
        LOG.info((Object)("Looking up current regions for table " + table));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat.getRegionStartKeys(table);
        LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions " + "to match current region count"));
        job.setNumReduceTasks(startKeys.size());
        Path partitionsPath = new Path(job.getWorkingDirectory(), "partitions_" + System.currentTimeMillis());
        LOG.info((Object)("Writing partition information to " + partitionsPath));
        FileSystem fs = partitionsPath.getFileSystem(conf);
        HFileOutputFormat.writePartitions(conf, partitionsPath, startKeys);
        partitionsPath.makeQualified(fs);
        try {
            cacheUri = new URI(partitionsPath.toString() + "#" + "_partition.lst");
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        DistributedCache.addCacheFile((URI)cacheUri, (Configuration)conf);
        DistributedCache.createSymlink((Configuration)conf);
        LOG.info((Object)"Incremental table output configured.");
    }

    static class WriterLength {
        long written = 0L;
        HFile.Writer writer = null;

        WriterLength() {
        }
    }
}

