/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadIncrementalHFiles
extends Configured
implements Tool {
    static Log LOG = LogFactory.getLog(LoadIncrementalHFiles.class);
    public static String NAME = "completebulkload";

    public LoadIncrementalHFiles(Configuration conf) {
        super(conf);
    }

    public LoadIncrementalHFiles() {
    }

    private void usage() {
        System.err.println("usage: " + NAME + " /path/to/hfileoutputformat-output " + "tablename");
    }

    private Deque<LoadQueueItem> discoverLoadQueue(Path hfofDir) throws IOException {
        FileSystem fs = hfofDir.getFileSystem(this.getConf());
        if (!fs.exists(hfofDir)) {
            throw new FileNotFoundException("HFileOutputFormat dir " + hfofDir + " not found");
        }
        FileStatus[] familyDirStatuses = fs.listStatus(hfofDir);
        if (familyDirStatuses == null) {
            throw new FileNotFoundException("No families found in " + hfofDir);
        }
        LinkedList<LoadQueueItem> ret = new LinkedList<LoadQueueItem>();
        for (FileStatus stat : familyDirStatuses) {
            Path[] hfiles;
            if (!stat.isDir()) {
                LOG.warn((Object)("Skipping non-directory " + stat.getPath()));
                continue;
            }
            Path familyDir = stat.getPath();
            if (familyDir.getName().startsWith("_")) continue;
            byte[] family = familyDir.getName().getBytes();
            for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])fs.listStatus(familyDir))) {
                if (hfile.getName().startsWith("_")) continue;
                ret.add(new LoadQueueItem(family, hfile));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBulkLoad(Path hfofDir, HTable table) throws TableNotFoundException, IOException {
        HConnection conn = table.getConnection();
        if (!conn.isTableAvailable(table.getTableName())) {
            throw new TableNotFoundException("Table " + Bytes.toStringBinary(table.getTableName()) + "is not currently available.");
        }
        Deque<LoadQueueItem> queue = null;
        try {
            queue = this.discoverLoadQueue(hfofDir);
            while (!queue.isEmpty()) {
                LoadQueueItem item = queue.remove();
                this.tryLoad(item, conn, table.getTableName(), queue);
            }
        }
        catch (Throwable throwable) {
            if (queue != null && !queue.isEmpty()) {
                StringBuilder err = new StringBuilder();
                err.append("-------------------------------------------------\n");
                err.append("Bulk load aborted with some files not yet loaded:\n");
                err.append("-------------------------------------------------\n");
                for (LoadQueueItem q : queue) {
                    err.append("  ").append(q.hfilePath).append('\n');
                }
                LOG.error((Object)err);
            }
            throw throwable;
        }
        if (queue != null && !queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (LoadQueueItem q : queue) {
                err.append("  ").append(q.hfilePath).append('\n');
            }
            LOG.error((Object)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLoad(final LoadQueueItem item, HConnection conn, byte[] table, final Deque<LoadQueueItem> queue) throws IOException {
        byte[] last;
        byte[] first;
        final Path hfilePath = item.hfilePath;
        FileSystem fs = hfilePath.getFileSystem(this.getConf());
        HFile.Reader hfr = new HFile.Reader(fs, hfilePath, null, false);
        try {
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        finally {
            hfr.close();
        }
        LOG.info((Object)("Trying to load hfile=" + hfilePath + " first=" + Bytes.toStringBinary(first) + " last=" + Bytes.toStringBinary(last)));
        if (first == null || last == null) {
            assert (first == null && last == null);
            LOG.info((Object)("hfile " + hfilePath + " has no entries, skipping"));
            return;
        }
        final Path tmpDir = new Path(item.hfilePath.getParent(), "_tmp");
        conn.getRegionServerWithRetries(new ServerCallable<Void>(conn, table, first){

            @Override
            public Void call() throws Exception {
                LOG.debug((Object)("Going to connect to server " + this.location + "for row " + Bytes.toStringBinary(this.row)));
                HRegionInfo hri = this.location.getRegionInfo();
                if (!hri.containsRange(first, last)) {
                    LOG.info((Object)("HFile at " + hfilePath + " no longer fits inside a single " + "region. Splitting..."));
                    HColumnDescriptor familyDesc = hri.getTableDesc().getFamily(item.family);
                    Path botOut = new Path(tmpDir, hri.getEncodedName() + ".bottom");
                    Path topOut = new Path(tmpDir, hri.getEncodedName() + ".top");
                    LoadIncrementalHFiles.splitStoreFile(LoadIncrementalHFiles.this.getConf(), hfilePath, familyDesc, hri.getEndKey(), botOut, topOut);
                    queue.addFirst(new LoadQueueItem(item.family, botOut));
                    queue.addFirst(new LoadQueueItem(item.family, topOut));
                    LOG.info((Object)("Successfully split into new HFiles " + botOut + " and " + topOut));
                    return null;
                }
                byte[] regionName = this.location.getRegionInfo().getRegionName();
                this.server.bulkLoadHFile(hfilePath.toString(), regionName, item.family);
                return null;
            }
        });
    }

    static void splitStoreFile(Configuration conf, Path inFile, HColumnDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = new Reference(splitKey, Reference.Range.top);
        Reference bottomReference = new Reference(splitKey, Reference.Range.bottom);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, HColumnDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        HalfStoreFileReader halfReader = null;
        StoreFile.Writer halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, null, reference);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompression();
            StoreFile.BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            halfWriter = new StoreFile.Writer(fs, outFile, blocksize, compression, conf, KeyValue.COMPARATOR, bloomFilterType, 0);
            HFileScanner scanner = halfReader.getScanner(false, false);
            scanner.seekTo();
            do {
                KeyValue kv = scanner.getKeyValue();
                halfWriter.append(kv);
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfWriter != null) {
                halfWriter.close();
            }
            if (halfReader != null) {
                halfReader.close();
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        return !HFile.isReservedFileInfoKey(key);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.usage();
            return -1;
        }
        Path hfofDir = new Path(args[0]);
        HTable table = new HTable(this.getConf(), args[1]);
        this.doBulkLoad(hfofDir, table);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new LoadIncrementalHFiles(HBaseConfiguration.create()), (String[])args);
    }

    private static class LoadQueueItem {
        final byte[] family;
        final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }
    }
}

