/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.metrics.MetricsString;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsDynamicMBeanBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class MetricsMBeanBase
extends MetricsDynamicMBeanBase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.metrics");
    protected final MetricsRegistry registry;
    protected final String description;
    protected int registryLength;
    protected Map<String, MetricsBase> extendedAttributes = new HashMap<String, MetricsBase>();
    protected MBeanInfo extendedInfo;

    protected MetricsMBeanBase(MetricsRegistry mr, String description) {
        super(MetricsMBeanBase.copyMinusHBaseMetrics(mr), description);
        this.registry = mr;
        this.description = description;
        this.init();
    }

    private static MetricsRegistry copyMinusHBaseMetrics(MetricsRegistry mr) {
        MetricsRegistry copy = new MetricsRegistry();
        for (MetricsBase metric : mr.getMetricsList()) {
            if (metric instanceof MetricsRate || metric instanceof MetricsString) continue;
            copy.add(metric.getName(), metric);
        }
        return copy;
    }

    protected void init() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        MBeanInfo parentInfo = super.getMBeanInfo();
        ArrayList<String> parentAttributes = new ArrayList<String>();
        for (MBeanAttributeInfo attr : parentInfo.getAttributes()) {
            attributes.add(attr);
            parentAttributes.add(attr.getName());
        }
        this.registryLength = this.registry.getMetricsList().size();
        for (MetricsBase metric : this.registry.getMetricsList()) {
            if (metric.getName() == null || parentAttributes.contains(metric.getName())) continue;
            if (metric instanceof MetricsRate) {
                attributes.add(new MBeanAttributeInfo(metric.getName(), "java.lang.Float", metric.getDescription(), true, false, false));
                this.extendedAttributes.put(metric.getName(), metric);
                continue;
            }
            if (!(metric instanceof MetricsString)) continue;
            attributes.add(new MBeanAttributeInfo(metric.getName(), "java.lang.String", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metric.getName(), metric);
            LOG.info((Object)("MetricsString added: " + metric.getName()));
        }
        LOG.info((Object)"new MBeanInfo");
        this.extendedInfo = new MBeanInfo(((Object)((Object)this)).getClass().getName(), this.description, attributes.toArray(new MBeanAttributeInfo[0]), parentInfo.getConstructors(), parentInfo.getOperations(), parentInfo.getNotifications());
    }

    private void checkAndUpdateAttributes() {
        if (this.registryLength != this.registry.getMetricsList().size()) {
            this.init();
        }
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name is NULL");
        }
        try {
            return super.getAttribute(name);
        }
        catch (AttributeNotFoundException ex) {
            this.checkAndUpdateAttributes();
            MetricsBase metric = this.extendedAttributes.get(name);
            if (metric != null) {
                if (metric instanceof MetricsRate) {
                    return Float.valueOf(((MetricsRate)metric).getPreviousIntervalValue());
                }
                if (metric instanceof MetricsString) {
                    return ((MetricsString)metric).getValue();
                }
                LOG.warn((Object)String.format("unknown metrics type %s for attribute %s", metric.getClass().getName(), name));
            }
            throw new AttributeNotFoundException();
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.extendedInfo;
    }
}

