/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanWildcardColumnTracker
implements ColumnTracker {
    private static final Log LOG = LogFactory.getLog(ScanWildcardColumnTracker.class);
    private byte[] columnBuffer = null;
    private int columnOffset = 0;
    private int columnLength = 0;
    private int currentCount = 0;
    private int maxVersions;
    private long latestTSOfCurrentColumn;

    public ScanWildcardColumnTracker(int maxVersion) {
        this.maxVersions = maxVersion;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length, long timestamp) {
        if (this.columnBuffer == null) {
            this.columnBuffer = bytes;
            this.columnOffset = offset;
            this.columnLength = length;
            this.currentCount = 0;
            if (++this.currentCount > this.maxVersions) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            this.setTS(timestamp);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        int cmp = Bytes.compareTo(bytes, offset, length, this.columnBuffer, this.columnOffset, this.columnLength);
        if (cmp == 0) {
            if (this.sameAsPreviousTS(timestamp)) {
                return ScanQueryMatcher.MatchCode.SKIP;
            }
            if (++this.currentCount > this.maxVersions) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            this.setTS(timestamp);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        this.resetTS();
        if (cmp > 0) {
            this.columnBuffer = bytes;
            this.columnOffset = offset;
            this.columnLength = length;
            this.currentCount = 0;
            if (++this.currentCount > this.maxVersions) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            this.setTS(timestamp);
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        LOG.error((Object)("ScanWildcardColumnTracker.checkColumn ran into a column actually smaller than the previous column: " + Bytes.toStringBinary(bytes, offset, length)));
        this.columnBuffer = bytes;
        this.columnOffset = offset;
        this.columnLength = length;
        this.currentCount = 0;
        if (++this.currentCount > this.maxVersions) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        this.setTS(timestamp);
        return ScanQueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("ScanWildcardColumnTracker.update should never be called!");
    }

    @Override
    public void reset() {
        this.columnBuffer = null;
        this.resetTS();
    }

    private void resetTS() {
        this.latestTSOfCurrentColumn = Long.MAX_VALUE;
    }

    private void setTS(long timestamp) {
        this.latestTSOfCurrentColumn = timestamp;
    }

    private boolean sameAsPreviousTS(long timestamp) {
        return timestamp == this.latestTSOfCurrentColumn;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public boolean done() {
        return false;
    }
}

