/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class User {
    private static boolean IS_SECURE_HADOOP = true;
    private static Log LOG;
    protected UserGroupInformation ugi;

    public String getName() {
        return this.ugi.getUserName();
    }

    public abstract String getShortName();

    public abstract <T> T runAs(PrivilegedAction<T> var1);

    public abstract <T> T runAs(PrivilegedExceptionAction<T> var1) throws IOException, InterruptedException;

    public String toString() {
        return this.ugi.toString();
    }

    public static User getCurrent() throws IOException {
        if (IS_SECURE_HADOOP) {
            return new SecureHadoopUser();
        }
        return new HadoopUser();
    }

    public static User createUserForTesting(Configuration conf, String name, String[] groups) {
        if (IS_SECURE_HADOOP) {
            return SecureHadoopUser.createUserForTesting(conf, name, groups);
        }
        return HadoopUser.createUserForTesting(conf, name, groups);
    }

    public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
        if (IS_SECURE_HADOOP) {
            SecureHadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
        } else {
            HadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
        }
    }

    private static Object callStatic(String methodName) throws Exception {
        return User.call(null, methodName, null, null);
    }

    private static Object callStatic(String methodName, Class[] types, Object[] args) throws Exception {
        return User.call(null, methodName, types, args);
    }

    private static Object call(UserGroupInformation instance, String methodName, Class[] types, Object[] args) throws Exception {
        return User.call(UserGroupInformation.class, instance, methodName, types, args);
    }

    private static <T> Object call(Class<T> clazz, T instance, String methodName, Class[] types, Object[] args) throws Exception {
        try {
            Method m = clazz.getMethod(methodName, types);
            return m.invoke(instance, args);
        }
        catch (IllegalArgumentException arge) {
            LOG.fatal((Object)("Constructed invalid call. class=" + clazz.getName() + " method=" + methodName + " types=" + User.stringify(types)), (Throwable)arge);
            throw arge;
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Can't find method " + methodName + " in " + clazz.getName() + "!", nsme);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() != null) {
                if (ite.getTargetException() instanceof Exception) {
                    throw (Exception)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof Error) {
                    throw (Error)ite.getTargetException();
                }
            }
            throw new UndeclaredThrowableException(ite, "Unknown exception invoking " + clazz.getName() + "." + methodName + "()");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Denied access calling " + clazz.getName() + "." + methodName + "()", iae);
        }
        catch (SecurityException se) {
            LOG.fatal((Object)("SecurityException calling method. class=" + clazz.getName() + " method=" + methodName + " types=" + User.stringify(types)), (Throwable)se);
            throw se;
        }
    }

    private static String stringify(Class[] classes) {
        StringBuilder buf = new StringBuilder();
        if (classes != null) {
            for (Class c : classes) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(c.getName());
            }
        } else {
            buf.append("NULL");
        }
        return buf.toString();
    }

    static {
        try {
            UserGroupInformation.class.getMethod("isSecurityEnabled", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            IS_SECURE_HADOOP = false;
        }
        LOG = LogFactory.getLog(User.class);
    }

    private static class SecureHadoopUser
    extends User {
        private SecureHadoopUser() throws IOException {
            try {
                this.ugi = (UserGroupInformation)User.callStatic("getCurrentUser");
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception getting current secure user");
            }
        }

        private SecureHadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            try {
                return (String)User.call(this.ugi, "getShortUserName", null, null);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error getting user short name");
            }
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedAction.class}, new Object[]{action});
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs()");
            }
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedExceptionAction.class}, new Object[]{action});
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs(PrivilegedExceptionAction)");
            }
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            try {
                return new SecureHadoopUser((UserGroupInformation)User.callStatic("createUserForTesting", new Class[]{String.class, String[].class}, new Object[]{name, groups}));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Error creating secure test user");
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.security.SecurityUtil");
                Class[] types = new Class[]{Configuration.class, String.class, String.class, String.class};
                Object[] args = new Object[]{conf, fileConfKey, principalConfKey, localhost};
                User.call(c, null, "login", types, args);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to login using org.apache.hadoop.security.Security.login(). SecurityUtil class was not found!  Is this a version of secure Hadoop?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unhandled exception in User.login()");
            }
        }
    }

    private static class HadoopUser
    extends User {
        private HadoopUser() {
            try {
                this.ugi = (UserGroupInformation)User.callStatic("getCurrentUGI");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception HadoopUser<init>");
            }
        }

        private HadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            return this.ugi.getUserName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            T result = null;
            UserGroupInformation previous = null;
            try {
                previous = (UserGroupInformation)User.callStatic("getCurrentUGI");
                try {
                    if (this.ugi != null) {
                        User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{this.ugi});
                    }
                    result = action.run();
                }
                catch (Throwable throwable) {
                    User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{previous});
                    throw throwable;
                }
                User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{previous});
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs()");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            T result = null;
            try {
                UserGroupInformation previous = (UserGroupInformation)User.callStatic("getCurrentUGI");
                try {
                    if (this.ugi != null) {
                        User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{this.ugi});
                    }
                    result = action.run();
                }
                catch (Throwable throwable) {
                    User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{previous});
                    throw throwable;
                }
                User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{previous});
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new UndeclaredThrowableException(e, "Unknown exception in runAs()");
            }
            return result;
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.security.UnixUserGroupInformation");
                Constructor<?> constructor = c.getConstructor(String.class, String[].class);
                if (constructor == null) {
                    throw new NullPointerException();
                }
                UserGroupInformation newUser = (UserGroupInformation)constructor.newInstance(name, groups);
                conf.set("hadoop.job.ugi", newUser.toString());
                return new HadoopUser(newUser);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("UnixUserGroupInformation not found, is this secure Hadoop?", cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("No valid constructor found for UnixUserGroupInformation!", nsme);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception instantiating new UnixUserGroupInformation");
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            LOG.info((Object)"Skipping login, not running on secure Hadoop");
        }
    }
}

