/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcSet;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcStorage;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;

abstract class JdbcIndex
implements Index {
    protected JdbcStorage storage;
    protected String tableName;
    protected String name;
    protected String keyColName;
    protected String valColName;
    protected Storage.EntryType keyType;
    protected Storage.EntryType valueType;
    protected boolean needSurrogate;
    protected LazyPreparedStatement sqlKeySetIterator;
    protected LazyPreparedStatement sqlKeySetSize;
    protected LazyPreparedStatement sqlKeySetContains;
    protected LazyPreparedStatement sqlInsert;
    protected LazyPreparedStatement sqlDelete;
    protected LazyPreparedStatement sqlFind;

    JdbcIndex() {
    }

    void init(JdbcStorage storage, String tableName, String name, String keyColName, String valColName, Storage.EntryType keyType, Storage.EntryType valueType, boolean needSurrogate) {
        this.storage = storage;
        this.tableName = tableName;
        this.name = name;
        this.keyColName = keyColName;
        this.valColName = valColName;
        this.keyType = keyType;
        this.valueType = valueType;
        this.needSurrogate = needSurrogate;
        this.defineSql();
    }

    protected void defineSql() {
        if (this.isKeyUnique()) {
            this.sqlKeySetIterator = new LazyPreparedStatement("select " + this.keyColName + " from " + this.tableName);
            this.sqlKeySetSize = new LazyPreparedStatement("select count(*) from " + this.tableName);
        } else {
            this.sqlKeySetIterator = new LazyPreparedStatement("select distinct " + this.keyColName + " from " + this.tableName);
            this.sqlKeySetSize = new LazyPreparedStatement("select count(distinct " + this.keyColName + ") from " + this.tableName);
        }
        this.sqlKeySetContains = new LazyPreparedStatement("select count(*) from " + this.tableName + " where " + this.keyColName + " = ?");
        this.sqlInsert = new LazyPreparedStatement("insert into " + this.tableName + " values(?,?" + (this.needSurrogate ? ",?" : "") + ")");
        this.sqlDelete = new LazyPreparedStatement("delete from " + this.tableName + " where " + this.keyColName + " = ?");
        this.sqlFind = new LazyPreparedStatement("select " + this.valColName + " from " + this.tableName + " where " + this.keyColName + " = ?");
    }

    protected boolean isKeyUnique() {
        return false;
    }

    public String getName() throws StorageException {
        return this.name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public Set keySet() throws StorageException {
        return new JdbcSet(this.storage, this.getKeyType(), this.sqlKeySetIterator, this.sqlKeySetSize, this.sqlKeySetContains);
    }

    public void add(Object key, Object value) throws StorageException {
        this.addImpl(key, value);
    }

    protected void addImpl(Object key, Object value) throws StorageException {
        Object[] args = this.needSurrogate ? new Object[]{key, value, new Long(this.storage.getSerialNumber())} : new Object[]{key, value};
        this.storage.executeUpdate(this.sqlInsert, args);
    }

    public boolean remove(Object key) throws StorageException {
        return this.removeImpl(key);
    }

    protected boolean removeImpl(Object key) throws StorageException {
        return this.storage.executeUpdate(this.sqlDelete, new Object[]{key}) > 0;
    }
}

