/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MDRCache;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcSinglevaluedIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcStorage;
import org.netbeans.mdr.util.DebugException;

class JdbcPrimaryIndex
extends JdbcSinglevaluedIndex
implements MDRCache.OverflowHandler {
    private final MDRCache cache = new MDRCache(1024, (MDRCache.OverflowHandler)this, 1000, null);
    static final int MDR_CACHE_SIZE = 1024;
    static final int MDR_CACHE_THRESHHOLD = 1000;

    JdbcPrimaryIndex() {
    }

    public void cacheThreshholdReached(MDRCache cache, int size) throws StorageException {
        this.flushChanges();
    }

    void shutDown() {
        this.cache.shutDown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void flushChanges() throws StorageException {
        try {
            int modStatus = this.cache.getModStatus();
            while (modStatus != 0) {
                Object value;
                Map.Entry entry;
                MOFID id;
                if ((modStatus & 1) != 0) {
                    Iterator delIter = this.cache.getDeleted().iterator();
                    while (delIter.hasNext()) {
                        id = (MOFID)delIter.next();
                        super.removeImpl(id);
                    }
                }
                if ((modStatus & 2) != 0) {
                    Iterator dirtyIter = this.cache.getDirty().iterator();
                    while (dirtyIter.hasNext()) {
                        entry = (Map.Entry)dirtyIter.next();
                        id = (MOFID)entry.getKey();
                        value = entry.getValue();
                        super.replaceImpl(id, value);
                    }
                }
                if ((modStatus & 4) != 0) {
                    Iterator newIter = this.cache.getNew().iterator();
                    while (newIter.hasNext()) {
                        entry = (Map.Entry)newIter.next();
                        id = (MOFID)entry.getKey();
                        value = entry.getValue();
                        super.addImpl(id, value);
                    }
                }
                modStatus = this.cache.getModStatus();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.cache.updateSize();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.cache.updateSize();
    }

    private MOFID makeMOFID(Object key) throws StorageException {
        if (key instanceof MOFID) {
            return (MOFID)key;
        }
        throw new IllegalArgumentException("Argument must be of org.netbeans.mdr.persistence.MOFID type");
    }

    void objectStateChanged(Object key) throws StorageException {
        this.cache.setDirty((Object)this.makeMOFID(key));
    }

    private boolean exists(MOFID key) throws StorageException {
        if (this.cache.get((Object)key) != null) {
            return true;
        }
        if (this.cache.isDeleted((Object)key)) {
            return false;
        }
        return super.getIfExists(key) != null;
    }

    private void noSuchRecord(Object key) throws StorageException {
        throw new StorageBadRequestException(MessageFormat.format("No record exists with key {0}", key));
    }

    private void addToCache(MOFID key, Object value) throws StorageException {
        this.cache.put((Object)key, value);
        this.cache.setNew((Object)key);
    }

    private void replaceInCache(MOFID key, Object value) throws StorageException {
        boolean isNew = this.cache.isNew((Object)key);
        this.cache.replace((Object)key, value);
        if (isNew) {
            this.cache.setNew((Object)key);
        } else {
            this.cache.setDirty((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Object key, Object value) throws StorageException {
        JdbcStorage jdbcStorage = this.storage;
        synchronized (jdbcStorage) {
            MOFID mKey;
            block4: {
                mKey = this.makeMOFID(key);
                if (this.exists(mKey)) break block4;
                this.addToCache(mKey, value);
                return false;
            }
            this.replaceInCache(mKey, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        JdbcStorage jdbcStorage = this.storage;
        synchronized (jdbcStorage) {
            MOFID mKey = this.makeMOFID(key);
            if (!this.exists(mKey)) {
                this.noSuchRecord(mKey);
            }
            this.replaceInCache(mKey, value);
        }
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        Object retval = this.getIfExists(key);
        if (retval == null) {
            this.noSuchRecord(key);
        }
        return retval;
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getIfExists(Object key) throws StorageException {
        JdbcStorage jdbcStorage = this.storage;
        synchronized (jdbcStorage) {
            MOFID mKey = this.makeMOFID(key);
            Object retval = this.cache.get((Object)mKey);
            if (retval == null) {
                if (this.cache.isDeleted((Object)mKey)) {
                    return null;
                }
                retval = super.getIfExists(mKey);
                if (retval != null) {
                    this.cache.put((Object)mKey, retval);
                }
            }
            return retval;
        }
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        return this.getIfExists(key);
    }

    public Collection values() throws StorageException {
        throw new RuntimeException("oops, not yet implemented");
    }

    public Set keySet() throws StorageException {
        throw new RuntimeException("oops, not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object key, Object value) throws StorageException {
        JdbcStorage jdbcStorage = this.storage;
        synchronized (jdbcStorage) {
            MOFID mKey = this.makeMOFID(key);
            if (this.exists(mKey)) {
                throw new StorageBadRequestException(MessageFormat.format("Record with key {0} already exists", mKey));
            }
            this.addToCache(mKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key) throws StorageException {
        JdbcStorage jdbcStorage = this.storage;
        synchronized (jdbcStorage) {
            MOFID mKey;
            block6: {
                mKey = this.makeMOFID(key);
                boolean exists = this.exists(mKey);
                if (exists) break block6;
                return false;
            }
            try {
                this.cache.remove((Object)mKey);
                return true;
            }
            catch (DebugException e) {
                return false;
            }
        }
    }
}

