/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.pig;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;
import org.w3c.dom.Node;

@JobEntry(id="HadoopPigScriptExecutorPlugin", image="HDE.png", name="HadoopPigScriptExecutorPlugin.Name", description="HadoopPigScriptExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.pig")
public class JobEntryPigScriptExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryPigScriptExecutor.class;
    protected String m_jobTrackerHostname = "";
    protected String m_jobTrackerPort = "";
    protected String m_hdfsHostname = "";
    protected String m_hdfsPort = "";
    protected String m_scriptFile = "";
    protected boolean m_enableBlocking;
    protected boolean m_localExecution;
    protected HashMap<String, String> m_params = new HashMap();

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"hdfs_hostname", (String)this.m_hdfsHostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hdfs_port", (String)this.m_hdfsPort));
        retval.append("    ").append(XMLHandler.addTagValue((String)"jobtracker_hostname", (String)this.m_jobTrackerHostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"jobtracker_port", (String)this.m_jobTrackerPort));
        retval.append("    ").append(XMLHandler.addTagValue((String)"script_file", (String)this.m_scriptFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enable_blocking", (boolean)this.m_enableBlocking));
        retval.append("    ").append(XMLHandler.addTagValue((String)"local_execution", (boolean)this.m_localExecution));
        retval.append("    <script_parameters>").append(Const.CR);
        if (this.m_params != null) {
            for (String name : this.m_params.keySet()) {
                String value = this.m_params.get(name);
                if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
                retval.append("      <parameter>").append(Const.CR);
                retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)name));
                retval.append("        ").append(XMLHandler.addTagValue((String)"value", (String)value));
                retval.append("      </parameter>").append(Const.CR);
            }
        }
        retval.append("    </script_parameters>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository repository) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.m_hdfsHostname = XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_hostname");
        this.m_hdfsPort = XMLHandler.getTagValue((Node)entrynode, (String)"hdfs_port");
        this.m_jobTrackerHostname = XMLHandler.getTagValue((Node)entrynode, (String)"jobtracker_hostname");
        this.m_jobTrackerPort = XMLHandler.getTagValue((Node)entrynode, (String)"jobtracker_port");
        this.m_scriptFile = XMLHandler.getTagValue((Node)entrynode, (String)"script_file");
        this.m_enableBlocking = XMLHandler.getTagValue((Node)entrynode, (String)"enable_blocking").equalsIgnoreCase("Y");
        this.m_localExecution = XMLHandler.getTagValue((Node)entrynode, (String)"local_execution").equalsIgnoreCase("Y");
        this.m_params = new HashMap();
        Node paramList = XMLHandler.getSubNode((Node)entrynode, (String)"script_parameters");
        if (paramList != null) {
            int numParams = XMLHandler.countNodes((Node)paramList, (String)"parameter");
            for (int i = 0; i < numParams; ++i) {
                Node paramNode = XMLHandler.getSubNodeByNr((Node)paramList, (String)"parameter", (int)i);
                String name = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                String value = XMLHandler.getTagValue((Node)paramNode, (String)"value");
                this.m_params.put(name, value);
            }
        }
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.setHDFSHostname(rep.getJobEntryAttributeString(id_jobentry, "hdfs_hostname"));
            this.setHDFSPort(rep.getJobEntryAttributeString(id_jobentry, "hdfs_port"));
            this.setJobTrackerHostname(rep.getJobEntryAttributeString(id_jobentry, "jobtracker_hostname"));
            this.setJobTrackerPort(rep.getJobEntryAttributeString(id_jobentry, "jobtracker_port"));
            this.setScriptFilename(rep.getJobEntryAttributeString(id_jobentry, "script_file"));
            this.setEnableBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "enable_blocking"));
            this.setLocalExecution(rep.getJobEntryAttributeBoolean(id_jobentry, "local_execution"));
            this.m_params = new HashMap();
            int numParams = rep.countNrJobEntryAttributes(id_jobentry, "param_name");
            if (numParams > 0) {
                for (int i = 0; i < numParams; ++i) {
                    String name = rep.getJobEntryAttributeString(id_jobentry, i, "param_name");
                    String value = rep.getJobEntryAttributeString(id_jobentry, i, "param_value");
                    this.m_params.put(name, value);
                }
            }
        } else {
            throw new KettleException("Unable to load from a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        if (rep != null) {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_hostname", this.m_hdfsHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hdfs_port", this.m_hdfsPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jobtracker_hostname", this.m_jobTrackerHostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jobtracker_port", this.m_jobTrackerPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "script_file", this.m_scriptFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "enable_blocking", this.m_enableBlocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "local_execution", this.m_localExecution);
            if (this.m_params != null) {
                int i = 0;
                for (String name : this.m_params.keySet()) {
                    String value = this.m_params.get(name);
                    if (Const.isEmpty((String)name) || Const.isEmpty((String)value)) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_name", name);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "param_value", value);
                    ++i;
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public String getJobTrackerHostname() {
        return this.m_jobTrackerHostname;
    }

    public void setJobTrackerHostname(String jt) {
        this.m_jobTrackerHostname = jt;
    }

    public String getJobTrackerPort() {
        return this.m_jobTrackerPort;
    }

    public void setJobTrackerPort(String jp) {
        this.m_jobTrackerPort = jp;
    }

    public String getHDFSHostname() {
        return this.m_hdfsHostname;
    }

    public void setHDFSHostname(String nameN) {
        this.m_hdfsHostname = nameN;
    }

    public String getHDFSPort() {
        return this.m_hdfsPort;
    }

    public void setHDFSPort(String p) {
        this.m_hdfsPort = p;
    }

    public boolean getEnableBlocking() {
        return this.m_enableBlocking;
    }

    public void setEnableBlocking(boolean block) {
        this.m_enableBlocking = block;
    }

    public void setLocalExecution(boolean l) {
        this.m_localExecution = l;
    }

    public boolean getLocalExecution() {
        return this.m_localExecution;
    }

    public void setScriptFilename(String filename) {
        this.m_scriptFile = filename;
    }

    public String getScriptFilename() {
        return this.m_scriptFile;
    }

    public void setScriptParameters(HashMap<String, String> params) {
        this.m_params = params;
    }

    public HashMap<String, String> getScriptParameters() {
        return this.m_params;
    }

    public Result execute(final Result result, int arg1) throws KettleException {
        result.setNrErrors(0L);
        KettleLoggingPrintWriter klps = new KettleLoggingPrintWriter();
        WriterAppender pigToKettleAppender = new WriterAppender((Layout)new Log4jKettleLayout(true), (Writer)klps);
        Logger pigLogger = Logger.getLogger((String)"org.apache.pig");
        Level log4jLevel = this.getLog4jLevel(this.parentJob.getLogLevel());
        pigLogger.setLevel(log4jLevel);
        Log4jFileAppender appender = null;
        String logFileName = "pdi-" + this.getName();
        LogWriter logWriter = LogWriter.getInstance();
        try {
            appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
            logWriter.addAppender((Appender)appender);
            this.log.setLogLevel(this.parentJob.getLogLevel());
            if (pigLogger != null) {
                pigLogger.addAppender((Appender)pigToKettleAppender);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
            this.logError(Const.getStackTracker((Throwable)e));
        }
        if (Const.isEmpty((String)this.m_scriptFile)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.Error.NoPigScriptSpecified", (String[])new String[0]));
        }
        try {
            PigShim.ExecutionMode execMode;
            URL scriptU = null;
            String scriptFileS = this.m_scriptFile;
            scriptFileS = this.environmentSubstitute(scriptFileS);
            if (scriptFileS.indexOf("://") == -1) {
                File scriptFile = new File(scriptFileS);
                scriptU = scriptFile.toURI().toURL();
            } else {
                scriptU = new URL(scriptFileS);
            }
            HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
            HadoopShim hadoopShim = active.getHadoopShim();
            final PigShim pigShim = active.getPigShim();
            if (this.m_localExecution && !pigShim.isLocalExecutionSupported()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.Warning.LocalExecution", (String[])new String[0]));
            }
            Configuration conf = hadoopShim.createConfiguration();
            if (!this.m_localExecution) {
                String hdfsHost = this.environmentSubstitute(this.m_hdfsHostname);
                String hdfsP = this.environmentSubstitute(this.m_hdfsPort);
                String jobTrackerHost = this.environmentSubstitute(this.m_jobTrackerHostname);
                String jobTP = this.environmentSubstitute(this.m_jobTrackerPort);
                ArrayList configMessages = new ArrayList();
                hadoopShim.configureConnectionInformation(hdfsHost, hdfsP, jobTrackerHost, jobTP, conf, configMessages);
                for (String m : configMessages) {
                    this.logBasic(m);
                }
            }
            final Properties properties = new Properties();
            pigShim.configure(properties, this.m_localExecution ? null : conf);
            ArrayList<String> paramList = new ArrayList<String>();
            if (this.m_params != null) {
                for (Map.Entry<String, String> entry : this.m_params.entrySet()) {
                    String name = entry.getKey();
                    name = this.environmentSubstitute(name);
                    String value = entry.getValue();
                    value = this.environmentSubstitute(value);
                    paramList.add(name + "=" + value);
                }
            }
            final String pigScript = pigShim.substituteParameters(scriptU, paramList);
            PigShim.ExecutionMode executionMode = execMode = this.m_localExecution ? PigShim.ExecutionMode.LOCAL : PigShim.ExecutionMode.MAPREDUCE;
            if (this.m_enableBlocking) {
                int[] executionStatus = pigShim.executeScript(pigScript, execMode, properties);
                this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryPigScriptExecutor.JobCompletionStatus", (String[])new String[]{"" + executionStatus[0], "" + executionStatus[1]}));
                if (executionStatus[1] > 0) {
                    result.setStopped(true);
                    result.setNrErrors((long)executionStatus[1]);
                    result.setResult(false);
                }
                this.removeAppender(appender, pigToKettleAppender);
                if (appender != null) {
                    ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                }
            } else {
                final Log4jFileAppender fa = appender;
                final WriterAppender ptk = pigToKettleAppender;
                final Thread runThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int[] executionStatus = pigShim.executeScript(pigScript, execMode, properties);
                            JobEntryPigScriptExecutor.this.logBasic(BaseMessages.getString((Class)PKG, (String)"JobEntryPigScriptExecutor.JobCompletionStatus", (String[])new String[]{"" + executionStatus[0], "" + executionStatus[1]}));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            result.setStopped(true);
                            result.setNrErrors(1L);
                            result.setResult(false);
                        }
                        finally {
                            JobEntryPigScriptExecutor.this.removeAppender(fa, ptk);
                            if (fa != null) {
                                ResultFile resultFile = new ResultFile(1, fa.getFile(), JobEntryPigScriptExecutor.this.parentJob.getJobname(), this.getName());
                                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                            }
                        }
                    }
                };
                runThread.start();
                this.parentJob.addJobListener(new JobListener(){

                    public void jobStarted(Job job) throws KettleException {
                    }

                    public void jobFinished(Job job) throws KettleException {
                        if (runThread.isAlive()) {
                            JobEntryPigScriptExecutor.this.logMinimal(BaseMessages.getString((Class)PKG, (String)"JobEntryPigScriptExecutor.Warning.AsynctaskStillRunning", (String[])new String[]{JobEntryPigScriptExecutor.this.getName(), job.getJobname()}));
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result.setStopped(true);
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError(ex.getMessage(), ex);
        }
        return result;
    }

    private Level getLog4jLevel(LogLevel level) {
        Level log4jLevel = (Level)KettleLogChannelAppender.LOG_LEVEL_MAP.get(level);
        return log4jLevel != null ? log4jLevel : Level.INFO;
    }

    protected void removeAppender(Log4jFileAppender appender, WriterAppender pigToKettleAppender) {
        Logger pigLogger;
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
        }
        if ((pigLogger = Logger.getLogger((String)"org.apache.pig")) != null && pigToKettleAppender != null) {
            pigLogger.removeAppender((Appender)pigToKettleAppender);
            pigToKettleAppender.close();
        }
    }

    class KettleLoggingPrintWriter
    extends PrintWriter {
        public KettleLoggingPrintWriter() {
            super(System.out);
        }

        @Override
        public void println(String string) {
            JobEntryPigScriptExecutor.this.logBasic(string);
        }

        @Override
        public void println(Object obj) {
            this.println(obj.toString());
        }

        @Override
        public void write(String string) {
            this.println(string);
        }

        @Override
        public void print(String string) {
            this.println(string);
        }

        @Override
        public void print(Object obj) {
            this.print(obj.toString());
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

