/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInputData;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInputMeta;
import org.pentaho.hbase.HBaseRowToKettleTuple;
import org.pentaho.hbase.mapping.MappingAdmin;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;

public class HBaseInput
extends BaseStep
implements StepInterface {
    protected HBaseInputMeta m_meta;
    protected HBaseInputData m_data;
    protected HBaseConnection m_hbAdmin;
    protected HBaseBytesUtilShim m_bytesUtil;
    protected MappingAdmin m_mappingAdmin;
    protected Mapping m_tableMapping;
    protected Map<String, HBaseValueMeta> m_columnsMappedByAlias;
    protected List<HBaseValueMeta> m_userOutputColumns;
    protected HBaseRowToKettleTuple m_tupleHandler;

    public HBaseInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.m_meta = (HBaseInputMeta)smi;
            this.m_data = (HBaseInputData)sdi;
            try {
                ArrayList<String> connectionMessages = new ArrayList<String>();
                this.m_hbAdmin = HBaseInputData.getHBaseConnection(this.environmentSubstitute(this.m_meta.getZookeeperHosts()), this.environmentSubstitute(this.m_meta.getZookeeperPort()), this.environmentSubstitute(this.m_meta.getCoreConfigURL()), this.environmentSubstitute(this.m_meta.getDefaultConfigURL()), connectionMessages);
                this.m_bytesUtil = this.m_hbAdmin.getBytesUtil();
                if (connectionMessages.size() > 0) {
                    for (String m : connectionMessages) {
                        this.logBasic(m);
                    }
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToObtainConnection", (String[])new String[0]), (Throwable)ex);
            }
            try {
                this.m_mappingAdmin = new MappingAdmin(this.m_hbAdmin);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToCreateAMappingAdminConnection", (String[])new String[0]), (Throwable)ex);
            }
            String sourceName = this.environmentSubstitute(this.m_meta.getSourceTableName());
            if (StringUtil.isEmpty((String)sourceName)) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.TableName.Missing", (String[])new String[0]));
            }
            try {
                if (!this.m_hbAdmin.tableExists(sourceName)) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.SourceTableDoesNotExist", (String[])new String[]{sourceName}));
                }
                if (this.m_hbAdmin.isTableDisabled(sourceName) || !this.m_hbAdmin.isTableAvailable(sourceName)) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.SourceTableIsNotAvailable", (String[])new String[]{sourceName}));
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.AvailabilityReadinessProblem", (String[])new String[]{sourceName}), (Throwable)ex);
            }
            if (this.m_meta.getMapping() != null && Const.isEmpty((String)this.m_meta.getSourceMappingName())) {
                this.m_tableMapping = this.m_meta.getMapping();
            } else {
                if (Const.isEmpty((String)this.m_meta.getSourceMappingName())) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.NoMappingName", (String[])new String[0]));
                }
                try {
                    this.m_tableMapping = this.m_mappingAdmin.getMapping(this.environmentSubstitute(this.m_meta.getSourceTableName()), this.environmentSubstitute(this.m_meta.getSourceMappingName()));
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToRetrieveMapping", (String[])new String[]{this.environmentSubstitute(this.m_meta.getSourceMappingName()), this.environmentSubstitute(this.m_meta.getSourceTableName())}), (Throwable)ex);
                }
            }
            this.m_columnsMappedByAlias = this.m_tableMapping.getMappedColumns();
            if (this.m_tableMapping.isTupleMapping()) {
                this.m_tupleHandler = new HBaseRowToKettleTuple(this.m_bytesUtil);
            }
            String dateOrNumberConversionMaskForKey = null;
            this.m_userOutputColumns = this.m_meta.getOutputFields();
            if (this.m_userOutputColumns != null && this.m_userOutputColumns.size() > 0) {
                for (HBaseValueMeta vm : this.m_userOutputColumns) {
                    if (!vm.isKey()) {
                        if (this.m_columnsMappedByAlias.get(vm.getAlias()) != null) continue;
                        throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToFindUserSelectedColumn", (String[])new String[]{vm.getAlias(), this.m_tableMapping.getTableName() + "," + this.m_tableMapping.getMappingName()}));
                    }
                    dateOrNumberConversionMaskForKey = vm.getConversionMask();
                }
            }
            try {
                this.m_hbAdmin.newSourceTable(sourceName);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToSetSourceTableForScan", (String[])new String[0]), (Throwable)ex);
            }
            HBaseInputData.initializeScan(this.m_hbAdmin, this.m_bytesUtil, this.m_tableMapping, dateOrNumberConversionMaskForKey, this.m_meta.getKeyStartValue(), this.m_meta.getKeyStopValue(), this.m_meta.getScannerCacheSize(), this.log, (VariableSpace)this);
            if (this.m_userOutputColumns != null && this.m_userOutputColumns.size() > 0 && !this.m_tableMapping.isTupleMapping()) {
                HBaseInputData.setScanColumns(this.m_hbAdmin, this.m_userOutputColumns, this.m_tableMapping);
            }
            if (this.m_meta.getColumnFilters() != null && this.m_meta.getColumnFilters().size() > 0) {
                if (this.m_tableMapping.isTupleMapping()) {
                    this.logBasic(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.FiltersNotApplicableWithTupleMapping", (String[])new String[0]));
                } else {
                    HBaseInputData.setScanFilters(this.m_hbAdmin, this.m_meta.getColumnFilters(), this.m_meta.getMatchAnyFilter(), this.m_columnsMappedByAlias, (VariableSpace)this);
                }
            }
            if (!this.isStopped()) {
                try {
                    this.m_hbAdmin.executeSourceTableScan();
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.UnableToExecuteSourceTableScan", (String[])new String[0]), (Throwable)e);
                }
                this.m_data.setOutputRowMeta((RowMetaInterface)new RowMeta());
                this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            }
        }
        boolean hasNext = false;
        if (!this.isStopped()) {
            try {
                hasNext = this.m_hbAdmin.resultSetNextRow();
            }
            catch (Exception e) {
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
        }
        if (!hasNext) {
            try {
                this.m_hbAdmin.closeSourceTable();
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ProblemClosingConnection", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.setOutputDone();
            return false;
        }
        if (this.m_tableMapping.isTupleMapping()) {
            List<Object[]> tupleRows = HBaseInputData.getTupleOutputRows(this.m_hbAdmin, this.m_userOutputColumns, this.m_columnsMappedByAlias, this.m_tableMapping, this.m_tupleHandler, this.m_data.getOutputRowMeta(), this.m_bytesUtil);
            for (Object[] tuple : tupleRows) {
                this.putRow(this.m_data.getOutputRowMeta(), tuple);
            }
            return true;
        }
        Object[] outRowData = HBaseInputData.getOutputRow(this.m_hbAdmin, this.m_userOutputColumns, this.m_columnsMappedByAlias, this.m_tableMapping, this.m_data.getOutputRowMeta(), this.m_bytesUtil);
        this.putRow(this.m_data.getOutputRowMeta(), outRowData);
        return true;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped && this.m_hbAdmin != null) {
            this.logBasic(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.ClosingConnection", (String[])new String[0]));
            try {
                this.m_hbAdmin.closeSourceTable();
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(HBaseInputMeta.PKG, (String)"HBaseInput.Error.ProblemClosingConnection1", (String[])new String[]{ex.getMessage()}));
            }
        }
    }
}

