/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.hadoopjobexecutor;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.entries.hadoopjobexecutor.JarUtility;
import org.pentaho.di.job.entries.hadoopjobexecutor.JobEntryHadoopJobExecutor;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.job.entries.hadoopjobexecutor.UserDefinedItem;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.jface.tags.JfaceCMenuList;
import org.pentaho.ui.xul.util.AbstractModelList;

public class JobEntryHadoopJobExecutorController
extends AbstractXulEventHandler {
    private static final Class<?> PKG = JobEntryHadoopJobExecutor.class;
    public static final String JOB_ENTRY_NAME = "jobEntryName";
    public static final String HADOOP_JOB_NAME = "hadoopJobName";
    public static final String JAR_URL = "jarUrl";
    public static final String DRIVER_CLASS = "driverClass";
    public static final String DRIVER_CLASSES = "driverClasses";
    public static final String IS_SIMPLE = "isSimple";
    public static final String USER_DEFINED = "userDefined";
    private String jobEntryName;
    private String hadoopJobName;
    private String jarUrl = "";
    private String driverClass = "";
    private List<String> driverClasses = new ArrayList<String>();
    private boolean isSimple = true;
    private SimpleConfiguration sConf = new SimpleConfiguration();
    private AdvancedConfiguration aConf = new AdvancedConfiguration();
    private JobEntryHadoopJobExecutor jobEntry;
    private AbstractModelList<UserDefinedItem> userDefined = new AbstractModelList();

    protected VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public void accept() {
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
        this.hadoopJobName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jar-url");
        this.jarUrl = ((Text)tempBox.getTextControl()).getText();
        JfaceCMenuList tempList = (JfaceCMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("driver-class");
        this.driverClass = tempList.getValue();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("command-line-arguments");
        this.sConf.cmdLineArgs = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-key-class");
        this.aConf.outputKeyClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-value-class");
        this.aConf.outputValueClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-mapper-class");
        this.aConf.mapperClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-reducer-class");
        this.aConf.reducerClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
        this.aConf.inputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
        this.aConf.outputPath = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
        this.aConf.inputFormatClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
        this.aConf.outputFormatClass = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hdfs-hostname");
        this.aConf.hdfsHostname = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hdfs-port");
        this.aConf.hdfsPort = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("job-tracker-hostname");
        this.aConf.jobTrackerHostname = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("job-tracker-port");
        this.aConf.jobTrackerPort = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
        this.aConf.numMapTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
        this.aConf.numReduceTasks = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
        this.aConf.loggingInterval = ((Text)tempBox.getTextControl()).getText();
        this.jobEntry.setName(this.jobEntryName);
        this.jobEntry.setHadoopJobName(this.hadoopJobName);
        this.jobEntry.setSimple(this.isSimple);
        this.jobEntry.setJarUrl(this.jarUrl);
        this.jobEntry.setDriverClass(this.driverClass);
        this.jobEntry.setCmdLineArgs(this.sConf.getCommandLineArgs());
        this.jobEntry.setSimpleBlocking(this.sConf.isSimpleBlocking());
        this.jobEntry.setSimpleLoggingInterval(this.sConf.getSimpleLoggingInterval());
        this.jobEntry.setBlocking(this.aConf.isBlocking());
        this.jobEntry.setLoggingInterval(this.aConf.getLoggingInterval());
        this.jobEntry.setMapperClass(this.aConf.getMapperClass());
        this.jobEntry.setCombinerClass(this.aConf.getCombinerClass());
        this.jobEntry.setReducerClass(this.aConf.getReducerClass());
        this.jobEntry.setInputPath(this.aConf.getInputPath());
        this.jobEntry.setInputFormatClass(this.aConf.getInputFormatClass());
        this.jobEntry.setOutputPath(this.aConf.getOutputPath());
        this.jobEntry.setOutputKeyClass(this.aConf.getOutputKeyClass());
        this.jobEntry.setOutputValueClass(this.aConf.getOutputValueClass());
        this.jobEntry.setOutputFormatClass(this.aConf.getOutputFormatClass());
        this.jobEntry.setHdfsHostname(this.aConf.getHdfsHostname());
        this.jobEntry.setHdfsPort(this.aConf.getHdfsPort());
        this.jobEntry.setJobTrackerHostname(this.aConf.getJobTrackerHostname());
        this.jobEntry.setJobTrackerPort(this.aConf.getJobTrackerPort());
        this.jobEntry.setNumMapTasks(this.aConf.getNumMapTasks());
        this.jobEntry.setNumReduceTasks(this.aConf.getNumReduceTasks());
        this.jobEntry.setUserDefined((List<UserDefinedItem>)this.userDefined);
        this.jobEntry.setChanged();
        this.cancel();
    }

    public void init() throws XulDomException {
        if (this.jobEntry != null) {
            this.setName(this.jobEntry.getName());
            this.setJobEntryName(this.jobEntry.getName());
            this.setHadoopJobName(this.jobEntry.getHadoopJobName());
            this.setSimple(this.jobEntry.isSimple());
            this.setJarUrl(this.jobEntry.getJarUrl());
            this.populateDriverMenuList();
            this.setDriverClass(this.jobEntry.getDriverClass());
            this.sConf.setCommandLineArgs(this.jobEntry.getCmdLineArgs());
            this.sConf.setSimpleBlocking(this.jobEntry.isSimpleBlocking());
            this.sConf.setSimpleLoggingInterval(this.jobEntry.getSimpleLoggingInterval());
            this.userDefined.clear();
            if (this.jobEntry.getUserDefined() != null) {
                this.userDefined.addAll(this.jobEntry.getUserDefined());
            }
            VariableSpace varSpace = this.getVariableSpace();
            ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jobentry-hadoopjob-name");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("jar-url");
            tempBox.setVariableSpace(varSpace);
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("command-line-arguments");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-key-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-value-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-mapper-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-combiner-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-reducer-class");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("input-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("output-path");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-input-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("classes-output-format");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hdfs-hostname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("hdfs-port");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("job-tracker-hostname");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("job-tracker-port");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-map-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("num-reduce-tasks");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("logging-interval");
            tempBox.setVariableSpace(varSpace);
            tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById("simple-logging-interval");
            tempBox.setVariableSpace(varSpace);
            this.aConf.setBlocking(this.jobEntry.isBlocking());
            this.aConf.setLoggingInterval(this.jobEntry.getLoggingInterval());
            this.aConf.setMapperClass(this.jobEntry.getMapperClass());
            this.aConf.setCombinerClass(this.jobEntry.getCombinerClass());
            this.aConf.setReducerClass(this.jobEntry.getReducerClass());
            this.aConf.setInputPath(this.jobEntry.getInputPath());
            this.aConf.setInputFormatClass(this.jobEntry.getInputFormatClass());
            this.aConf.setOutputPath(this.jobEntry.getOutputPath());
            this.aConf.setOutputKeyClass(this.jobEntry.getOutputKeyClass());
            this.aConf.setOutputValueClass(this.jobEntry.getOutputValueClass());
            this.aConf.setOutputFormatClass(this.jobEntry.getOutputFormatClass());
            this.aConf.setHdfsHostname(this.jobEntry.getHdfsHostname());
            this.aConf.setHdfsPort(this.jobEntry.getHdfsPort());
            this.aConf.setJobTrackerHostname(this.jobEntry.getJobTrackerHostname());
            this.aConf.setJobTrackerPort(this.jobEntry.getJobTrackerPort());
            this.aConf.setNumMapTasks(this.jobEntry.getNumMapTasks());
            this.aConf.setNumReduceTasks(this.jobEntry.getNumReduceTasks());
        }
    }

    public void cancel() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement();
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public void browseJar() {
        String fname;
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement();
        Shell shell = (Shell)xulDialog.getRootObject();
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterNames(new String[]{"Java Archives (jar)"});
        String prevName = this.jobEntry.environmentSubstitute(this.jarUrl);
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)this.jobEntry.environmentSubstitute(this.jobEntry.getFilename())).getParent());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!Const.isEmpty((String)prevName)) {
            try {
                if (KettleVFS.fileExists((String)prevName)) {
                    dialog.setFilterPath(KettleVFS.getFilename((FileObject)KettleVFS.getFileObject((String)prevName).getParent()));
                } else {
                    if (!prevName.endsWith(".jar") && !prevName.endsWith(".zip")) {
                        prevName = "${Internal.Job.Filename.Directory}/" + Const.trim((String)this.jarUrl) + ".jar";
                    }
                    if (KettleVFS.fileExists((String)prevName)) {
                        this.setJarUrl(prevName);
                        return;
                    }
                }
            }
            catch (Exception e) {
                dialog.setFilterPath(parentFolder);
            }
        } else if (!Const.isEmpty(parentFolder)) {
            dialog.setFilterPath(parentFolder);
        }
        if ((fname = dialog.open()) != null) {
            File file = new File(fname);
            String name = file.getName();
            String parentFolderSelection = file.getParentFile().toString();
            if (!Const.isEmpty((String)parentFolder) && parentFolder.equals(parentFolderSelection)) {
                this.setJarUrl("${Internal.Job.Filename.Directory}/" + name);
            } else {
                this.setJarUrl(fname);
            }
            this.populateDriverMenuList();
        }
    }

    public void newUserDefinedItem() {
        this.userDefined.add((Object)new UserDefinedItem());
    }

    public SimpleConfiguration getSimpleConfiguration() {
        return this.sConf;
    }

    public AdvancedConfiguration getAdvancedConfiguration() {
        return this.aConf;
    }

    public AbstractModelList<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public String getName() {
        return "jobEntryController";
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        String previousVal = this.jobEntryName;
        String newVal = jobEntryName;
        this.jobEntryName = jobEntryName;
        this.firePropertyChange(JOB_ENTRY_NAME, previousVal, newVal);
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        String previousVal = this.hadoopJobName;
        String newVal = hadoopJobName;
        this.hadoopJobName = hadoopJobName;
        this.firePropertyChange(HADOOP_JOB_NAME, previousVal, newVal);
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public List<String> getDriverClasses() {
        return this.driverClasses;
    }

    public void setJarUrl(String jarUrl) {
        String previousVal = this.jarUrl;
        String newVal = jarUrl;
        this.jarUrl = jarUrl;
        this.firePropertyChange(JAR_URL, previousVal, newVal);
    }

    public void setDriverClass(String driverClass) {
        String previousVal = this.driverClass;
        String newVal = driverClass;
        this.driverClass = driverClass;
        this.firePropertyChange(DRIVER_CLASS, previousVal, newVal);
    }

    public void setDriverClasses(List<String> driverClasses) {
        List<String> previousVal = this.driverClasses;
        List<String> newVal = driverClasses;
        this.driverClasses = driverClasses;
        this.firePropertyChange(DRIVER_CLASSES, previousVal, newVal);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        ((XulVbox)this.getXulDomContainer().getDocumentRoot().getElementById("advanced-configuration")).setVisible(!isSimple);
        ((XulVbox)this.getXulDomContainer().getDocumentRoot().getElementById("simple-configuration")).setVisible(isSimple);
        boolean previousVal = this.isSimple;
        boolean newVal = isSimple;
        this.isSimple = isSimple;
        this.firePropertyChange(IS_SIMPLE, previousVal, newVal);
    }

    public void invertSimpleBlocking() {
        this.sConf.setSimpleBlocking(!this.sConf.isSimpleBlocking());
    }

    public void invertBlocking() {
        this.aConf.setBlocking(!this.aConf.isBlocking());
    }

    public JobEntryHadoopJobExecutor getJobEntry() {
        return this.jobEntry;
    }

    public void setJobEntry(JobEntryHadoopJobExecutor jobEntry) {
        this.jobEntry = jobEntry;
    }

    public void help() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement();
        Shell shell = (Shell)xulDialog.getRootObject();
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.jobEntry.getPluginId());
        HelpUtils.openHelpDialog((Shell)shell, (PluginInterface)plugin);
    }

    private void populateDriverMenuList() {
        if (Const.isEmpty((String)this.jarUrl)) {
            return;
        }
        try {
            URL resolvedJarUrl = this.jobEntry.resolveJarUrl(this.jarUrl);
            HadoopShim shim = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration().getHadoopShim();
            JarUtility jarUtil = new JarUtility();
            List<Class<?>> clazzes = jarUtil.getClassesInJarWithMain(resolvedJarUrl.toExternalForm(), shim.getClass().getClassLoader());
            ArrayList<String> driverClasses = new ArrayList<String>();
            for (Class<?> clazz : clazzes) {
                driverClasses.add(clazz.getName());
            }
            if (Const.isEmpty((String)this.driverClass)) {
                this.setDriverClasses(driverClasses);
                Class<?> mainClass = jarUtil.getMainClassFromManifest(resolvedJarUrl, shim.getClass().getClassLoader());
                if (mainClass != null) {
                    this.setDriverClass(mainClass.getName());
                } else if (!driverClasses.isEmpty()) {
                    this.setDriverClass((String)driverClasses.get(0));
                }
            } else {
                String saveDriverClass = this.driverClass;
                this.setDriverClasses(driverClasses);
                this.setDriverClass(saveDriverClass);
            }
        }
        catch (Throwable e) {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getRootElement();
            Shell shell = (Shell)xulDialog.getRootObject();
            new ErrorDialog(shell, "Error", "Unable to populate Driver Class list", e);
            this.setDriverClasses(Collections.<String>emptyList());
        }
    }

    public class AdvancedConfiguration
    extends XulEventSourceAdapter {
        public static final String OUTPUT_KEY_CLASS = "outputKeyClass";
        public static final String OUTPUT_VALUE_CLASS = "outputValueClass";
        public static final String MAPPER_CLASS = "mapperClass";
        public static final String COMBINER_CLASS = "combinerClass";
        public static final String REDUCER_CLASS = "reducerClass";
        public static final String INPUT_FORMAT_CLASS = "inputFormatClass";
        public static final String OUTPUT_FORMAT_CLASS = "outputFormatClass";
        public static final String INPUT_PATH = "inputPath";
        public static final String OUTPUT_PATH = "outputPath";
        public static final String BLOCKING = "blocking";
        public static final String LOGGING_INTERVAL = "loggingInterval";
        public static final String HDFS_HOSTNAME = "hdfsHostname";
        public static final String HDFS_PORT = "hdfsPort";
        public static final String JOB_TRACKER_HOSTNAME = "jobTrackerHostname";
        public static final String JOB_TRACKER_PORT = "jobTrackerPort";
        public static final String NUM_MAP_TASKS = "numMapTasks";
        public static final String NUM_REDUCE_TASKS = "numReduceTasks";
        private String outputKeyClass;
        private String outputValueClass;
        private String mapperClass;
        private String combinerClass;
        private String reducerClass;
        private String inputFormatClass;
        private String outputFormatClass;
        private String hdfsHostname;
        private String hdfsPort;
        private String jobTrackerHostname;
        private String jobTrackerPort;
        private String inputPath;
        private String outputPath;
        private String numMapTasks = "1";
        private String numReduceTasks = "1";
        private boolean blocking;
        private String loggingInterval = "60";

        public String getOutputKeyClass() {
            return this.outputKeyClass;
        }

        public void setOutputKeyClass(String outputKeyClass) {
            String previousVal = this.outputKeyClass;
            String newVal = outputKeyClass;
            this.outputKeyClass = outputKeyClass;
            this.firePropertyChange(OUTPUT_KEY_CLASS, previousVal, newVal);
        }

        public String getOutputValueClass() {
            return this.outputValueClass;
        }

        public void setOutputValueClass(String outputValueClass) {
            String previousVal = this.outputValueClass;
            String newVal = outputValueClass;
            this.outputValueClass = outputValueClass;
            this.firePropertyChange(OUTPUT_VALUE_CLASS, previousVal, newVal);
        }

        public String getMapperClass() {
            return this.mapperClass;
        }

        public void setMapperClass(String mapperClass) {
            String previousVal = this.mapperClass;
            String newVal = mapperClass;
            this.mapperClass = mapperClass;
            this.firePropertyChange(MAPPER_CLASS, previousVal, newVal);
        }

        public String getCombinerClass() {
            return this.combinerClass;
        }

        public void setCombinerClass(String combinerClass) {
            String previousVal = this.combinerClass;
            String newVal = combinerClass;
            this.combinerClass = combinerClass;
            this.firePropertyChange(COMBINER_CLASS, previousVal, newVal);
        }

        public String getReducerClass() {
            return this.reducerClass;
        }

        public void setReducerClass(String reducerClass) {
            String previousVal = this.reducerClass;
            String newVal = reducerClass;
            this.reducerClass = reducerClass;
            this.firePropertyChange(REDUCER_CLASS, previousVal, newVal);
        }

        public String getInputFormatClass() {
            return this.inputFormatClass;
        }

        public void setInputFormatClass(String inputFormatClass) {
            String previousVal = this.inputFormatClass;
            String newVal = inputFormatClass;
            this.inputFormatClass = inputFormatClass;
            this.firePropertyChange(INPUT_FORMAT_CLASS, previousVal, newVal);
        }

        public String getOutputFormatClass() {
            return this.outputFormatClass;
        }

        public void setOutputFormatClass(String outputFormatClass) {
            String previousVal = this.outputFormatClass;
            String newVal = outputFormatClass;
            this.outputFormatClass = outputFormatClass;
            this.firePropertyChange(OUTPUT_FORMAT_CLASS, previousVal, newVal);
        }

        public String getHdfsHostname() {
            return this.hdfsHostname;
        }

        public void setHdfsHostname(String hdfsHostname) {
            String previousVal = this.hdfsHostname;
            String newVal = hdfsHostname;
            this.hdfsHostname = hdfsHostname;
            this.firePropertyChange(HDFS_HOSTNAME, previousVal, newVal);
        }

        public String getHdfsPort() {
            return this.hdfsPort;
        }

        public void setHdfsPort(String hdfsPort) {
            String previousVal = this.hdfsPort;
            String newVal = hdfsPort;
            this.hdfsPort = hdfsPort;
            this.firePropertyChange(HDFS_PORT, previousVal, newVal);
        }

        public String getJobTrackerHostname() {
            return this.jobTrackerHostname;
        }

        public void setJobTrackerHostname(String jobTrackerHostname) {
            String previousVal = this.jobTrackerHostname;
            String newVal = jobTrackerHostname;
            this.jobTrackerHostname = jobTrackerHostname;
            this.firePropertyChange(JOB_TRACKER_HOSTNAME, previousVal, newVal);
        }

        public String getJobTrackerPort() {
            return this.jobTrackerPort;
        }

        public void setJobTrackerPort(String jobTrackerPort) {
            String previousVal = this.jobTrackerPort;
            String newVal = jobTrackerPort;
            this.jobTrackerPort = jobTrackerPort;
            this.firePropertyChange(JOB_TRACKER_PORT, previousVal, newVal);
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public void setInputPath(String inputPath) {
            String previousVal = this.inputPath;
            String newVal = inputPath;
            this.inputPath = inputPath;
            this.firePropertyChange(INPUT_PATH, previousVal, newVal);
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public void setOutputPath(String outputPath) {
            String previousVal = this.outputPath;
            String newVal = outputPath;
            this.outputPath = outputPath;
            this.firePropertyChange(OUTPUT_PATH, previousVal, newVal);
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public void setBlocking(boolean blocking) {
            boolean previousVal = this.blocking;
            boolean newVal = blocking;
            this.blocking = blocking;
            this.firePropertyChange(BLOCKING, previousVal, newVal);
        }

        public String getLoggingInterval() {
            return this.loggingInterval;
        }

        public void setLoggingInterval(String loggingInterval) {
            String previousVal = this.loggingInterval;
            String newVal = loggingInterval;
            this.loggingInterval = loggingInterval;
            this.firePropertyChange(LOGGING_INTERVAL, previousVal, newVal);
        }

        public String getNumMapTasks() {
            return this.numMapTasks;
        }

        public void setNumMapTasks(String numMapTasks) {
            String previousVal = this.numMapTasks;
            String newVal = numMapTasks;
            this.numMapTasks = numMapTasks;
            this.firePropertyChange(NUM_MAP_TASKS, previousVal, newVal);
        }

        public String getNumReduceTasks() {
            return this.numReduceTasks;
        }

        public void setNumReduceTasks(String numReduceTasks) {
            String previousVal = this.numReduceTasks;
            String newVal = numReduceTasks;
            this.numReduceTasks = numReduceTasks;
            this.firePropertyChange(NUM_REDUCE_TASKS, previousVal, newVal);
        }
    }

    public class SimpleConfiguration
    extends XulEventSourceAdapter {
        public static final String CMD_LINE_ARGS = "commandLineArgs";
        public static final String BLOCKING = "simpleBlocking";
        public static final String LOGGING_INTERVAL = "simpleLoggingInterval";
        private String cmdLineArgs;
        private boolean simpleBlocking;
        private String simpleLoggingInterval = "60";

        public String getCommandLineArgs() {
            return this.cmdLineArgs;
        }

        public void setCommandLineArgs(String cmdLineArgs) {
            String previousVal = this.cmdLineArgs;
            String newVal = cmdLineArgs;
            this.cmdLineArgs = cmdLineArgs;
            this.firePropertyChange(CMD_LINE_ARGS, previousVal, newVal);
        }

        public boolean isSimpleBlocking() {
            return this.simpleBlocking;
        }

        public void setSimpleBlocking(boolean simpleBlocking) {
            boolean old = this.simpleBlocking;
            this.simpleBlocking = simpleBlocking;
            this.firePropertyChange(BLOCKING, old, this.simpleBlocking);
        }

        public String getSimpleLoggingInterval() {
            return this.simpleLoggingInterval;
        }

        public void setSimpleLoggingInterval(String simpleLoggingInterval) {
            String old = this.simpleLoggingInterval;
            this.simpleLoggingInterval = simpleLoggingInterval;
            this.firePropertyChange(LOGGING_INTERVAL, old, this.simpleLoggingInterval);
        }
    }
}

