/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;

public class HBaseRowToKettleTuple {
    protected List<Object[]> m_decodedTuples;
    protected int m_keyIndex = -1;
    protected int m_familyIndex = -1;
    protected int m_colNameIndex = -1;
    protected int m_valueIndex = -1;
    protected int m_timestampIndex = -1;
    protected List<byte[]> m_userSpecifiedFamilies;
    protected List<String> m_userSpecifiedFamiliesHumanReadable;
    protected List<HBaseValueMeta> m_tupleColsFromAliasMap;
    protected HBaseBytesUtilShim m_bytesUtil;

    public HBaseRowToKettleTuple(HBaseBytesUtilShim bytesUtil) {
        if (bytesUtil == null) {
            throw new NullPointerException();
        }
        this.m_bytesUtil = bytesUtil;
    }

    public void reset() {
        this.m_decodedTuples = null;
        this.m_keyIndex = -1;
        this.m_familyIndex = -1;
        this.m_colNameIndex = -1;
        this.m_valueIndex = -1;
        this.m_timestampIndex = -1;
        this.m_userSpecifiedFamilies = null;
        this.m_userSpecifiedFamiliesHumanReadable = null;
        this.m_tupleColsFromAliasMap = null;
        this.m_decodedTuples = null;
    }

    public List<Object[]> hbaseRowToKettleTupleMode(Object hRow, HBaseConnection admin, Mapping mapping, Map<String, HBaseValueMeta> tupleColsMappedByAlias, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.m_decodedTuples == null) {
            this.m_tupleColsFromAliasMap = new ArrayList<HBaseValueMeta>();
            HBaseValueMeta keyMeta = new HBaseValueMeta(mapping.getKeyName() + "," + "dummy", 5, 0, 0);
            this.m_tupleColsFromAliasMap.add(keyMeta);
            for (String alias : tupleColsMappedByAlias.keySet()) {
                this.m_tupleColsFromAliasMap.add(tupleColsMappedByAlias.get(alias));
            }
        }
        return this.hbaseRowToKettleTupleMode(hRow, admin, mapping, this.m_tupleColsFromAliasMap, outputRowMeta);
    }

    public List<Object[]> hbaseRowToKettleTupleMode(Object hRow, HBaseConnection admin, Mapping mapping, List<HBaseValueMeta> tupleCols, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.m_decodedTuples == null) {
            this.m_decodedTuples = new ArrayList<Object[]>();
            this.m_keyIndex = outputRowMeta.indexOfValue(mapping.getKeyName());
            this.m_familyIndex = outputRowMeta.indexOfValue("Family");
            this.m_colNameIndex = outputRowMeta.indexOfValue("Column");
            this.m_valueIndex = outputRowMeta.indexOfValue("Value");
            this.m_timestampIndex = outputRowMeta.indexOfValue("Timestamp");
            if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
                String[] familiesS = mapping.getTupleFamilies().split(",");
                this.m_userSpecifiedFamilies = new ArrayList<byte[]>();
                this.m_userSpecifiedFamiliesHumanReadable = new ArrayList<String>();
                String[] arr$ = familiesS;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object family = arr$[i$];
                    this.m_userSpecifiedFamiliesHumanReadable.add((String)family);
                    this.m_userSpecifiedFamilies.add(this.m_bytesUtil.toBytes(((String)family).trim()));
                }
            }
        } else {
            this.m_decodedTuples.clear();
        }
        byte[] rawKey = null;
        try {
            rawKey = hRow == null ? admin.getResultSetCurrentRowKey() : admin.getRowKey(hRow);
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        Object decodedKey = HBaseValueMeta.decodeKeyValue((byte[])rawKey, (Mapping)mapping, (HBaseBytesUtilShim)this.m_bytesUtil);
        NavigableMap rowData = null;
        try {
            rowData = hRow == null ? admin.getResultSetCurrentRowMap() : admin.getRowMap(hRow);
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        try {
            admin.getResultSetCurrentRowMap();
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
            int i = 0;
            for (byte[] family : this.m_userSpecifiedFamilies) {
                NavigableMap colMap = (NavigableMap)rowData.get(family);
                for (byte[] colName : colMap.keySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMap.get(colName);
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.m_keyIndex != -1) {
                        newTuple[this.m_keyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.m_timestampIndex != -1) {
                        newTuple[this.m_timestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.m_colNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMeta colNameMeta = tupleCols.get(this.m_colNameIndex);
                        newTuple[this.m_colNameIndex] = decodedColName = HBaseValueMeta.decodeColumnValue((byte[])colName, (HBaseValueMeta)colNameMeta, (HBaseBytesUtilShim)this.m_bytesUtil);
                    }
                    if (this.m_valueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMeta colValueMeta = tupleCols.get(this.m_valueIndex);
                        newTuple[this.m_valueIndex] = decodedValue = HBaseValueMeta.decodeColumnValue((byte[])((byte[])mostRecentColVal.getValue()), (HBaseValueMeta)colValueMeta, (HBaseBytesUtilShim)this.m_bytesUtil);
                    }
                    if (this.m_familyIndex != -1) {
                        newTuple[this.m_familyIndex] = this.m_userSpecifiedFamiliesHumanReadable.get(i);
                    }
                    this.m_decodedTuples.add(newTuple);
                }
                ++i;
            }
        } else {
            for (Object family : rowData.keySet()) {
                Object decodedFamily = null;
                if (this.m_familyIndex != -1) {
                    HBaseValueMeta colFamMeta = tupleCols.get(this.m_familyIndex);
                    decodedFamily = HBaseValueMeta.decodeColumnValue((byte[])family, (HBaseValueMeta)colFamMeta, (HBaseBytesUtilShim)this.m_bytesUtil);
                }
                NavigableMap colMap = (NavigableMap)rowData.get(family);
                for (byte[] colName : colMap.keySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMap.get(colName);
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.m_keyIndex != -1) {
                        newTuple[this.m_keyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.m_timestampIndex != -1) {
                        newTuple[this.m_timestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.m_colNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMeta colNameMeta = tupleCols.get(this.m_colNameIndex);
                        newTuple[this.m_colNameIndex] = decodedColName = HBaseValueMeta.decodeColumnValue((byte[])colName, (HBaseValueMeta)colNameMeta, (HBaseBytesUtilShim)this.m_bytesUtil);
                    }
                    if (this.m_valueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMeta colValueMeta = tupleCols.get(this.m_valueIndex);
                        newTuple[this.m_valueIndex] = decodedValue = HBaseValueMeta.decodeColumnValue((byte[])((byte[])mostRecentColVal.getValue()), (HBaseValueMeta)colValueMeta, (HBaseBytesUtilShim)this.m_bytesUtil);
                    }
                    if (this.m_familyIndex != -1) {
                        newTuple[this.m_familyIndex] = decodedFamily;
                    }
                    this.m_decodedTuples.add(newTuple);
                }
            }
        }
        return this.m_decodedTuples;
    }
}

