/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.PluginSettings;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.packager.origin.PluginRepositoryOrigin;
import pt.webdetails.cpf.packager.origin.StaticSystemOrigin;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CdeSettings {
    protected static Log logger = LogFactory.getLog(CdeSettings.class);
    private static CdfDDSettings settings = new CdfDDSettings();

    private CdeSettings() {
    }

    public static CdfDDSettings getSettings() {
        return settings;
    }

    public static Collection<PathOrigin> getCustomComponentLocations() {
        return settings.getComponentLocations();
    }

    public static IReadAccess[] getComponentLocations() {
        ArrayList<IReadAccess> componentAccesses = new ArrayList<IReadAccess>();
        CdfDDSettings settings = CdeSettings.getSettings();
        for (Element element : settings.getComponentLocationElements()) {
            String path = element.getText();
            if (path == null) continue;
            if ((path = StringUtils.strip((String)path, (String)"/")).startsWith(CdeEnvironment.getSystemDir() + "/")) {
                if ((path = path.replaceFirst(CdeEnvironment.getSystemDir() + "/", "")).startsWith(CdeEnvironment.getPluginId() + "/")) {
                    path = path.replaceFirst(CdeEnvironment.getPluginId() + "/", "");
                    if (!CdeEnvironment.getPluginSystemReader().fileExists(path) || !CdeEnvironment.getPluginSystemReader().fetchFile(path).isDirectory()) continue;
                    componentAccesses.add(CdeEnvironment.getPluginSystemReader((String)path));
                    continue;
                }
                String pluginId = path.substring(0, path.indexOf("/"));
                path = path.replaceFirst(pluginId + "/", "");
                if (!CdeEnvironment.getOtherPluginSystemReader((String)pluginId).fileExists(path) || !CdeEnvironment.getOtherPluginSystemReader((String)pluginId).fetchFile(path).isDirectory()) continue;
                componentAccesses.add(CdeEnvironment.getOtherPluginSystemReader((String)pluginId, (String)path));
                continue;
            }
            if (path.startsWith(CdeEnvironment.getPluginRepositoryDir() + "/")) {
                path = path.replaceFirst(CdeEnvironment.getPluginRepositoryDir() + "/", "");
                if (!CdeEnvironment.getPluginSystemReader().fileExists(path) || !CdeEnvironment.getPluginSystemReader().fetchFile(path).isDirectory()) continue;
                componentAccesses.add(CdeEnvironment.getPluginRepositoryReader((String)path));
                continue;
            }
            logger.warn((Object)("Components directory '" + element.getText() + "' was not found."));
        }
        return componentAccesses.toArray(new IReadAccess[componentAccesses.size()]);
    }

    public static String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    private static class CdfDDSettings
    extends PluginSettings {
        public CdfDDSettings() {
            super(CdeEnvironment.getPluginSystemWriter());
        }

        List<Element> getComponentLocationElements() {
            return this.getSettingsXmlSection("custom-components/path");
        }

        public List<PathOrigin> getComponentLocations() {
            List pathElements = this.getSettingsXmlSection("custom-components/path");
            ArrayList<PathOrigin> locations = new ArrayList<PathOrigin>();
            for (Element pathElement : pathElements) {
                String path = StringUtils.strip((String)pathElement.getTextTrim());
                String origin = pathElement.attributeValue("origin");
                if (!StringUtils.isEmpty((String)origin)) {
                    if (StringUtils.equals((String)origin, (String)"static")) {
                        locations.add((PathOrigin)new StaticSystemOrigin(path));
                        continue;
                    }
                    if (!StringUtils.equals((String)origin, (String)"repo")) continue;
                    locations.add((PathOrigin)new PluginRepositoryOrigin(CdeEngine.getEnv().getPluginRepositoryDir(), path));
                    continue;
                }
                logger.error((Object)("Must specify origin (static|repo), location '" + path + " 'ignored."));
            }
            return locations;
        }
    }
}

