/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import pt.webdetails.cdf.dd.api.RenderApi;
import pt.webdetails.cdf.dd.api.ResourcesApi;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.SimpleContentGenerator;
import pt.webdetails.cpf.audit.CpfAuditHelper;

public class DashboardDesignerContentGenerator
extends SimpleContentGenerator {
    private static final Log logger = LogFactory.getLog(DashboardDesignerContentGenerator.class);
    private boolean edit = false;
    private boolean create = false;
    private boolean resource = false;

    public Log getLogger() {
        return logger;
    }

    public void createContent() throws Exception {
        String result;
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        String solution = this.getRequestParameterAsString("solution", "");
        String path = this.getRequestParameterAsString("path", "");
        String file = this.getRequestParameterAsString("file", "");
        String root = this.getRequestParameterAsString("root", "");
        String viewId = this.getRequestParameterAsString("viewId", "");
        String filePath = this.getPathParameterAsString("path", "");
        boolean inferScheme = requestParams.hasParameter("inferScheme") && this.getRequestParameterAsString("inferScheme", "").equals("false");
        boolean absolute = requestParams.hasParameter("absolute") && this.getRequestParameterAsString("absolute", "").equals("true");
        boolean bypassCacheRead = requestParams.hasParameter("bypassCache") && this.getRequestParameterAsString("bypassCache", "").equals("true");
        boolean debug = requestParams.hasParameter("debug") && this.getRequestParameterAsString("debug", "").equals("true");
        String style = this.getRequestParameterAsString("style", "");
        RenderApi renderer = new RenderApi();
        long start = System.currentTimeMillis();
        UUID uuid = CpfAuditHelper.startAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (IParameterProvider)requestParams);
        if (this.create) {
            result = renderer.newDashboard(filePath, debug, true, this.getRequest(), this.getResponse());
            IOUtils.write((String)result, (OutputStream)this.getResponse().getOutputStream());
        } else if (this.edit) {
            result = renderer.edit("", "", filePath, debug, true, this.getRequest(), this.getResponse());
            IOUtils.write((String)result, (OutputStream)this.getResponse().getOutputStream());
        } else if (this.resource) {
            new ResourcesApi().getResource(pathParams.getStringParameter("cmd", ""), this.getResponse());
        } else {
            result = renderer.render("", "", filePath, inferScheme, root, absolute, bypassCacheRead, debug, viewId, style, this.getRequest());
            this.getResponse().setContentType("text/html");
            IOUtils.write((String)result, (OutputStream)this.getResponse().getOutputStream());
            this.getResponse().getOutputStream().flush();
        }
        long end = System.currentTimeMillis();
        CpfAuditHelper.endAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (long)start, (UUID)uuid, (long)end);
    }

    public String getPluginName() {
        return CdeEnvironment.getPluginId();
    }

    public String getObjectName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isResource() {
        return this.resource;
    }

    public void setResource(boolean resource) {
        this.resource = resource;
    }

    public static String getPluginDir() {
        return CdeEnvironment.getSystemDir() + "/" + CdeEnvironment.getPluginId() + "/";
    }

    private class MethodParams {
        public static final String DEBUG = "debug";
        public static final String BYPASS_CACHE = "bypassCache";
        public static final String ROOT = "root";
        public static final String INFER_SCHEME = "inferScheme";
        public static final String ABSOLUTE = "absolute";
        public static final String SOLUTION = "solution";
        public static final String PATH = "path";
        public static final String FILE = "file";
        public static final String REQUEST = "request";
        public static final String VIEWID = "viewId";
        public static final String COMMAND = "cmd";
        public static final String STYLE = "style";
        public static final String DATA = "data";

        private MethodParams() {
        }
    }
}

