/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cdf.dd.CdeSettings;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.packager.origin.OtherPluginStaticSystemOrigin;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;

public final class FsPluginResourceLocations {
    private List<PathOrigin> customComponentDirectories = new ArrayList<PathOrigin>();
    protected static final Log logger = LogFactory.getLog(FsPluginResourceLocations.class);

    public FsPluginResourceLocations() {
        this.initLocations();
    }

    public List<PathOrigin> getCustomComponentLocations() {
        return this.customComponentDirectories;
    }

    private void initLocations() {
        for (PathOrigin origin : CdeSettings.getCustomComponentLocations()) {
            this.customComponentDirectories.add(origin);
        }
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer(CdeEnvironment.getContentAccessFactory(), (IPluginManager)PentahoSystem.get(IPluginManager.class));
        pluginsAnalyzer.refresh();
        for (PluginsAnalyzer.PluginPair entry : pluginsAnalyzer.getPluginsWithSection("/cde-components/path")) {
            for (Element pathNode : (List)entry.getValue()) {
                String path = StringUtils.strip((String)pathNode.getStringValue());
                String origin = pathNode.attributeValue("origin");
                if (!StringUtils.isEmpty((String)origin)) continue;
                this.customComponentDirectories.add(this.inferPathOriginFromLegacyLocation(entry.getPlugin(), path));
                logger.debug((Object)String.format("Found CDE components location declared in %s [%s]", entry.getPlugin().getId(), path));
            }
        }
    }

    private PathOrigin inferPathOriginFromLegacyLocation(Plugin plugin, String path) {
        if (path.startsWith("system")) {
            path = StringUtils.removeStart((String)path, (String)"system/");
            path = path.substring(path.indexOf("/"));
        }
        return new OtherPluginStaticSystemOrigin(plugin.getId(), path);
    }
}

