/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import pt.webdetails.cdf.dd.ICdeEnvironmentExtended;
import pt.webdetails.cdf.dd.IPluginResourceLocationManager;
import pt.webdetails.cdf.dd.InitializationException;
import pt.webdetails.cdf.dd.InterPluginBroker;
import pt.webdetails.cdf.dd.bean.factory.ICdeBeanFactory;
import pt.webdetails.cdf.dd.datasources.DataSourceManager;
import pt.webdetails.cdf.dd.datasources.IDataSourceManager;
import pt.webdetails.cdf.dd.extapi.CdeApiPathProvider;
import pt.webdetails.cdf.dd.extapi.ICdeApiPathProvider;
import pt.webdetails.cdf.dd.extapi.IFileHandler;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.PentahoCdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.plugin.resource.PluginResourceLocationManager;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.PentahoUrlProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.resources.IResourceLoader;

public class PentahoCdeEnvironment
extends PentahoPluginEnvironment
implements ICdeEnvironmentExtended {
    private static final String PLUGIN_REPOSITORY_DIR = "/public/cde";
    private static final String SYSTEM_DIR = "system";
    private static final String PLUGIN = "plugin";
    private static final String CDE_XML = "cde.xml";
    private static final String API_REPOS = "api/repos/";
    protected static Log logger = LogFactory.getLog(PentahoCdeEnvironment.class);
    private ICdeBeanFactory factory;
    private IResourceLoader resourceLoader;
    private IPluginResourceLocationManager pluginResourceLocationManager;
    private ICdeApiPathProvider apiPaths;
    private IFileHandler fileHandler;

    public void init(ICdeBeanFactory factory) throws InitializationException {
        this.factory = factory;
        this.pluginResourceLocationManager = new PluginResourceLocationManager();
        if (factory.containsBean(IResourceLoader.class.getSimpleName())) {
            this.resourceLoader = (IResourceLoader)factory.getBean(IResourceLoader.class.getSimpleName());
        }
        if (factory.containsBean(IFileHandler.class.getSimpleName())) {
            this.fileHandler = (IFileHandler)factory.getBean(IFileHandler.class.getSimpleName());
        }
        PentahoPluginEnvironment.init((PluginEnvironment)this);
    }

    public void refresh() {
        try {
            this.init(this.factory);
        }
        catch (InitializationException e) {
            logger.error((Object)"PentahoCdeEnvironment.refresh()", (Throwable)e);
        }
    }

    public String getApplicationBaseUrl() {
        return PentahoSystem.getApplicationContext().getBaseUrl();
    }

    public String getApplicationReposUrl() {
        return this.getApplicationBaseUrl() + API_REPOS;
    }

    public IDataSourceManager getDataSourceManager() {
        return DataSourceManager.getInstance();
    }

    public Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    public IPluginResourceLocationManager getPluginResourceLocationManager() {
        return this.pluginResourceLocationManager;
    }

    public IResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getPluginRepositoryDir() {
        return PLUGIN_REPOSITORY_DIR;
    }

    public String getPluginId() {
        return super.getPluginId();
    }

    public String getSystemDir() {
        return SYSTEM_DIR;
    }

    public String getApplicationBaseContentUrl() {
        return Utils.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/";
    }

    public String getRepositoryBaseContentUrl() {
        return Utils.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/res/";
    }

    public String getCdfIncludes(String dashboard, String type, boolean debug, boolean absolute, String absRoot, String scheme) throws Exception {
        return InterPluginBroker.getCdfIncludes(dashboard, type, debug, absolute, absRoot, scheme);
    }

    public PentahoPluginEnvironment getPluginEnv() {
        return PentahoPluginEnvironment.getInstance();
    }

    public ICdeApiPathProvider getExtApi() {
        if (this.apiPaths == null) {
            this.apiPaths = new CdeApiPathProvider(this.getPluginEnv().getUrlProvider());
        }
        return this.apiPaths;
    }

    public IFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public CdfRunJsDashboardWriteContext getCdfRunJsDashboardWriteContext(IThingWriterFactory factory, String indent, boolean bypassCacheRead, Dashboard dash, CdfRunJsDashboardWriteOptions options) {
        return new PentahoCdfRunJsDashboardWriteContext(factory, indent, bypassCacheRead, dash, options);
    }

    public CdfRunJsDashboardWriteContext getCdfRunJsDashboardWriteContext(CdfRunJsDashboardWriteContext factory, String indent) {
        return new PentahoCdfRunJsDashboardWriteContext(factory, indent);
    }

    public IBasicFile getCdeXml() {
        if (this.getUserContentAccess("/").fileExists("/public/cde/cde.xml")) {
            return this.getUserContentAccess("/").fetchFile("/public/cde/cde.xml");
        }
        if (this.getPluginSystemReader(null).fileExists(CDE_XML)) {
            return this.getPluginSystemReader(null).fetchFile(CDE_XML);
        }
        return null;
    }

    public IUrlProvider getUrlProvider() {
        return new PentahoUrlProvider(this.getPluginId()){

            public String getResourcesBasePath() {
                return PentahoCdeEnvironment.this.getExtApi().getResourcesBasePath();
            }
        };
    }
}

