/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.PluginResource;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.ResourceLoaderFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.MimeTypeHandler;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

@Path(value="pentaho-cdf-dd/api/resources")
public class ResourcesApi {
    private static final Log logger = LogFactory.getLog(ResourcesApi.class);

    @GET
    @Path(value="/get")
    @Produces(value={"text/plain"})
    public void getResource(@QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        try {
            String mimeType;
            IBasicFile file = Utils.getFileViaAppropriateReadAccess((String)resource);
            if (file == null) {
                logger.error((Object)("resource not found:" + resource));
                response.sendError(500);
                return;
            }
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String maxAge = resLoader.getPluginSetting(this.getClass(), "max-age");
            try {
                mimeType = MimeTypeHandler.getMimeTypeFromExtension((String)file.getExtension());
            }
            catch (IllegalArgumentException ex) {
                mimeType = "";
            }
            catch (EnumConstantNotPresentException ex) {
                mimeType = "";
            }
            response.setHeader("Content-Type", mimeType);
            response.setHeader("content-disposition", "inline; filename=\"" + file.getName() + "\"");
            if (maxAge != null) {
                response.setHeader("Cache-Control", "max-age=" + maxAge);
            }
            byte[] contents = IOUtils.toByteArray((InputStream)file.getContents());
            IOUtils.write((byte[])contents, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (SecurityException e) {
            response.sendError(403);
        }
    }

    @GET
    @Path(value="/getCss")
    @Produces(value={"text/css"})
    public void getCssResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getJs")
    @Produces(value={"text/javascript"})
    public void getJsResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getUntyped")
    @Produces(value={"text/plain"})
    public void getUntypedResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        response.setHeader("content-disposition", "inline");
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getImg")
    @Produces(value={"text/plain"})
    public void getImage(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/res")
    @Produces(value={"text/plain"})
    public void res(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws Exception {
        this.getResource(resource, response);
    }

    @POST
    @Path(value="/explore")
    @Produces(value={"text/plain"})
    public String exploreFolder(@FormParam(value="dir") @DefaultValue(value="/") String folder, @FormParam(value="outputType") String outputType, @QueryParam(value="dashboardPath") @DefaultValue(value="") String dashboardPath, @QueryParam(value="fileExtensions") String fileExtensions, @QueryParam(value="access") String access, @QueryParam(value="showHiddenFiles") @DefaultValue(value="false") boolean showHiddenFiles) throws IOException {
        if (!StringUtils.isEmpty((String)outputType) && outputType.equals("json")) {
            try {
                return RepositoryHelper.toJSON((String)folder, (IBasicFile[])this.getFileList(folder, dashboardPath, fileExtensions, access, showHiddenFiles));
            }
            catch (JSONException e) {
                logger.error((Object)("exploreFolder" + folder), (Throwable)e);
                return "Error getting files in folder " + folder;
            }
        }
        return RepositoryHelper.toJQueryFileTree((String)folder, (IBasicFile[])this.getFileList(folder, dashboardPath, fileExtensions, access, showHiddenFiles));
    }

    private IBasicFile[] getFileList(String dir, String dashboardPath, String fileExtensions, String permission, boolean showHiddenFiles) {
        List fileList;
        String path;
        FileAccess fileAccess;
        ArrayList<String> extensionsList = new ArrayList<String>();
        String[] extensions = StringUtils.split((String)fileExtensions, (String)".");
        IResourceLoader loader = new ResourceLoaderFactory().getResourceLoader(dashboardPath);
        if (extensions != null) {
            for (String extension : extensions) {
                extensionsList.add("." + extension);
                extensionsList.add(extension);
            }
        }
        if ((fileAccess = FileAccess.parse((String)permission)) == null) {
            fileAccess = FileAccess.READ;
        }
        GenericBasicFileFilter fileFilter = new GenericBasicFileFilter(null, extensionsList.toArray(new String[extensionsList.size()]), true);
        boolean isSystem = false;
        if (!dashboardPath.isEmpty() && (path = dashboardPath.toLowerCase().replaceFirst("/", "")).startsWith(CdeEnvironment.getSystemDir() + "/")) {
            isSystem = true;
        }
        IReadAccess access = loader.getReader();
        if (isSystem) {
            fileList = access.listFiles(dir, (IBasicFileFilter)fileFilter, 1, true, false);
            fileList.remove(0);
        } else {
            fileList = access.listFiles(dir, (IBasicFileFilter)fileFilter, 1, true, showHiddenFiles);
        }
        if (fileList != null && fileList.size() > 0) {
            return fileList.toArray(new IBasicFile[fileList.size()]);
        }
        return new IBasicFile[0];
    }

    @GET
    @Path(value="/system/{path: [^?]+ }")
    @Produces(value={"*/*"})
    public Response getSystemResource(@PathParam(value="path") String path, @Context HttpServletResponse response) throws IOException {
        Response readFileResponse;
        String[] splitPath = path.split("/");
        String pluginId = splitPath[0];
        String resource = "";
        for (int i = 1; i < splitPath.length; ++i) {
            resource = resource + "/" + splitPath[i];
        }
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (!StringUtils.isEmpty((String)path) && pluginManager.isPublic(pluginId, resource) && (readFileResponse = new PluginResource(response).readFile(pluginId, resource)).getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
            return readFileResponse;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{resource: [^?]+ }")
    @Produces(value={"*/*"})
    public void resource(@PathParam(value="resource") String resource, @Context HttpServletResponse response) throws Exception {
        this.getResource(resource, response);
    }
}

