/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.DashboardDesignerException;
import pt.webdetails.cdf.dd.cdf.CdfStyles;
import pt.webdetails.cdf.dd.cdf.CdfTemplates;
import pt.webdetails.cdf.dd.structure.DashboardStructure;
import pt.webdetails.cdf.dd.structure.DashboardStructureException;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IRWAccess;

@Path(value="pentaho-cdf-dd/api/syncronizer")
public class SyncronizerApi {
    private static final Log logger = LogFactory.getLog(SyncronizerApi.class);
    private static final String OPERATION_LOAD = "load";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_SAVE = "save";
    private static final String OPERATION_SAVE_AS = "saveas";
    private static final String OPERATION_NEW_FILE = "newfile";
    private static final String OPERATION_SAVE_SETTINGS = "savesettings";
    private static final String GET_RESOURCE = "api/resources/get?resource=";
    public static final String UNSAVED_FILE_PATH = "null/null/null";

    @POST
    @Path(value="/syncronizeDashboard")
    @Produces(value={"application/json"})
    public String syncronize(@FormParam(value="file") @DefaultValue(value="") String file, @FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="title") @DefaultValue(value="") String title, @FormParam(value="author") @DefaultValue(value="") String author, @FormParam(value="description") @DefaultValue(value="") String description, @FormParam(value="style") @DefaultValue(value="") String style, @FormParam(value="widgetName") @DefaultValue(value="") String widgetName, @FormParam(value="widget") boolean widget, @FormParam(value="rendererType") @DefaultValue(value="") String rendererType, @FormParam(value="widgetParameters") List<String> widgetParams, @FormParam(value="cdfstructure") String cdfStructure, @FormParam(value="operation") String operation, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        boolean isPreview = false;
        if (!file.isEmpty() && !file.equals(UNSAVED_FILE_PATH)) {
            String fileDir = file.contains(".wcdf") || file.contains(".cdfde") ? file.substring(0, file.lastIndexOf("/")) : file;
            isPreview = file.indexOf("_tmp.cdfde") > -1 || file.indexOf("_tmp.wcdf") > -1;
            IRWAccess rwAccess = Utils.getSystemOrUserRWAccess((String)file);
            if (rwAccess == null) {
                String msg = "Access denied for the syncronize method syncronizeDashboard." + operation + " : " + file;
                logger.warn((Object)msg);
                return JsonUtils.getJsonResult((boolean)false, (Object)msg);
            }
        }
        try {
            String[] widgetParameters;
            DashboardStructure dashboardStructure = new DashboardStructure();
            HashMap result = null;
            HashMap<String, Object> params = new HashMap<String, Object>(request.getParameterMap());
            params.put("file", file);
            params.put("widget", String.valueOf(widget));
            if (!author.isEmpty()) {
                params.put("author", author);
            }
            if (!style.isEmpty()) {
                params.put("style", style);
            }
            if (!widgetName.isEmpty()) {
                params.put("widgetName", widgetName);
            }
            if (!rendererType.isEmpty()) {
                params.put("rendererType", rendererType);
            }
            if (!title.isEmpty()) {
                params.put("title", title);
            }
            if (!description.isEmpty()) {
                params.put("description", description);
            }
            if ((widgetParameters = widgetParams.toArray(new String[0])).length > 0) {
                params.put("widgetParameters", widgetParameters);
            }
            String wcdfdeFile = file.replace(".wcdf", ".cdfde");
            if (OPERATION_LOAD.equalsIgnoreCase(operation)) {
                return dashboardStructure.load(wcdfdeFile);
            }
            if (OPERATION_DELETE.equalsIgnoreCase(operation)) {
                dashboardStructure.delete(params);
            } else if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
                result = dashboardStructure.save(file, cdfStructure);
            } else if (OPERATION_SAVE_AS.equalsIgnoreCase(operation)) {
                if (StringUtils.isEmpty((String)title)) {
                    title = FilenameUtils.getBaseName((String)file);
                }
                result = dashboardStructure.saveAs(file, title, description, cdfStructure, isPreview);
            } else if (OPERATION_NEW_FILE.equalsIgnoreCase(operation)) {
                dashboardStructure.newfile(params);
            } else if (OPERATION_SAVE_SETTINGS.equalsIgnoreCase(operation)) {
                dashboardStructure.savesettings(params);
            } else {
                logger.error((Object)("Unknown operation: " + operation));
            }
            return JsonUtils.getJsonResult((boolean)true, result);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof DashboardStructureException) {
                    JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)false, (Object)e.getCause().getMessage());
                } else if (e instanceof InvocationTargetException) {
                    throw (Exception)e.getCause();
                }
            }
            throw e;
        }
    }

    @POST
    @Path(value="/syncronizeTemplates")
    @Produces(value={"application/json"})
    public void syncTemplates(@FormParam(value="operation") String operation, @FormParam(value="file") String file, @FormParam(value="cdfstructure") String cdfStructure, @Context HttpServletResponse response) throws IOException, DashboardStructureException {
        CdfTemplates cdfTemplates = new CdfTemplates(GET_RESOURCE);
        Object result = null;
        if (OPERATION_LOAD.equalsIgnoreCase(operation)) {
            result = cdfTemplates.load();
        } else if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
            cdfTemplates.save(file, cdfStructure);
        }
        JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)true, (Object)result);
    }

    @GET
    @Path(value="/syncronizeStyles")
    @Produces(value={"application/json"})
    public void syncStyles(@Context HttpServletResponse response) throws IOException, DashboardDesignerException {
        CdfStyles cdfStyles = new CdfStyles();
        JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)true, (Object)cdfStyles.liststyles());
    }

    @POST
    @Path(value="/saveDashboard")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String saveDashboard(@FormDataParam(value="file") @DefaultValue(value="") String file, @FormDataParam(value="title") @DefaultValue(value="") String title, @FormDataParam(value="description") @DefaultValue(value="") String description, @FormDataParam(value="cdfstructure") String cdfStructure, @FormDataParam(value="operation") String operation, @Context HttpServletResponse response) throws Exception {
        boolean isPreview = false;
        if (!file.isEmpty() && !file.equals(UNSAVED_FILE_PATH)) {
            if (StringUtils.isEmpty((String)title)) {
                title = FilenameUtils.getBaseName((String)file);
            }
            String fileDir = file.contains(".wcdf") || file.contains(".cdfde") ? file.substring(0, file.lastIndexOf("/")) : file;
            isPreview = file.indexOf("_tmp.cdfde") > -1 || file.indexOf("_tmp.wcdf") > -1;
            IRWAccess rwAccess = null;
            rwAccess = OPERATION_SAVE_AS.equalsIgnoreCase(operation) && !isPreview ? Utils.getSystemOrUserRWAccess((String)fileDir) : Utils.getSystemOrUserRWAccess((String)file);
            if (rwAccess == null) {
                String msg = "Access denied for the syncronize method saveDashboard." + operation + " : " + file;
                logger.warn((Object)msg);
                return JsonUtils.getJsonResult((boolean)false, (Object)msg);
            }
        }
        try {
            DashboardStructure dashboardStructure = new DashboardStructure();
            HashMap result = null;
            if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
                result = dashboardStructure.save(file, cdfStructure);
            } else if (OPERATION_SAVE_AS.equalsIgnoreCase(operation)) {
                result = dashboardStructure.saveAs(file, title, description, cdfStructure, isPreview);
            } else {
                logger.error((Object)("Unknown operation: " + operation));
            }
            return JsonUtils.getJsonResult((boolean)true, (Object)result);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof DashboardStructureException) {
                    JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)false, (Object)e.getCause().getMessage());
                } else if (e instanceof InvocationTargetException) {
                    throw (Exception)e.getCause();
                }
            }
            throw e;
        }
    }

    private class MethodParams {
        private static final String FILE = "file";
        private static final String PATH = "path";
        private static final String TITLE = "title";
        private static final String AUTHOR = "author";
        private static final String DESCRIPTION = "description";
        private static final String STYLE = "style";
        private static final String OPERATION = "operation";
        private static final String RENDERER_TYPE = "rendererType";
        private static final String WIDGET = "widget";
        private static final String WIDGET_NAME = "widgetName";
        private static final String WIDGET_PARAMETERS = "widgetParameters";
        private static final String DASHBOARD_STRUCTURE = "cdfstructure";

        private MethodParams() {
        }
    }
}

