/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.cdf;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cdf.dd.DashboardDesignerException;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class CdfStyles {
    public static final String DEFAULTSTYLE = "Clean";
    private static final String SYSTEM_RESOURCE_STYLES_DIR = "resources/styles/";
    private static final String RESOURCE_STYLES_DIR_SOLUTION = "styles/";
    private static Log logger = LogFactory.getLog(CdfStyles.class);

    public Object liststyles() throws DashboardDesignerException {
        JSONArray result = new JSONArray();
        ArrayList<Style> styles = new ArrayList<Style>();
        Style style = null;
        style = new Style(CdeEnvironment.getPluginSystemReader(), SYSTEM_RESOURCE_STYLES_DIR, null);
        styles.add(style);
        style = new Style(CdeEnvironment.getPluginRepositoryReader(), RESOURCE_STYLES_DIR_SOLUTION, null);
        styles.add(style);
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer(CdeEnvironment.getContentAccessFactory(), (IPluginManager)PentahoSystem.get(IPluginManager.class));
        pluginsAnalyzer.refresh();
        List entities = pluginsAnalyzer.getRegisteredEntities("/cde-styles");
        for (PluginsAnalyzer.PluginWithEntity entity : entities) {
            String pluginStylesDir = entity.getRegisteredEntity().valueOf("path");
            String finalPath = pluginStylesDir + "/";
            String pluginId = entity.getPlugin().getId();
            style = null;
            IReadAccess access = CdeEnvironment.getOtherPluginSystemReader((String)pluginId);
            if (finalPath.startsWith("system/" + pluginId + "/")) {
                finalPath = finalPath.substring(("system/" + pluginId + "/").length());
            }
            if (!access.fileExists(finalPath) || !access.fetchFile(finalPath).isDirectory()) continue;
            style = new Style(access, finalPath, pluginId);
            styles.add(style);
        }
        if (styles == null || styles.size() < 1) {
            logger.error((Object)"No styles directory found in resources");
            styles = new ArrayList();
        }
        for (Style s : styles) {
            List<IBasicFile> styleFiles = s.getStyleFiles();
            for (IBasicFile file : styleFiles) {
                String name = file.getName();
                result.add((Object)(name.substring(0, name.lastIndexOf(46)) + s.getSufixPluginName()));
            }
        }
        return result;
    }

    public String getResourceLocation(String style) {
        String[] split;
        String stylePath = null;
        if (StringUtils.isEmpty((String)style)) {
            style = DEFAULTSTYLE;
        }
        if ((split = style.split(" - ")).length > 1) {
            String pluginId = split[1].replace("(", "").replace(")", "");
            String styleFilename = split[0] + ".html";
            PluginsAnalyzer pluginsAnalizer = new PluginsAnalyzer();
            pluginsAnalizer.refresh();
            List plugins = pluginsAnalizer.getInstalledPlugins();
            for (Plugin plugin : plugins) {
                if (!plugin.getId().equalsIgnoreCase(pluginId)) continue;
                stylePath = "/" + plugin.getRegisteredEntities("/cde-styles").valueOf("path") + "/" + styleFilename;
                break;
            }
        } else {
            String styleFilename = style + ".html";
            String customStylePath = RESOURCE_STYLES_DIR_SOLUTION + styleFilename;
            if (CdeEnvironment.getPluginRepositoryReader().fileExists(customStylePath)) {
                stylePath = customStylePath;
            } else if (CdeEnvironment.getPluginSystemReader((String)SYSTEM_RESOURCE_STYLES_DIR).fileExists(styleFilename)) {
                stylePath = SYSTEM_RESOURCE_STYLES_DIR + styleFilename;
            }
        }
        return stylePath;
    }

    private class Style {
        String pluginId = null;
        IReadAccess access;
        String directory;
        List<IBasicFile> styleFiles = null;

        public Style(IReadAccess access, String directory, String pluginName) {
            this.access = access;
            this.pluginId = pluginName;
            this.directory = directory;
            this.styleSelfBuild();
        }

        private void styleSelfBuild() {
            this.styleFiles = new ArrayList<IBasicFile>();
            GenericBasicFileFilter htmlFilter = new GenericBasicFileFilter(null, ".html");
            List htmlList = this.access.listFiles(this.directory, (IBasicFileFilter)htmlFilter, -1, false, true);
            if (htmlList != null) {
                if (this.styleFiles == null) {
                    this.styleFiles = htmlList;
                } else {
                    this.styleFiles.addAll(htmlList);
                }
            }
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String getSufixPluginName() {
            String sufix = this.getPluginId();
            sufix = sufix == null ? "" : " - (" + this.getPluginId() + ")";
            return sufix;
        }

        public List<IBasicFile> getStyleFiles() {
            return this.styleFiles;
        }
    }
}

