/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.cdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.Messages;
import pt.webdetails.cdf.dd.structure.DashboardStructureException;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CdfTemplates {
    private static String SYSTEM_CDF_DD_TEMPLATES = "/resources/templates";
    private String resoureUrl;
    private static String REPOSITORY_CDF_DD_TEMPLATES_CUSTOM = "templates";
    private static Log logger = LogFactory.getLog(CdfTemplates.class);

    public CdfTemplates(String getResourceEndpoint) {
        this.resoureUrl = CdeEngine.getInstance().getEnvironment().getApplicationBaseContentUrl() + getResourceEndpoint + SYSTEM_CDF_DD_TEMPLATES + "/";
    }

    public void save(String file, String structure) throws DashboardStructureException, IOException {
        logger.info((Object)("Saving File:" + file));
        IRWAccess access = CdeEnvironment.getPluginRepositoryWriter();
        if (!access.fileExists(REPOSITORY_CDF_DD_TEMPLATES_CUSTOM)) {
            access.createFolder(REPOSITORY_CDF_DD_TEMPLATES_CUSTOM);
        }
        byte[] fileData = structure.getBytes(CharsetHelper.getEncoding());
        if (!access.saveFile(Utils.joinPath((String[])new String[]{REPOSITORY_CDF_DD_TEMPLATES_CUSTOM, file}), (InputStream)new ByteArrayInputStream(fileData))) {
            throw new DashboardStructureException(Messages.getString((String)"DashboardStructure.ERROR_006_SAVE_FILE_ADD_FAIL_EXCEPTION"));
        }
    }

    public Object load() {
        Object result = new JSONArray();
        try {
            GenericBasicFileFilter jsonFilter = new GenericBasicFileFilter(null, ".cdfde");
            List defaultTemplatesList = CdeEnvironment.getPluginSystemReader((String)SYSTEM_CDF_DD_TEMPLATES).listFiles(null, (IBasicFileFilter)jsonFilter, -1);
            if (defaultTemplatesList != null) {
                this.loadFiles(defaultTemplatesList.toArray(new IBasicFile[0]), (JSONArray)result, "default");
            } else {
                result = Messages.getString((String)"CdfTemplates.ERROR_002_LOADING_TEMPLATES_EXCEPTION");
            }
            List customTemplatesList = CdeEnvironment.getPluginRepositoryReader((String)REPOSITORY_CDF_DD_TEMPLATES_CUSTOM).listFiles(null, (IBasicFileFilter)jsonFilter, -1);
            if (customTemplatesList != null) {
                this.loadFiles(customTemplatesList.toArray(new IBasicFile[0]), (JSONArray)result, "custom");
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            result = Messages.getString((String)"CdfTemplates.ERROR_002_LOADING_EXCEPTION");
        }
        return result;
    }

    private void loadFiles(IBasicFile[] jsonFiles, JSONArray result, String type) throws IOException {
        Arrays.sort(jsonFiles, new Comparator<IBasicFile>(){

            @Override
            public int compare(IBasicFile file1, IBasicFile file2) {
                if (file1 == null && file2 == null) {
                    return 0;
                }
                return file1.getFullPath().toLowerCase().compareTo(file2.getFullPath().toLowerCase());
            }
        });
        IReadAccess access = CdeEnvironment.getPluginSystemReader((String)SYSTEM_CDF_DD_TEMPLATES);
        for (int i = 0; i < jsonFiles.length; ++i) {
            JSONObject template = new JSONObject();
            String imgResourcePath = this.resoureUrl + "unknown.png";
            if (access.fileExists(jsonFiles[i].getName().replace(".cdfde", ".png"))) {
                imgResourcePath = this.resoureUrl + jsonFiles[i].getName().replace(".cdfde", ".png");
            }
            template.put((Object)"img", (Object)imgResourcePath);
            template.put((Object)"type", (Object)type);
            template.put((Object)"structure", (Object)JsonUtils.readJsonFromInputStream((InputStream)jsonFiles[i].getContents()));
            result.add((Object)template);
        }
    }
}

