/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.extapi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.security.SecurityHelper;
import pt.webdetails.cdf.dd.PentahoCdeEnvironment;
import pt.webdetails.cdf.dd.extapi.IFileHandler;
import pt.webdetails.cdf.dd.structure.DashboardStructure;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.api.IFileContent;
import pt.webdetails.cpf.impl.FileContent;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class FileHandler
implements IFileHandler {
    protected static Log logger = LogFactory.getLog(FileHandler.class);

    public boolean saveDashboardAs(String path, String title, String description, String cdfdeJsText, boolean isPreview) throws Exception {
        InputStream wcdfFile = CdeEnvironment.getPluginSystemReader().getFileInputStream(DashboardStructure.SYSTEM_PLUGIN_EMPTY_WCDF_FILE_PATH);
        String wcdfContentAsString = IOUtils.toString((InputStream)wcdfFile, (String)CharsetHelper.getEncoding());
        if ("@DASBOARD_TITLE@".equals(title)) {
            title = FilenameUtils.getBaseName((String)path);
        }
        if ("@DASBOARD_DESCRIPTION@".equals(description)) {
            description = FilenameUtils.getBaseName((String)path);
        }
        wcdfContentAsString = wcdfContentAsString.replaceFirst("@DASBOARD_TITLE@", title);
        wcdfContentAsString = wcdfContentAsString.replaceFirst("@DASBOARD_DESCRIPTION@", description);
        ByteArrayInputStream bais = new ByteArrayInputStream(wcdfContentAsString.getBytes(CharsetHelper.getEncoding()));
        if (isPreview) {
            return Utils.getSystemOrUserRWAccess((String)path).saveFile(path, (InputStream)bais);
        }
        FileContent file = new FileContent();
        file.setPath(path);
        file.setContents((InputStream)bais);
        file.setTitle(title);
        file.setDescription(description);
        return PentahoCdeEnvironment.getInstance().getContentAccessFactory().getUserContentAccess(null).saveFile((IFileContent)file);
    }

    public boolean createBasicFileIfNotExists(final IRWAccess access, final String file, final InputStream content) {
        if (access == null || StringUtils.isEmpty((String)file) || content == null) {
            return false;
        }
        if (!access.fileExists(file)) {
            try {
                SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return access.saveFile(file, content);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't find or create CDE " + file + "  file"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean createBasicDirIfNotExists(final IRWAccess access, final String relativeFolderPath) {
        if (access == null || StringUtils.isEmpty((String)relativeFolderPath)) {
            return false;
        }
        if (!access.fileExists(relativeFolderPath)) {
            try {
                SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return access.createFolder(relativeFolderPath);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't find or create CDE " + relativeFolderPath + "  dir"), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

