/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchronousMailListener {
    private static Log log = LogFactory.getLog((Class)SynchronousMailListener.class);
    private boolean complete = false;
    private MessageContext outMessageContext;
    private MessageContext inMessageContext;
    private long timeoutInMilliseconds = -1L;

    public SynchronousMailListener(MessageContext outMessageContext, long timeoutInMilliseconds) {
        this.outMessageContext = outMessageContext;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void setInMessageContext(MessageContext inMessageContext) throws AxisFault {
        OperationContext operationContext = this.outMessageContext.getOperationContext();
        MessageContext msgCtx = operationContext.getMessageContext("In");
        if (msgCtx == null) {
            if (this.outMessageContext.getProperty("piggybackMessage") != null) {
                msgCtx = (MessageContext)this.outMessageContext.getProperty("piggybackMessage");
                msgCtx.setTransportIn(inMessageContext.getTransportIn());
                msgCtx.setTransportOut(inMessageContext.getTransportOut());
                msgCtx.setServerSide(false);
                msgCtx.setProperty("mail.contenttype", inMessageContext.getProperty("mail.contenttype"));
                msgCtx.setIncomingTransportName("mailto");
                msgCtx.setEnvelope(inMessageContext.getEnvelope());
            } else {
                inMessageContext.setOperationContext(operationContext);
                inMessageContext.setServiceContext(this.outMessageContext.getServiceContext());
                if (!operationContext.isComplete()) {
                    operationContext.addMessageContext(inMessageContext);
                }
                AxisOperation axisOp = operationContext.getAxisOperation();
                AxisMessage inMessage = axisOp.getMessage("In");
                inMessageContext.setAxisMessage(inMessage);
                inMessageContext.setServerSide(false);
            }
        } else {
            msgCtx.setOperationContext(operationContext);
            msgCtx.setServiceContext(this.outMessageContext.getServiceContext());
            AxisOperation axisOp = operationContext.getAxisOperation();
            AxisMessage inMessage = axisOp.getMessage("In");
            msgCtx.setAxisMessage(inMessage);
            msgCtx.setTransportIn(inMessageContext.getTransportIn());
            msgCtx.setTransportOut(inMessageContext.getTransportOut());
            msgCtx.setServerSide(false);
            msgCtx.setProperty("mail.contenttype", inMessageContext.getProperty("mail.contenttype"));
            msgCtx.setIncomingTransportName("mailto");
            msgCtx.setEnvelope(inMessageContext.getEnvelope());
        }
        this.inMessageContext = inMessageContext;
        log.info((Object)" SynchronousMailListener found the required message.");
        this.complete = true;
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeoutInMilliseconds(long timeoutInMilliseconds) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public MessageContext getInMessageContext() {
        return this.inMessageContext;
    }
}

