/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.impl.rest.httpclient;

import com.cloudera.com.jamesmurty.utils.XMLBuilder;
import com.cloudera.org.apache.http.Header;
import com.cloudera.org.apache.http.HttpEntity;
import com.cloudera.org.apache.http.HttpMessage;
import com.cloudera.org.apache.http.HttpResponse;
import com.cloudera.org.apache.http.client.CredentialsProvider;
import com.cloudera.org.apache.http.client.HttpClient;
import com.cloudera.org.apache.http.client.methods.HttpDelete;
import com.cloudera.org.apache.http.client.methods.HttpGet;
import com.cloudera.org.apache.http.client.methods.HttpHead;
import com.cloudera.org.apache.http.client.methods.HttpPost;
import com.cloudera.org.apache.http.client.methods.HttpPut;
import com.cloudera.org.apache.http.client.methods.HttpRequestBase;
import com.cloudera.org.apache.http.client.methods.HttpUriRequest;
import com.cloudera.org.apache.http.conn.ClientConnectionManager;
import com.cloudera.org.apache.http.entity.BasicHttpEntity;
import com.cloudera.org.apache.http.entity.BufferedHttpEntity;
import com.cloudera.org.apache.http.entity.StringEntity;
import com.cloudera.org.apache.http.impl.client.RequestWrapper;
import com.cloudera.org.apache.http.protocol.HttpContext;
import com.cloudera.org.apache.http.util.EntityUtils;
import com.cloudera.org.jets3t.service.Constants;
import com.cloudera.org.jets3t.service.Jets3tProperties;
import com.cloudera.org.jets3t.service.ServiceException;
import com.cloudera.org.jets3t.service.StorageObjectsChunk;
import com.cloudera.org.jets3t.service.StorageService;
import com.cloudera.org.jets3t.service.acl.AccessControlList;
import com.cloudera.org.jets3t.service.impl.rest.HttpException;
import com.cloudera.org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import com.cloudera.org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import com.cloudera.org.jets3t.service.impl.rest.httpclient.HttpResponseAndByteCount;
import com.cloudera.org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import com.cloudera.org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import com.cloudera.org.jets3t.service.model.CreateBucketConfiguration;
import com.cloudera.org.jets3t.service.model.S3Object;
import com.cloudera.org.jets3t.service.model.StorageBucket;
import com.cloudera.org.jets3t.service.model.StorageBucketLoggingStatus;
import com.cloudera.org.jets3t.service.model.StorageObject;
import com.cloudera.org.jets3t.service.model.StorageOwner;
import com.cloudera.org.jets3t.service.mx.MxDelegate;
import com.cloudera.org.jets3t.service.security.ProviderCredentials;
import com.cloudera.org.jets3t.service.utils.RestUtils;
import com.cloudera.org.jets3t.service.utils.ServiceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestStorageService
extends StorageService
implements JetS3tRequestAuthorizer {
    private static final Log log = LogFactory.getLog(RestStorageService.class);
    protected HttpClient httpClient;
    protected CredentialsProvider credentialsProvider;
    protected String defaultStorageClass;
    protected String defaultServerSideEncryptionAlgorithm;
    protected volatile boolean shuttingDown;

    public RestStorageService(ProviderCredentials credentials) {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public RestStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) {
        super(credentials, invokingApplicationDescription, jets3tProperties);
        this.credentialsProvider = credentialsProvider;
        this.defaultStorageClass = this.jets3tProperties.getStringProperty("s3service.default-storage-class", null);
        this.defaultServerSideEncryptionAlgorithm = this.jets3tProperties.getStringProperty("s3service.server-side-encryption", null);
        this.initializeDefaults();
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.httpClient = this.initHttpConnection();
        this.initializeProxy();
    }

    protected void initializeProxy() {
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, this.getEndpoint());
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, this.jets3tProperties, false, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain, this.getEndpoint());
        }
    }

    protected abstract boolean isTargettingGoogleStorageService();

    @Override
    protected void shutdownImpl() throws ServiceException {
        this.shuttingDown = true;
        ClientConnectionManager manager = this.getHttpConnectionManager();
        manager.shutdown();
    }

    protected HttpClient initHttpConnection() {
        return RestUtils.initHttpConnection(this, this.jets3tProperties, this.getInvokingApplicationDescription(), this.credentialsProvider);
    }

    public ClientConnectionManager getHttpConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected boolean isXmlContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("application/xml".toLowerCase());
    }

    protected HttpResponse performRequest(HttpUriRequest httpMethod, int[] expectedResponseCodes) throws ServiceException {
        return this.performRequest(httpMethod, expectedResponseCodes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpResponse performRequest(HttpUriRequest httpMethod, int[] expectedResponseCodes, HttpContext context) throws ServiceException {
        HttpMessage response = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing " + httpMethod.getMethod() + " request for '" + httpMethod.getURI().toString() + "', expecting response codes: " + "[" + ServiceUtils.join(expectedResponseCodes, ",") + "]"));
                log.debug((Object)("Headers: " + Arrays.asList(httpMethod.getAllHeaders())));
            }
            boolean completedWithoutRecoverableError = true;
            int internalErrorCount = 0;
            int requestTimeoutErrorCount = 0;
            int redirectCount = 0;
            int authFailureCount = 0;
            boolean wasRecentlyRedirected = false;
            int responseCode = -1;
            do {
                block53: {
                    block51: {
                        ServiceException exception;
                        block55: {
                            block54: {
                                block52: {
                                    StringBuilder sb;
                                    block50: {
                                        Object var18_24;
                                        if (!wasRecentlyRedirected) {
                                            this.authorizeHttpRequest(httpMethod, context);
                                        } else {
                                            wasRecentlyRedirected = false;
                                        }
                                        response = this.httpClient.execute(httpMethod, context);
                                        responseCode = response.getStatusLine().getStatusCode();
                                        if (responseCode == 307) {
                                            this.authorizeHttpRequest(httpMethod, context);
                                            Header locationHeader = response.getFirstHeader("location");
                                            if (httpMethod instanceof HttpRequestBase) {
                                                ((HttpRequestBase)httpMethod).setURI(new URI(locationHeader.getValue()));
                                            } else if (httpMethod instanceof RequestWrapper) {
                                                ((RequestWrapper)httpMethod).setURI(new URI(locationHeader.getValue()));
                                            }
                                            completedWithoutRecoverableError = false;
                                            wasRecentlyRedirected = true;
                                            if (++redirectCount > 5) {
                                                throw new ServiceException("Exceeded 307 redirect limit (5).");
                                            }
                                        } else if (responseCode == 500 || responseCode == 503) {
                                            completedWithoutRecoverableError = false;
                                            this.sleepOnInternalError(++internalErrorCount);
                                        } else {
                                            completedWithoutRecoverableError = true;
                                        }
                                        String contentType = "";
                                        if (response.getFirstHeader("Content-Type") != null) {
                                            contentType = response.getFirstHeader("Content-Type").getValue();
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Response for '" + httpMethod.getMethod() + "'. Content-Type: " + contentType + ", Headers: " + Arrays.asList(response.getAllHeaders())));
                                            log.debug((Object)("Response entity: " + response.getEntity()));
                                            if (response.getEntity() != null) {
                                                log.debug((Object)("Entity length: " + response.getEntity().getContentLength()));
                                            }
                                        }
                                        boolean didReceiveExpectedResponseCode = false;
                                        for (int i = 0; i < expectedResponseCodes.length && !didReceiveExpectedResponseCode; ++i) {
                                            if (responseCode != expectedResponseCodes[i]) continue;
                                            didReceiveExpectedResponseCode = true;
                                        }
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Received expected response code: " + didReceiveExpectedResponseCode));
                                            log.debug((Object)("  expected code(s): " + Arrays.toString(expectedResponseCodes) + "."));
                                        }
                                        if (didReceiveExpectedResponseCode) continue;
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Response xml: " + this.isXmlContentType(contentType)));
                                            log.debug((Object)("Response entity: " + response.getEntity()));
                                            log.debug((Object)("Response entity length: " + (response.getEntity() == null ? "??" : "" + response.getEntity().getContentLength())));
                                        }
                                        if (!this.isXmlContentType(contentType) || response.getEntity() == null || response.getEntity().getContentLength() == 0L) break block51;
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Response '" + httpMethod.getURI().getRawPath() + "' - Received error response with XML message"));
                                        }
                                        sb = new StringBuilder();
                                        BufferedReader reader = null;
                                        try {
                                            reader = new BufferedReader(new InputStreamReader(new HttpMethodReleaseInputStream((HttpResponse)response)));
                                            String line = null;
                                            while ((line = reader.readLine()) != null) {
                                                sb.append(line).append("\n");
                                            }
                                            var18_24 = null;
                                            if (reader == null) break block50;
                                        }
                                        catch (Throwable throwable) {
                                            var18_24 = null;
                                            if (reader == null) throw throwable;
                                            reader.close();
                                            throw throwable;
                                        }
                                        reader.close();
                                    }
                                    EntityUtils.consume(response.getEntity());
                                    exception = new ServiceException("S3 Error Message.", sb.toString());
                                    exception.setResponseCode(responseCode);
                                    exception.setResponseHeaders(RestUtils.convertHeadersToMap(response.getAllHeaders()));
                                    if (!"RequestTimeout".equals(exception.getErrorCode())) break block52;
                                    int retryMaxCount = this.jets3tProperties.getIntProperty("httpclient.retry-max", 5);
                                    if (requestTimeoutErrorCount >= retryMaxCount) {
                                        if (!log.isErrorEnabled()) throw exception;
                                        log.error((Object)("Exceeded maximum number of retries for RequestTimeout errors: " + retryMaxCount));
                                        throw exception;
                                    }
                                    ++requestTimeoutErrorCount;
                                    if (log.isWarnEnabled()) {
                                        log.warn((Object)("Retrying connection that failed with RequestTimeout error, attempt number " + requestTimeoutErrorCount + " of " + retryMaxCount));
                                    }
                                    completedWithoutRecoverableError = false;
                                    break block53;
                                }
                                if (!"RequestTimeTooSkewed".equals(exception.getErrorCode())) break block54;
                                this.timeOffset = RestUtils.getAWSTimeAdjustment();
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and S3 server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection."));
                                }
                                completedWithoutRecoverableError = false;
                                break block53;
                            }
                            if (responseCode == 500 || responseCode == 503) break block53;
                            if (responseCode != 307) break block55;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Following Temporary Redirect to: " + httpMethod.getURI().toString()));
                            }
                            break block53;
                        }
                        if (responseCode == 404 && "PUT".equalsIgnoreCase(httpMethod.getMethod()) && "NoSuchKey".equals(exception.getErrorCode()) && httpMethod.getFirstHeader(this.getRestHeaderPrefix() + "copy-source") == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Ignoring NoSuchKey/404 error on PUT to: " + httpMethod.getURI().toString()));
                            }
                            completedWithoutRecoverableError = false;
                            break block53;
                        } else {
                            if (responseCode != 403) {
                                if (responseCode != 401) throw exception;
                            }
                            if (!this.isRecoverable403(httpMethod, exception)) throw exception;
                            completedWithoutRecoverableError = false;
                            if (++authFailureCount > 1) {
                                throw new ServiceException("Exceeded 403 retry limit (1).");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Retrying after 403 Forbidden");
                            }
                        }
                        break block53;
                    }
                    String responseText = null;
                    byte[] responseBody = null;
                    if (response.getEntity() != null) {
                        responseBody = EntityUtils.toByteArray(response.getEntity());
                    }
                    if (responseBody != null && responseBody.length > 0) {
                        responseText = new String(responseBody);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing error response without XML content");
                    }
                    EntityUtils.consume(response.getEntity());
                    if (responseCode != 500 && responseCode != 503) {
                        HttpException httpException = new HttpException(responseCode, response.getStatusLine().getReasonPhrase());
                        ServiceException exception = new ServiceException("Request Error" + (responseText != null ? " [" + responseText + "]." : "."), httpException);
                        exception.setResponseHeaders(RestUtils.convertHeadersToMap(response.getAllHeaders()));
                        throw exception;
                    }
                }
                if (!log.isWarnEnabled()) continue;
                String requestDescription = httpMethod.getMethod() + " '" + httpMethod.getURI().getPath() + (httpMethod.getURI().getQuery() != null && httpMethod.getURI().getQuery().length() > 0 ? "?" + httpMethod.getURI().getQuery() : "") + "'" + " -- ResponseCode: " + responseCode + ", ResponseStatus: " + response.getStatusLine().getReasonPhrase() + ", Request Headers: [" + ServiceUtils.join(httpMethod.getAllHeaders(), ", ") + "]" + ", Response Headers: [" + ServiceUtils.join(response.getAllHeaders(), ", ") + "]";
                requestDescription = requestDescription.replaceAll("[\\n\\r\\f]", "");
                log.warn((Object)("Error Response: " + requestDescription));
            } while (!completedWithoutRecoverableError);
            return response;
        }
        catch (Throwable t) {
            ServiceException serviceException;
            if (log.isDebugEnabled()) {
                String msg = "Rethrowing as a ServiceException error in performRequest: " + t;
                if (t.getCause() != null) {
                    msg = msg + ", with cause: " + t.getCause();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)msg, t);
                } else {
                    log.debug((Object)msg);
                }
            }
            if (log.isDebugEnabled() && !this.shuttingDown) {
                log.debug((Object)("Releasing HttpClient connection after error: " + t.getMessage()));
            }
            httpMethod.abort();
            if (t instanceof ServiceException) {
                serviceException = (ServiceException)t;
            } else {
                MxDelegate.getInstance().registerS3ServiceExceptionEvent();
                serviceException = new ServiceException("Request Error: " + t, t);
            }
            if (!serviceException.isParsedFromXmlMessage() && response != null && response.getFirstHeader("x-amz-request-id") != null && response.getFirstHeader("x-amz-id-2") != null) {
                serviceException.setRequestAndHostIds(response.getFirstHeader("x-amz-request-id").getValue(), response.getFirstHeader("x-amz-id-2").getValue());
                serviceException.setResponseHeaders(RestUtils.convertHeadersToMap(response.getAllHeaders()));
            }
            if (response != null) {
                try {
                    serviceException.setResponseCode(response.getStatusLine().getStatusCode());
                    serviceException.setResponseStatus(response.getStatusLine().getReasonPhrase());
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            if (httpMethod.getFirstHeader("Host") != null) {
                serviceException.setRequestHost(httpMethod.getFirstHeader("Host").getValue());
            }
            if (response == null) throw serviceException;
            if (response.getFirstHeader("Date") == null) throw serviceException;
            serviceException.setResponseDate(response.getFirstHeader("Date").getValue());
            throw serviceException;
        }
    }

    protected boolean isRecoverable403(HttpUriRequest httpRequest, Exception exception) {
        return false;
    }

    @Override
    public void authorizeHttpRequest(HttpUriRequest httpMethod, HttpContext context) throws ServiceException {
        String queryString;
        if (this.getProviderCredentials() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding authorization for Access Key '" + this.getProviderCredentials().getAccessKey() + "'."));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service has no Credential and is un-authenticated, skipping authorization");
            }
            return;
        }
        URI uri = httpMethod.getURI();
        String hostname = uri.getHost();
        String xfullUrl = uri.getPath();
        String fullUrl = uri.getRawPath();
        String s3Endpoint = this.getEndpoint();
        if (hostname != null && !s3Endpoint.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + s3Endpoint);
            fullUrl = subdomainOffset > 0 ? "/" + hostname.substring(0, subdomainOffset) + fullUrl : "/" + hostname + fullUrl;
        }
        if ((queryString = uri.getRawQuery()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        httpMethod.setHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("For creating canonical string, using uri: " + fullUrl));
        }
        String canonicalString = null;
        try {
            canonicalString = RestUtils.makeServiceCanonicalString(httpMethod.getMethod(), fullUrl, this.convertHeadersToMap(httpMethod.getAllHeaders()), null, this.getRestHeaderPrefix(), this.getResourceParameterNames());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Canonical string ('|' is a newline): " + canonicalString.replace('\n', '|')));
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.getProviderCredentials().getSecretKey(), canonicalString);
        String authorizationString = this.getSignatureIdentifier() + " " + this.getProviderCredentials().getAccessKey() + ":" + signedCanonical;
        httpMethod.setHeader("Authorization", authorizationString);
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map<String, String> requestParameters) throws ServiceException {
        if (requestParameters != null) {
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                urlPath = urlPath + (urlPath.indexOf("?") < 0 ? "?" : "&") + RestUtils.encodeUrlString(key);
                if (value != null && value.length() > 0) {
                    urlPath = urlPath + "=" + RestUtils.encodeUrlString(value);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Added request parameter: " + key + "=" + value));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request parameter without value: " + key));
            }
        }
        return urlPath;
    }

    protected void addRequestHeadersToConnection(HttpUriRequest httpMethod, Map<String, Object> requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry<String, Object> entry : requestHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                httpMethod.setHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request header to connection: " + key + "=" + value));
            }
        }
    }

    private Map<String, Object> convertHeadersToMap(Header[] headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; headers != null && i < headers.length; ++i) {
            map.put(headers[i].getName(), headers[i].getValue());
        }
        return map;
    }

    protected void addMetadataToHeaders(HttpUriRequest httpMethod, Map<String, Object> metadata) throws ServiceException {
        HashMap<String, String> headersAlreadySeenMap = new HashMap<String, String>(metadata.size());
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object objValue = entry.getValue();
            if (key == null) continue;
            String value = objValue.toString();
            boolean validAscii = false;
            UnsupportedEncodingException encodingException = null;
            try {
                byte[] asciiBytes = key.getBytes("ASCII");
                byte[] utf8Bytes = key.getBytes("UTF-8");
                validAscii = Arrays.equals(asciiBytes, utf8Bytes);
            }
            catch (UnsupportedEncodingException e) {
                encodingException = e;
            }
            if (!validAscii) {
                String message = "User metadata name is incompatible with the S3 REST interface, only ASCII characters are allowed in HTTP headers: " + key;
                if (encodingException == null) {
                    throw new ServiceException(message);
                }
                throw new ServiceException(message, encodingException);
            }
            if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0) {
                throw new ServiceException("The value of metadata item " + key + " cannot be represented as an HTTP header for the REST S3 interface: " + value);
            }
            String duplicateValue = (String)headersAlreadySeenMap.get(key.toLowerCase(Locale.US));
            if (duplicateValue != null && !duplicateValue.equals(value)) {
                throw new ServiceException("HTTP header name occurs multiple times in request with different values, probably due to mismatched capitalization when setting metadata names. Duplicate metadata name: '" + key + "', All metadata: " + metadata);
            }
            if (!httpMethod.getMethod().equalsIgnoreCase("PUT") || !"Content-Length".equalsIgnoreCase(key)) {
                httpMethod.setHeader(key, value);
            }
            headersAlreadySeenMap.put(key.toLowerCase(Locale.US), value);
        }
    }

    protected void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
        if (expectedETag.length() != 32) {
            log.warn((Object)("The ETag header value '" + expectedETag + "' returned for " + uploadedObject + " is not a valid hex-encoded MD5 hash value;" + " cannot verify the correctness of the uploaded data"));
            return;
        }
        if (!expectedETag.equals(uploadedObject.getETag())) {
            throw new ServiceException("Mismatch between MD5 hash of uploaded data (" + expectedETag + ") and ETag returned by S3 (" + uploadedObject.getETag() + ") for object key: " + uploadedObject.getKey());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned by S3: " + uploadedObject.getKey()));
        }
    }

    protected HttpResponse performRestHead(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders) throws ServiceException {
        HttpUriRequest httpMethod = this.setupConnection(HTTP_METHOD.HEAD, bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        return this.performRequest(httpMethod, new int[]{200});
    }

    protected HttpResponse performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, Object> requestHeaders) throws ServiceException {
        HttpUriRequest httpMethod = this.setupConnection(HTTP_METHOD.GET, bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        int[] expectedStatusCodes = new int[]{200};
        if (requestHeaders != null && requestHeaders.containsKey("Range")) {
            expectedStatusCodes = new int[]{206, 200};
        }
        return this.performRequest(httpMethod, expectedStatusCodes);
    }

    protected HttpResponseAndByteCount performRestPut(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, HttpEntity requestEntity, boolean autoRelease) throws ServiceException {
        HttpUriRequest httpMethod = this.setupConnection(HTTP_METHOD.PUT, bucketName, objectKey, requestParameters);
        Map<String, Object> renamedMetadata = this.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(httpMethod, renamedMetadata);
        long contentLength = 0L;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Put request with entity: " + requestEntity));
        }
        if (requestEntity != null) {
            ((HttpPut)httpMethod).setEntity(requestEntity);
            if (requestEntity.getContentType() != null && httpMethod.getFirstHeader("Content-Type") == null) {
                httpMethod.setHeader(requestEntity.getContentType());
            }
        }
        HttpResponse result = this.performRequest(httpMethod, new int[]{200, 204});
        if (requestEntity != null) {
            contentLength = ((HttpPut)httpMethod).getEntity().getContentLength();
        }
        if (autoRelease) {
            this.releaseConnection(result);
        }
        return new HttpResponseAndByteCount(result, contentLength);
    }

    protected HttpResponse performRestPost(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, HttpEntity requestEntity, boolean autoRelease) throws ServiceException {
        HttpUriRequest postMethod = this.setupConnection(HTTP_METHOD.POST, bucketName, objectKey, requestParameters);
        Map<String, Object> renamedMetadata = this.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(postMethod, renamedMetadata);
        if (requestEntity != null) {
            ((HttpPost)postMethod).setEntity(requestEntity);
        }
        HttpResponse result = this.performRequest(postMethod, new int[]{200});
        if (autoRelease) {
            this.releaseConnection(result);
        }
        return result;
    }

    protected HttpResponse performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, String multiFactorSerialNumber, String multiFactorAuthCode) throws ServiceException {
        HttpUriRequest httpMethod = this.setupConnection(HTTP_METHOD.DELETE, bucketName, objectKey, requestParameters);
        if (multiFactorSerialNumber != null || multiFactorAuthCode != null) {
            httpMethod.setHeader("x-amz-mfa", multiFactorSerialNumber + " " + multiFactorAuthCode);
        }
        HttpResponse result = this.performRequest(httpMethod, new int[]{204, 200});
        if (log.isDebugEnabled()) {
            log.debug((Object)"Releasing HttpMethod after delete");
        }
        this.releaseConnection(result);
        return result;
    }

    protected HttpResponseAndByteCount performRestPutWithXmlBuilder(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, XMLBuilder builder) throws ServiceException {
        try {
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            if (!metadata.containsKey("content-type")) {
                metadata.put("Content-Type", "text/plain");
            }
            String xml = builder.asString(null);
            return this.performRestPut(bucketName, objectKey, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException("Failed to PUT request containing an XML document", e);
        }
    }

    protected HttpResponse performRestPostWithXmlBuilder(String bucketName, String objectKey, Map<String, Object> metadata, Map<String, String> requestParameters, XMLBuilder builder) throws ServiceException {
        try {
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            if (!metadata.containsKey("content-type")) {
                metadata.put("Content-Type", "text/plain");
            }
            String xml = builder.asString(null);
            return this.performRestPost(bucketName, objectKey, metadata, requestParameters, new StringEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), false);
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException("Failed to POST request containing an XML document", e);
        }
    }

    protected HttpUriRequest setupConnection(HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws ServiceException {
        if (bucketName == null) {
            throw new ServiceException("Cannot connect to S3 Service with a null path");
        }
        boolean disableDnsBuckets = this.getDisableDnsBuckets();
        String endPoint = this.getEndpoint();
        String hostname = ServiceUtils.generateS3HostnameForBucket(bucketName, disableDnsBuckets, endPoint);
        String virtualPath = this.getVirtualPath();
        String resourceString = "/";
        if (hostname.equals(endPoint) && bucketName.length() > 0) {
            resourceString = resourceString + bucketName + "/";
        }
        resourceString = resourceString + (objectKey != null ? RestUtils.encodeUrlString(objectKey) : "");
        String url = null;
        if (this.isHttpsOnly()) {
            int securePort = this.getHttpsPort();
            url = "https://" + hostname + ":" + securePort + virtualPath + resourceString;
        } else {
            int insecurePort = this.getHttpPort();
            url = "http://" + hostname + ":" + insecurePort + virtualPath + resourceString;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("S3 URL: " + url));
        }
        url = this.addRequestParametersToUrlPath(url, requestParameters);
        HttpRequestBase httpMethod = null;
        if (HTTP_METHOD.PUT.equals((Object)method)) {
            httpMethod = new HttpPut(url);
        } else if (HTTP_METHOD.POST.equals((Object)method)) {
            httpMethod = new HttpPost(url);
        } else if (HTTP_METHOD.HEAD.equals((Object)method)) {
            httpMethod = new HttpHead(url);
        } else if (HTTP_METHOD.GET.equals((Object)method)) {
            httpMethod = new HttpGet(url);
        } else if (HTTP_METHOD.DELETE.equals((Object)method)) {
            httpMethod = new HttpDelete(url);
        } else {
            throw new IllegalArgumentException("Unrecognised HTTP method name: " + (Object)((Object)method));
        }
        if (httpMethod.getFirstHeader("Date") == null) {
            httpMethod.setHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        return httpMethod;
    }

    private void releaseConnection(HttpResponse pResponse) {
        if (pResponse == null) {
            return;
        }
        try {
            EntityUtils.consume(pResponse.getEntity());
        }
        catch (Exception e) {
            log.warn((Object)("Unable to consume response entity " + pResponse), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isBucketAccessible(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking existence of bucket: " + bucketName));
        }
        HttpResponse httpResponse = null;
        try {
            try {
                httpResponse = this.performRestHead(bucketName, null, null, null);
                EntityUtils.consume(httpResponse.getEntity());
            }
            catch (ServiceException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                }
                boolean bl = false;
                Object var6_4 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing un-wanted bucket HEAD response");
                }
                this.releaseConnection(httpResponse);
                return bl;
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                }
                Object var6_5 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing un-wanted bucket HEAD response");
                }
                this.releaseConnection(httpResponse);
                return true;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            this.releaseConnection(httpResponse);
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Releasing un-wanted bucket HEAD response");
        }
        this.releaseConnection(httpResponse);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkBucketStatus(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking availability of bucket name: " + bucketName));
        }
        HttpResponse httpResponse = null;
        try {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("max-keys", "0");
                httpResponse = this.performRestHead(bucketName, null, params, null);
                EntityUtils.consume(httpResponse.getEntity());
            }
            catch (ServiceException e) {
                if (e.getResponseCode() == 403) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Bucket named '" + bucketName + "' exists but is inaccessible, " + "probably belongs to another user"));
                    }
                    int n = 2;
                    Object var6_7 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    this.releaseConnection(httpResponse);
                    return n;
                }
                if (e.getResponseCode() != 404) throw e;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                }
                int n = 1;
                Object var6_8 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing un-wanted bucket HEAD response");
                }
                this.releaseConnection(httpResponse);
                return n;
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                }
                Object var6_9 = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing un-wanted bucket HEAD response");
                }
                this.releaseConnection(httpResponse);
                return 0;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            this.releaseConnection(httpResponse);
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Releasing un-wanted bucket HEAD response");
        }
        this.releaseConnection(httpResponse);
        return 0;
    }

    @Override
    protected StorageBucket[] listAllBucketsImpl(Map<String, Object> headers) throws ServiceException {
        String bucketName;
        HttpResponse httpResponse;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing all buckets for user: " + this.getProviderCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpResponse = this.performRestGet(bucketName = "", null, null, headers)).getFirstHeader("Content-Type").getValue())) {
            throw new ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        StorageBucket[] buckets = this.getXmlResponseSaxParser().parseListMyBucketsResponse(new HttpMethodReleaseInputStream(httpResponse)).getBuckets();
        return buckets;
    }

    @Override
    protected StorageOwner getAccountOwnerImpl() throws ServiceException {
        String bucketName;
        HttpResponse httpResponse;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up owner of S3 account via the ListAllBuckets response: " + this.getProviderCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpResponse = this.performRestGet(bucketName = "", null, null, null)).getFirstHeader("Content-Type").getValue())) {
            throw new ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        StorageOwner owner = this.getXmlResponseSaxParser().parseListMyBucketsResponse(new HttpMethodReleaseInputStream(httpResponse)).getOwner();
        return owner;
    }

    @Override
    protected StorageObject[] listObjectsImpl(String bucketName, String prefix, String delimiter, long maxListingLength) throws ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, null, null).getObjects();
    }

    @Override
    protected StorageObjectsChunk listObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey, null);
    }

    protected StorageObjectsChunk listObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String priorLastKey, String priorLastVersion) throws ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<StorageObject> objects = new ArrayList<StorageObject>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            if (priorLastKey != null) {
                parameters.put("marker", priorLastKey);
            } else {
                parameters.remove("marker");
            }
            HttpResponse httpResponse = this.performRestGet(bucketName, null, parameters, null);
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler = null;
            try {
                listBucketHandler = this.getXmlResponseSaxParser().parseListBucketResponse(new HttpMethodReleaseInputStream(httpResponse));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException e) {
                if (e.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)e);
                    continue;
                }
                throw e;
            }
            StorageObject[] partialObjects = listBucketHandler.getObjects();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialObjects.length + " objects in one batch"));
            }
            objects.addAll(Arrays.asList(partialObjects));
            String[] partialCommonPrefixes = listBucketHandler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = listBucketHandler.isListingTruncated();
            if (incompleteListing) {
                priorLastKey = listBucketHandler.getMarkerForNextListing();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Yet to receive complete listing of bucket contents, last key for prior chunk: " + priorLastKey));
                }
            } else {
                priorLastKey = null;
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + objects.size() + " objects in total"));
            }
            return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null);
        }
        return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), priorLastKey);
    }

    @Override
    protected void deleteObjectImpl(String bucketName, String objectKey, String versionId, String multiFactorSerialNumber, String multiFactorAuthCode) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        this.performRestDelete(bucketName, objectKey, requestParameters, multiFactorSerialNumber, multiFactorAuthCode);
    }

    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpResponse httpResponse = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream(httpResponse)).getAccessControlList();
    }

    @Override
    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey, String versionId) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving versioned Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HttpResponse httpResponse = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream(httpResponse)).getAccessControlList();
    }

    @Override
    protected AccessControlList getBucketAclImpl(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream(httpResponse)).getAccessControlList();
    }

    @Override
    protected void putObjectAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ServiceException {
        this.putAclImpl(bucketName, objectKey, acl, versionId);
    }

    @Override
    protected void putBucketAclImpl(String bucketName, AccessControlList acl) throws ServiceException {
        String fullKey = bucketName;
        this.putAclImpl(fullKey, null, acl, null);
    }

    protected void putAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        try {
            String aclAsXml = acl.toXml();
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, new StringEntity(aclAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to encode ACL XML document", e);
        }
    }

    @Override
    protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl, Map<String, Object> headers) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating bucket with name: " + bucketName));
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.putAll(headers);
        StringEntity requestEntity = null;
        if (location != null && !"US".equalsIgnoreCase(location)) {
            metadata.put("Content-Type", "text/xml");
            try {
                CreateBucketConfiguration config = new CreateBucketConfiguration(location);
                String configXml = config.toXml();
                metadata.put("Content-Length", String.valueOf(configXml.length()));
                requestEntity = new StringEntity(configXml, "text/xml", Constants.DEFAULT_ENCODING);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to encode CreateBucketConfiguration XML document", e);
            }
        }
        Map<String, Object> map = this.createObjectImpl(bucketName, null, null, requestEntity, metadata, null, acl, null, null);
        StorageBucket bucket = this.newBucket();
        bucket.setName(bucketName);
        bucket.setLocation(location);
        bucket.setAcl(acl);
        bucket.replaceAllMetadata(map);
        return bucket;
    }

    @Override
    protected void deleteBucketImpl(String bucketName) throws ServiceException {
        this.performRestDelete(bucketName, null, null, null, null);
    }

    protected boolean isLiveMD5HashingRequired(StorageObject object) {
        if (object.getMetadata("Content-MD5") != null) {
            return false;
        }
        boolean disableLiveMd5 = this.jets3tProperties.getBoolProperty("storage-service.disable-live-md5", false);
        return !disableLiveMd5;
    }

    protected String getBucketLocationImpl(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving location of Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("location", "");
        HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        return this.getXmlResponseSaxParser().parseBucketLocationResponse(new HttpMethodReleaseInputStream(httpResponse));
    }

    protected StorageBucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Logging Status for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HttpResponse httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        return this.getXmlResponseSaxParser().parseLoggingStatusResponse(new HttpMethodReleaseInputStream(httpResponse)).getBucketLoggingStatus();
    }

    protected void setBucketLoggingStatusImpl(String bucketName, StorageBucketLoggingStatus status) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Logging Status for bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("Content-Type", "text/plain");
        String statusAsXml = null;
        try {
            statusAsXml = status.toXml();
        }
        catch (Exception e) {
            throw new ServiceException("Unable to generate LoggingStatus XML document", e);
        }
        try {
            this.performRestPut(bucketName, null, metadata, requestParameters, new StringEntity(statusAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (ServiceException se) {
            throw new ServiceException(se);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    @Override
    protected StorageObject putObjectImpl(String bucketName, StorageObject object) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Object with key " + object.getKey() + " in bucket " + bucketName));
        }
        HttpEntity requestEntity = null;
        if (object.getDataInputStream() != null) {
            if (object.containsMetadata("Content-Length")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Uploading object data with Content-Length: " + object.getContentLength()));
                }
                requestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, this.isLiveMD5HashingRequired(object));
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Content-Length of data stream not set, will automatically determine data length in memory");
                }
                BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
                basicHttpEntity.setContent(object.getDataInputStream());
                try {
                    requestEntity = new BufferedHttpEntity(basicHttpEntity);
                }
                catch (IOException ioe) {
                    throw new ServiceException("Unable to read data stream of unknown length", ioe);
                }
            }
        }
        this.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, null);
        return object;
    }

    protected void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, HttpEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
        boolean md5Verify;
        Map<String, Object> map;
        block4: {
            map = this.createObjectImpl(bucketName, object.getKey(), object.getContentType(), requestEntity, object.getMetadataMap(), requestParams, object.getAcl(), object.getStorageClass(), object.getServerSideEncryptionAlgorithm());
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        object.replaceAllMetadata(map);
        boolean bl = md5Verify = this.isLiveMD5HashingRequired(object) && requestEntity instanceof RepeatableRequestEntity;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Will " + (md5Verify ? "" : "NOT ") + "verify expected and actual e-tag values."));
        }
        if (md5Verify) {
            String hexMD5OfUploadedData = ServiceUtils.toHex(((RepeatableRequestEntity)requestEntity).getMD5DigestOfData());
            this.verifyExpectedAndActualETagValues(hexMD5OfUploadedData, object);
        }
    }

    protected Map<String, Object> createObjectImpl(String bucketName, String objectKey, String contentType, HttpEntity requestEntity, Map<String, Object> metadata, Map<String, String> requestParams, AccessControlList acl, String storageClass, String serverSideEncryptionAlgorithm) throws ServiceException {
        boolean isExtraAclPutRequired;
        metadata = metadata == null ? new HashMap<String, Object>() : new HashMap<String, Object>(metadata);
        if (contentType != null) {
            metadata.put("Content-Type", contentType);
        } else {
            metadata.put("Content-Type", "application/octet-stream");
        }
        this.prepareStorageClass(metadata, storageClass, true, objectKey);
        this.prepareServerSideEncryption(metadata, serverSideEncryptionAlgorithm, objectKey);
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(metadata, acl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating object bucketName=" + bucketName + ", objectKey=" + objectKey + ", storageClass=" + storageClass + "." + " Content-Type=" + metadata.get("Content-Type") + " Including data? " + (requestEntity != null) + " Metadata: " + metadata + " ACL: " + acl));
        }
        HttpResponseAndByteCount methodAndByteCount = this.performRestPut(bucketName, objectKey, metadata, requestParams, requestEntity, true);
        HttpResponse httpResponse = methodAndByteCount.getHttpResponse();
        Map<String, Object> map = new HashMap<String, Object>();
        map.putAll(metadata);
        map.putAll(this.convertHeadersToMap(httpResponse.getAllHeaders()));
        map.put("Content-Length", String.valueOf(methodAndByteCount.getByteCount()));
        map = ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix());
        if (isExtraAclPutRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(bucketName, objectKey, acl, null);
        }
        return map;
    }

    protected boolean prepareRESTHeaderAcl(Map<String, Object> metadata, AccessControlList acl) {
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata not allowed.");
        }
        if (acl != null) {
            String restHeaderAclValue = acl.getValueForRESTHeaderACL();
            if (restHeaderAclValue != null) {
                metadata.put(this.getRestHeaderPrefix() + "acl", restHeaderAclValue);
            } else {
                return false;
            }
        }
        return true;
    }

    protected void prepareStorageClass(Map<String, Object> metadata, String storageClass, boolean useDefaultStorageClass, String objectKey) {
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata not allowed.");
        }
        if (this.getEnableStorageClasses()) {
            if (storageClass == null && useDefaultStorageClass && this.defaultStorageClass != null) {
                storageClass = this.defaultStorageClass;
                log.debug((Object)("Applied default storage class '" + storageClass + "' to object '" + objectKey + "'"));
            }
            if (storageClass != null && storageClass != "") {
                metadata.put(this.getRestHeaderPrefix() + "storage-class", storageClass);
            }
        }
    }

    protected void prepareServerSideEncryption(Map<String, Object> metadata, String serverSideEncryptionAlgorithm, String objectKey) {
        if (metadata == null) {
            throw new IllegalArgumentException("Null metadata not allowed.");
        }
        if (!this.getEnableServerSideEncryption()) {
            return;
        }
        if (serverSideEncryptionAlgorithm == null && this.defaultServerSideEncryptionAlgorithm != null) {
            serverSideEncryptionAlgorithm = this.defaultServerSideEncryptionAlgorithm;
            log.debug((Object)("Applied default server-side encryption algorithm '" + serverSideEncryptionAlgorithm + "' to object '" + objectKey + "'"));
        }
        if (serverSideEncryptionAlgorithm != null) {
            metadata.put(this.getRestHeaderPrefix() + "server-side-encryption", serverSideEncryptionAlgorithm);
        }
    }

    @Override
    protected Map<String, Object> copyObjectImpl(String sourceBucketName, String sourceObjectKey, String destinationBucketName, String destinationObjectKey, AccessControlList acl, Map<String, Object> destinationMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, String versionId, String destinationObjectStorageClass, String destinationObjectServerSideEncryptionAlgorithm) throws ServiceException {
        String tags;
        boolean isExtraAclPutRequired;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying Object from " + sourceBucketName + ":" + sourceObjectKey + " to " + destinationBucketName + ":" + destinationObjectKey));
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        String sourceKey = RestUtils.encodeUrlString(sourceBucketName + "/" + sourceObjectKey);
        if (versionId != null) {
            sourceKey = sourceKey + "?versionId=" + versionId;
        }
        metadata.put(this.getRestHeaderPrefix() + "copy-source", sourceKey);
        this.prepareStorageClass(metadata, destinationObjectStorageClass, false, destinationObjectKey);
        this.prepareServerSideEncryption(metadata, destinationObjectServerSideEncryptionAlgorithm, destinationObjectKey);
        if (destinationMetadata != null) {
            metadata.put(this.getRestHeaderPrefix() + "metadata-directive", "REPLACE");
            metadata.putAll(destinationMetadata);
            if (!metadata.containsKey("Content-Type")) {
                metadata.put("Content-Type", "application/octet-stream");
            }
        } else {
            metadata.put(this.getRestHeaderPrefix() + "metadata-directive", "COPY");
        }
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(metadata, acl);
        if (ifModifiedSince != null) {
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-modified-since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-unmodified-since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            metadata.put(this.getRestHeaderPrefix() + "copy-source-if-none-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-none-match:" + tags));
            }
        }
        HttpResponseAndByteCount methodAndByteCount = this.performRestPut(destinationBucketName, destinationObjectKey, metadata, null, null, false);
        XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parseCopyObjectResponse(new HttpMethodReleaseInputStream(methodAndByteCount.getHttpResponse()));
        this.releaseConnection(methodAndByteCount.getHttpResponse());
        if (handler.isErrorResponse()) {
            throw new ServiceException("Copy failed: Code=" + handler.getErrorCode() + ", Message=" + handler.getErrorMessage() + ", RequestId=" + handler.getErrorRequestId() + ", HostId=" + handler.getErrorHostId());
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("Last-Modified", handler.getLastModified());
        map.put("ETag", handler.getETag());
        map.putAll(this.convertHeadersToMap(methodAndByteCount.getHttpResponse().getAllHeaders()));
        map = ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix());
        if (isExtraAclPutRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(destinationBucketName, destinationObjectKey, acl, null);
        }
        return map;
    }

    @Override
    protected StorageObject getObjectDetailsImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, String versionId) throws ServiceException {
        return this.getObjectImpl(true, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, null, versionId);
    }

    @Override
    protected StorageObject getObjectImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws ServiceException {
        return this.getObjectImpl(false, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId);
    }

    private StorageObject getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId) throws ServiceException {
        String tags;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving " + (headOnly ? "Head" : "All") + " information for bucket " + bucketName + " and object " + objectKey));
        }
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (ifModifiedSince != null) {
            requestHeaders.put("If-Modified-Since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            requestHeaders.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            requestHeaders.put("If-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            requestHeaders.put("If-None-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-none-match:" + tags));
            }
        }
        if (byteRangeStart != null || byteRangeEnd != null) {
            String range = "bytes=" + (byteRangeStart != null ? byteRangeStart.toString() : "") + "-" + (byteRangeEnd != null ? byteRangeEnd.toString() : "");
            requestHeaders.put("Range", range);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if it is within range:" + range));
            }
        }
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        HttpResponse httpResponse = null;
        httpResponse = headOnly ? this.performRestHead(bucketName, objectKey, requestParameters, requestHeaders) : this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.convertHeadersToMap(httpResponse.getAllHeaders()));
        StorageObject responseObject = this.newObject();
        responseObject.setKey(objectKey);
        responseObject.setBucketName(bucketName);
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream(httpResponse);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            this.releaseConnection(httpResponse);
        }
        return responseObject;
    }

    public S3Object putObjectWithSignedUrl(String signedPutUrl, S3Object object) throws ServiceException {
        HttpResponse httpResponse;
        String s3Endpoint;
        boolean isLiveMD5HashingRequired;
        RepeatableRequestEntity repeatableRequestEntity;
        HttpPut putMethod;
        block7: {
            putMethod = new HttpPut(signedPutUrl);
            Map<String, Object> renamedMetadata = this.renameMetadataKeys(object.getMetadataMap());
            this.addMetadataToHeaders(putMethod, renamedMetadata);
            if (!object.containsMetadata("Content-Length")) {
                throw new IllegalStateException("Content-Length must be specified for objects put using signed PUT URLs");
            }
            repeatableRequestEntity = null;
            isLiveMD5HashingRequired = this.isLiveMD5HashingRequired(object);
            s3Endpoint = this.getEndpoint();
            if (object.getDataInputStream() != null) {
                repeatableRequestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
                putMethod.setEntity(repeatableRequestEntity);
            }
            httpResponse = this.performRequest(putMethod, new int[]{200});
            this.releaseConnection(httpResponse);
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        try {
            S3Object uploadedObject = ServiceUtils.buildObjectFromUrl(putMethod.getURI().getHost(), putMethod.getURI().getRawPath(), s3Endpoint);
            uploadedObject.setBucketName(uploadedObject.getBucketName());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(this.convertHeadersToMap(httpResponse.getAllHeaders()));
            uploadedObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
            if (repeatableRequestEntity != null && isLiveMD5HashingRequired) {
                String hexMD5OfUploadedData = ServiceUtils.toHex(repeatableRequestEntity.getMD5DigestOfData());
                this.verifyExpectedAndActualETagValues(hexMD5OfUploadedData, uploadedObject);
            }
            return uploadedObject;
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to determine name of object created with signed PUT", e);
        }
    }

    public void deleteObjectWithSignedUrl(String signedDeleteUrl) throws ServiceException {
        HttpDelete deleteMethod = new HttpDelete(signedDeleteUrl);
        HttpResponse response = this.performRequest(deleteMethod, new int[]{204, 200});
        this.releaseConnection(response);
    }

    public S3Object getObjectWithSignedUrl(String signedGetUrl) throws ServiceException {
        return this.getObjectWithSignedUrlImpl(signedGetUrl, false);
    }

    public S3Object getObjectDetailsWithSignedUrl(String signedHeadUrl) throws ServiceException {
        return this.getObjectWithSignedUrlImpl(signedHeadUrl, true);
    }

    public AccessControlList getObjectAclWithSignedUrl(String signedAclUrl) throws ServiceException {
        HttpGet httpMethod = new HttpGet(signedAclUrl);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpResponse httpResponse = this.performRequest(httpMethod, new int[]{200});
        return this.getXmlResponseSaxParser().parseAccessControlListResponse(new HttpMethodReleaseInputStream(httpResponse)).getAccessControlList();
    }

    public void putObjectAclWithSignedUrl(String signedAclUrl, AccessControlList acl) throws ServiceException {
        HttpPut putMethod = new HttpPut(signedAclUrl);
        if (acl != null) {
            String restHeaderAclValue = acl.getValueForRESTHeaderACL();
            if (restHeaderAclValue != null) {
                putMethod.addHeader(this.getRestHeaderPrefix() + "acl", restHeaderAclValue);
            } else {
                try {
                    String aclAsXml = acl.toXml();
                    putMethod.setEntity(new StringEntity(aclAsXml, "text/xml", Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ServiceException("Unable to encode ACL XML document", e);
                }
            }
        }
        HttpResponse httpResponse = this.performRequest(putMethod, new int[]{200});
        this.releaseConnection(httpResponse);
    }

    private S3Object getObjectWithSignedUrlImpl(String signedGetOrHeadUrl, boolean headOnly) throws ServiceException {
        String s3Endpoint = this.getEndpoint();
        HttpRequestBase httpMethod = null;
        httpMethod = headOnly ? new HttpHead(signedGetOrHeadUrl) : new HttpGet(signedGetOrHeadUrl);
        HttpResponse httpResponse = this.performRequest(httpMethod, new int[]{200});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.convertHeadersToMap(httpResponse.getAllHeaders()));
        S3Object responseObject = null;
        try {
            responseObject = ServiceUtils.buildObjectFromUrl(httpMethod.getURI().getHost(), httpMethod.getURI().getRawPath().substring(1), s3Endpoint);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map, this.getRestHeaderPrefix(), this.getRestMetadataPrefix()));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream(httpResponse);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            this.releaseConnection(httpResponse);
        }
        return responseObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HTTP_METHOD {
        PUT,
        POST,
        HEAD,
        GET,
        DELETE;

    }
}

