/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.utils.signedurl;

import com.cloudera.org.apache.commons.httpclient.contrib.proxy.PluginProxyUtil;
import com.cloudera.org.apache.http.Header;
import com.cloudera.org.apache.http.HttpException;
import com.cloudera.org.apache.http.HttpHost;
import com.cloudera.org.apache.http.HttpResponse;
import com.cloudera.org.apache.http.NameValuePair;
import com.cloudera.org.apache.http.client.CredentialsProvider;
import com.cloudera.org.apache.http.client.HttpClient;
import com.cloudera.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.cloudera.org.apache.http.client.methods.HttpPost;
import com.cloudera.org.apache.http.impl.client.DefaultHttpClient;
import com.cloudera.org.apache.http.message.BasicNameValuePair;
import com.cloudera.org.apache.http.params.HttpConnectionParams;
import com.cloudera.org.apache.http.params.HttpParams;
import com.cloudera.org.apache.http.params.HttpProtocolParams;
import com.cloudera.org.apache.http.util.EntityUtils;
import com.cloudera.org.jets3t.service.model.S3Object;
import com.cloudera.org.jets3t.service.utils.RestUtils;
import com.cloudera.org.jets3t.service.utils.ServiceUtils;
import com.cloudera.org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import com.cloudera.org.jets3t.service.utils.gatekeeper.SignatureRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GatekeeperClientUtils {
    private HttpClient httpClientGatekeeper = null;
    private static final Log log = LogFactory.getLog(GatekeeperClientUtils.class);
    private Exception priorFailureException = null;
    private String gatekeeperUrl = null;
    private final String userAgentDescription;
    private final int maxRetryCount;
    private final int connectionTimeout;
    private CredentialsProvider credentialsProvider = null;

    public GatekeeperClientUtils(String gatekeeperUrl, String userAgentDescription, int maxRetryCount, int connectionTimeoutMS, CredentialsProvider credentialsProvider) {
        this.gatekeeperUrl = gatekeeperUrl;
        this.userAgentDescription = userAgentDescription;
        this.maxRetryCount = maxRetryCount;
        this.connectionTimeout = connectionTimeoutMS;
        this.credentialsProvider = credentialsProvider;
    }

    private HttpClient initHttpConnection() {
        HttpParams params = RestUtils.createDefaultHttpParams();
        HttpProtocolParams.setUserAgent(params, ServiceUtils.getUserAgentDescription(this.userAgentDescription));
        HttpConnectionParams.setConnectionTimeout(params, this.connectionTimeout);
        HttpConnectionParams.setSoTimeout(params, this.connectionTimeout);
        HttpConnectionParams.setStaleCheckingEnabled(params, false);
        DefaultHttpClient httpClient = new DefaultHttpClient(params);
        httpClient.setHttpRequestRetryHandler(new RestUtils.JetS3tRetryHandler(this.maxRetryCount, null));
        httpClient.setCredentialsProvider(this.credentialsProvider);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatekeeperMessage requestActionThroughGatekeeper(String operationType, String bucketName, S3Object[] objects, Map applicationPropertiesMap) throws HttpException, Exception {
        HttpPost postMethod;
        block29: {
            GatekeeperMessage gatekeeperMessage = new GatekeeperMessage();
            gatekeeperMessage.addApplicationProperties(applicationPropertiesMap);
            gatekeeperMessage.addApplicationProperty("clientVersionId", this.userAgentDescription);
            if (this.priorFailureException != null) {
                gatekeeperMessage.addApplicationProperty("priorFailureMessage", this.priorFailureException.getMessage());
                this.priorFailureException = null;
            }
            for (int i = 0; i < objects.length; ++i) {
                SignatureRequest signatureRequest = new SignatureRequest(operationType, objects[i].getKey());
                signatureRequest.setObjectMetadata(objects[i].getMetadataMap());
                signatureRequest.setBucketName(bucketName);
                gatekeeperMessage.addSignatureRequest(signatureRequest);
            }
            postMethod = new HttpPost(this.gatekeeperUrl);
            Properties properties = gatekeeperMessage.encodeToProperties();
            Iterator<Map.Entry<Object, Object>> propsIter = properties.entrySet().iterator();
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(properties.size());
            while (propsIter.hasNext()) {
                Map.Entry<Object, Object> entry = propsIter.next();
                String fieldName = (String)entry.getKey();
                String fieldValue = (String)entry.getValue();
                parameters.add(new BasicNameValuePair(fieldName, fieldValue));
            }
            postMethod.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)parameters));
            if (this.httpClientGatekeeper == null) {
                this.httpClientGatekeeper = this.initHttpConnection();
            }
            try {
                HttpHost proxyHost = PluginProxyUtil.detectProxy(new URL(this.gatekeeperUrl));
                if (proxyHost != null) {
                    this.httpClientGatekeeper.getParams().setParameter("http.route.default-proxy", proxyHost);
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block29;
                log.debug((Object)"No proxy detected");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Contacting Gatekeeper at: " + this.gatekeeperUrl));
        }
        HttpResponse response = null;
        try {
            response = this.httpClientGatekeeper.execute(postMethod);
            int responseCode = response.getStatusLine().getStatusCode();
            String contentType = response.getFirstHeader("Content-Type").getValue();
            if (responseCode == 200) {
                InputStream responseInputStream = null;
                Header encodingHeader = response.getFirstHeader("Content-Encoding");
                if (encodingHeader != null && "gzip".equalsIgnoreCase(encodingHeader.getValue())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Inflating gzip-encoded response");
                    }
                    responseInputStream = new GZIPInputStream(response.getEntity().getContent());
                } else {
                    responseInputStream = response.getEntity().getContent();
                }
                if (responseInputStream == null) {
                    throw new IOException("No response input stream available from Gatekeeper");
                }
                Properties responseProperties = new Properties();
                try {
                    responseProperties.load(responseInputStream);
                }
                finally {
                    responseInputStream.close();
                }
                GatekeeperMessage gatekeeperResponseMessage = GatekeeperMessage.decodeFromProperties(responseProperties);
                String gatekeeperErrorCode = gatekeeperResponseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
                if (gatekeeperErrorCode != null && log.isWarnEnabled()) {
                    log.warn((Object)("Received Gatekeeper error code: " + gatekeeperErrorCode));
                }
                GatekeeperMessage gatekeeperMessage = gatekeeperResponseMessage;
                return gatekeeperMessage;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The Gatekeeper did not permit a request. Response code: " + responseCode + ", Response content type: " + contentType));
                }
                throw new IOException("The Gatekeeper did not permit your request");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Exception("Gatekeeper did not respond", e);
            }
        }
        finally {
            try {
                EntityUtils.consume(response.getEntity());
            }
            catch (Exception ee) {}
        }
    }

    public S3Object[] buildS3ObjectsFromSignatureRequests(SignatureRequest[] srs) {
        S3Object[] objects = new S3Object[srs.length];
        for (int i = 0; i < srs.length; ++i) {
            objects[i] = new S3Object(srs[i].getObjectKey());
            objects[i].addAllMetadata(srs[i].getObjectMetadata());
        }
        return objects;
    }

    public String getGatekeeperUrl() {
        return this.gatekeeperUrl;
    }
}

