/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.pentaho.unified;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.api.IFileContent;
import pt.webdetails.cpf.impl.FileContent;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.util.RepositoryHelper;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.MimeTypes;

public abstract class UnifiedRepositoryAccess {
    private static final Log logger = LogFactory.getLog(UnifiedRepositoryAccess.class);
    protected String basePath;

    protected abstract IUnifiedRepository getRepository();

    public boolean fileExists(String path) {
        try {
            return this.getRepositoryFile(path) != null;
        }
        catch (UnifiedRepositoryException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents(String path) throws IOException {
        InputStream input = this.getFileInputStream(path);
        if (input == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((InputStream)input);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public InputStream getFileInputStream(String path) throws IOException {
        RepositoryFile file = this.getRepositoryFile(path);
        if (file == null) {
            return null;
        }
        try {
            SimpleRepositoryFileData data = (SimpleRepositoryFileData)this.getRepository().getDataForRead(file.getId(), SimpleRepositoryFileData.class);
            return data.getInputStream();
        }
        catch (UnifiedRepositoryException ure) {
            NodeRepositoryFileData data = (NodeRepositoryFileData)this.getRepository().getDataForRead(file.getId(), NodeRepositoryFileData.class);
            IPluginManager pManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
            ClassLoader classLoader = pManager.getClassLoader("pdi-platform-plugin");
            if (classLoader != null) {
                String converterClassName;
                String string = path.endsWith(".ktr") ? "com.pentaho.repository.importexport.StreamToTransNodeConverter" : (converterClassName = path.endsWith(".kjb") ? "com.pentaho.repository.importexport.StreamToJobNodeConverter" : null);
                if (converterClassName != null) {
                    try {
                        Class<?> converterClass = classLoader.loadClass(converterClassName);
                        Object converterInstance = converterClass.getConstructors()[0].newInstance(this.getRepository());
                        Method m = converterClass.getMethod("convert", Serializable.class);
                        return (InputStream)m.invoke(converterInstance, file.getId());
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Did not find expected converter class for resource: " + converterClassName + ". Returning default conversion"), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        logger.error((Object)"Error invoking constructor for converter class. Returning default conversion", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)"Error invoking constructor for converter class. Returning default conversion", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"Error invoking constructor for converter class. Returning default conversion", (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)"convert method not found in converter class. ", (Throwable)e);
                    }
                }
            }
            return new ByteArrayInputStream(data.getNode().toString().getBytes("UTF8"));
        }
    }

    public long getLastModified(String path) {
        RepositoryFile file = this.getRepositoryFile(path);
        if (file != null && file.getLastModifiedDate() != null) {
            return file.getLastModifiedDate().getTime();
        }
        return 0L;
    }

    protected RepositoryFile getRepositoryFile(String path) throws UnifiedRepositoryException {
        return this.getRepository().getFile(this.getFullPath(path));
    }

    private IRepositoryFileData createFileData(InputStream input, String mimeType) {
        return new SimpleRepositoryFileData(input, CharsetHelper.getEncoding(), mimeType);
    }

    private boolean rawPathExists(IUnifiedRepository repo, String fullRepoPath) {
        try {
            return repo.getFile(fullRepoPath) != null;
        }
        catch (UnifiedRepositoryException e) {
            return false;
        }
    }

    public boolean saveFile(String path, InputStream input) {
        FileContent file = new FileContent();
        file.setPath(path);
        file.setContents(input);
        return this.saveFile(file);
    }

    public boolean saveFile(IFileContent file) {
        IUnifiedRepository repo = this.getRepository();
        InputStream is = null;
        try {
            is = file.getContents();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        IRepositoryFileData data = this.createFileData(is, MimeTypes.getMimeType((String)file.getPath()));
        RepositoryFile savedFile = null;
        if (this.fileExists(file.getPath())) {
            RepositoryFile repositoryFile = this.getRepositoryFile(file.getPath());
            savedFile = repo.updateFile(repositoryFile, data, null);
        } else {
            RepositoryFile parentDir = this.getOrCreateFolder(repo, FilenameUtils.getPathNoEndSeparator((String)file.getPath()));
            if (parentDir == null) {
                logger.error((Object)("Unable to ensure parent folder for " + file.getPath() + ". Check permissions?"));
            }
            String name = !StringUtils.isEmpty((String)file.getName()) ? file.getName() : FilenameUtils.getName((String)file.getPath());
            RepositoryFile.Builder fileBuilder = new RepositoryFile.Builder(name);
            HashMap<String, Properties> localePropertiesMap = new HashMap<String, Properties>();
            String defaultLocale = "default";
            Properties props = new Properties();
            if (!StringUtils.isEmpty((String)file.getTitle())) {
                fileBuilder = fileBuilder.title(file.getTitle());
                props.put("file.title", file.getTitle());
            }
            if (!StringUtils.isEmpty((String)file.getDescription())) {
                fileBuilder = fileBuilder.title(file.getDescription());
                props.put("file.description", file.getDescription());
            }
            localePropertiesMap.put(defaultLocale, props);
            fileBuilder = fileBuilder.localePropertiesMap(localePropertiesMap);
            savedFile = repo.createFile(parentDir.getId(), fileBuilder.build(), data, null);
        }
        return savedFile != null && savedFile.getId() != null;
    }

    private RepositoryFile getOrCreateFolder(IUnifiedRepository repo, String path) {
        RepositoryFile baseFolder;
        int sepIdx;
        String fullPath = StringUtils.chomp((String)this.getFullPath(path), (String)"/");
        ArrayList<String> foldersToCreate = new ArrayList<String>();
        while (!this.rawPathExists(repo, fullPath) && (sepIdx = FilenameUtils.indexOfLastSeparator((String)fullPath)) >= 0) {
            foldersToCreate.add(fullPath.substring(sepIdx + 1));
            fullPath = fullPath.substring(0, sepIdx);
        }
        if (StringUtils.isEmpty((String)fullPath)) {
            fullPath = RepositoryHelper.appendPath((String)"/", (String)fullPath);
        }
        if ((baseFolder = repo.getFile(fullPath)) == null) {
            logger.error((Object)("Path " + fullPath + " doesn't exist"));
            return null;
        }
        if (foldersToCreate.size() > 0) {
            for (int i = foldersToCreate.size() - 1; i >= 0; --i) {
                String folder = (String)foldersToCreate.get(i);
                baseFolder = repo.createFolder(baseFolder.getId(), new RepositoryFile.Builder(folder).folder(true).build(), null);
            }
        }
        return baseFolder;
    }

    public boolean createFolder(String path) {
        RepositoryFile folder = this.getOrCreateFolder(this.getRepository(), path);
        return folder != null;
    }

    protected String getFullPath(String path) {
        return FilenameUtils.normalize((String)RepositoryHelper.appendPath((String)this.basePath, (String)path), (boolean)true);
    }

    protected String relativizePath(String fullPath) {
        return RepositoryHelper.relativizePath((String)this.basePath, (String)fullPath, (boolean)true);
    }

    public boolean saveFile(String path, String contents) {
        return this.saveFile(path, IOUtils.toInputStream((String)contents));
    }

    public IBasicFile fetchFile(String path) {
        RepositoryFile file = this.getRepositoryFile(path);
        return file == null ? null : this.asBasicFile(file, path);
    }

    public boolean copyFile(String pathFrom, String pathTo) {
        try {
            return this.saveFile(pathTo, this.getFileInputStream(pathFrom));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteFile(String path) {
        RepositoryFile repositoryFile = this.getRepositoryFile(path);
        if (repositoryFile == null) {
            return false;
        }
        this.getRepository().deleteFile(repositoryFile.getId(), null);
        return true;
    }

    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter) {
        return this.listFiles(this.getFullPath(path), 1, false, filter, false, new ArrayList<IBasicFile>());
    }

    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth, boolean includeDirs) {
        return this.listFiles(this.getFullPath(path), maxDepth, includeDirs, filter, false, new ArrayList<IBasicFile>());
    }

    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth, boolean includeDirs, boolean showHiddenFilesAndFolders) {
        return this.listFiles(this.getFullPath(path), maxDepth, includeDirs, filter, showHiddenFilesAndFolders, new ArrayList<IBasicFile>());
    }

    public List<IBasicFile> listFiles(String path, IBasicFileFilter filter, int maxDepth) {
        return this.listFiles(path, filter, maxDepth, false);
    }

    protected IBasicFile asBasicFile(final RepositoryFile file, String path) {
        final String relativePath = path == null ? this.relativizePath(file.getPath()) : path;
        return new IBasicFile(){

            public InputStream getContents() {
                try {
                    return UnifiedRepositoryAccess.this.getFileInputStream(relativePath);
                }
                catch (IOException e) {
                    return null;
                }
            }

            public String getName() {
                return file.getName();
            }

            public String getFullPath() {
                return FilenameUtils.separatorsToUnix((String)file.getPath());
            }

            public String getPath() {
                return relativePath;
            }

            public String getExtension() {
                return RepositoryHelper.getExtension((String)this.getName());
            }

            public boolean isDirectory() {
                return file.isFolder();
            }
        };
    }

    protected List<IBasicFile> listFiles(String path, int depth, boolean includeDirs, IBasicFileFilter filter, boolean showHiddenFiles, List<IBasicFile> listOut) {
        RepositoryFileTree tree = this.getRepository().getTree(path, depth, null, showHiddenFiles);
        if (tree != null) {
            this.populateList(listOut, tree, filter, includeDirs, showHiddenFiles);
        }
        return listOut;
    }

    protected boolean hideSystemFile(RepositoryFile file) {
        boolean isSystemFolder;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean isAdmin = policy.isAllowed("org.pentaho.security.administerSecurity");
        Map fileMeta = this.getRepository().getFileMetadata(file.getId());
        boolean bl = isSystemFolder = fileMeta.containsKey("system_folder") ? (Boolean)fileMeta.get("system_folder") : false;
        return !isAdmin && isSystemFolder;
    }

    protected void populateList(List<IBasicFile> list, RepositoryFileTree tree, IBasicFileFilter filter, boolean includeDirs, boolean showHidden) {
        RepositoryFile file = tree.getFile();
        if (!showHidden && file.isHidden()) {
            return;
        }
        if (this.hideSystemFile(file)) {
            return;
        }
        if (filter == null) {
            filter = new IBasicFileFilter(){

                public boolean accept(IBasicFile file) {
                    return true;
                }
            };
        }
        if (file.isFolder()) {
            for (RepositoryFileTree actualFileTree : tree.getChildren()) {
                RepositoryFile actualFile = actualFileTree.getFile();
                if (includeDirs || !actualFile.isFolder()) {
                    if (!showHidden && actualFile.isHidden()) continue;
                    IBasicFile bFile = this.asBasicFile(actualFile, null);
                    if (filter.accept(bFile) && !this.hideSystemFile(actualFile)) {
                        list.add(bFile);
                    }
                }
                if (actualFileTree.getChildren() == null) continue;
                this.populateList(list, actualFileTree, filter, includeDirs, showHidden);
            }
        }
    }
}

