/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.BlockReaderLocalLegacy;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DomainSocketFactory;
import org.apache.hadoop.hdfs.FileInputStreamCache;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.RemoteBlockReader;
import org.apache.hadoop.hdfs.RemoteBlockReader2;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class BlockReaderFactory {
    public static BlockReader newBlockReader(Configuration conf, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, boolean verifyChecksum, String clientName, Peer peer, DatanodeID datanodeID, DomainSocketFactory domSockFactory, PeerCache peerCache, FileInputStreamCache fisCache, boolean allowShortCircuitLocalReads) throws IOException {
        peer.setReadTimeout(conf.getInt("dfs.client.socket-timeout", HdfsServerConstants.READ_TIMEOUT));
        peer.setWriteTimeout(HdfsServerConstants.WRITE_TIMEOUT);
        if (peer.getDomainSocket() != null) {
            BlockReaderLocal reader;
            if (allowShortCircuitLocalReads && !conf.getBoolean("dfs.client.use.legacy.blockreader.local", false) && (reader = BlockReaderFactory.newShortCircuitBlockReader(conf, file, block, blockToken, startOffset, len, peer, datanodeID, domSockFactory, verifyChecksum, fisCache)) != null) {
                if (peerCache != null) {
                    peerCache.put(datanodeID, peer);
                } else {
                    IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer});
                }
                return reader;
            }
            if (!conf.getBoolean("dfs.client.domain.socket.data.traffic", false)) {
                throw new IOException("Because we can't do short-circuit access, and data traffic over domain sockets is disabled, we cannot use this socket to talk to " + datanodeID);
            }
        }
        if (conf.getBoolean("dfs.client.use.legacy.blockreader", false)) {
            return RemoteBlockReader.newBlockReader(file, block, blockToken, startOffset, len, conf.getInt("io.file.buffer.size", 4096), verifyChecksum, clientName, peer, datanodeID, peerCache);
        }
        return RemoteBlockReader2.newBlockReader(file, block, blockToken, startOffset, len, verifyChecksum, clientName, peer, datanodeID, peerCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BlockReaderLocal newShortCircuitBlockReader(Configuration conf, String file, ExtendedBlock block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, Peer peer, DatanodeID datanodeID, DomainSocketFactory domSockFactory, boolean verifyChecksum, FileInputStreamCache fisCache) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(peer.getOutputStream()));
        new Sender(out).requestShortCircuitFds(block, blockToken, 1);
        DataInputStream in = new DataInputStream(peer.getInputStream());
        DataTransferProtos.BlockOpResponseProto resp = DataTransferProtos.BlockOpResponseProto.parseFrom(HdfsProtoUtil.vintPrefixed(in));
        DomainSocket sock = peer.getDomainSocket();
        switch (resp.getStatus()) {
            case SUCCESS: {
                BlockReaderLocal reader = null;
                byte[] buf = new byte[1];
                FileInputStream[] fis = new FileInputStream[2];
                sock.recvFileInputStreams(fis, buf, 0, buf.length);
                try {
                    reader = new BlockReaderLocal(conf, file, block, startOffset, len, fis[0], fis[1], datanodeID, verifyChecksum, fisCache);
                    if (reader != null) return reader;
                }
                catch (Throwable throwable) {
                    if (reader != null) throw throwable;
                    IOUtils.cleanup((Log)DFSClient.LOG, (Closeable[])new Closeable[]{fis[0], fis[1]});
                    throw throwable;
                }
                IOUtils.cleanup((Log)DFSClient.LOG, (Closeable[])new Closeable[]{fis[0], fis[1]});
                return reader;
            }
            case ERROR_UNSUPPORTED: {
                if (!resp.hasShortCircuitAccessVersion()) {
                    DFSClient.LOG.warn((Object)("short-circuit read access is disabled for DataNode " + datanodeID + ".  reason: " + resp.getMessage()));
                    domSockFactory.disableShortCircuitForPath(sock.getPath());
                    return null;
                } else {
                    DFSClient.LOG.warn((Object)("short-circuit read access for the file " + file + " is disabled for DataNode " + datanodeID + ".  reason: " + resp.getMessage()));
                }
                return null;
            }
            case ERROR_ACCESS_TOKEN: {
                String msg = "access control error while attempting to set up short-circuit access to " + file + resp.getMessage();
                DFSClient.LOG.debug((Object)msg);
                throw new InvalidBlockTokenException(msg);
            }
        }
        DFSClient.LOG.warn((Object)("error while attempting to set up short-circuit access to " + file + ": " + resp.getMessage()));
        domSockFactory.disableShortCircuitForPath(sock.getPath());
        return null;
    }

    public static String getFileName(InetSocketAddress s, String poolId, long blockId) {
        return s.toString() + ":" + poolId + ":" + blockId;
    }

    static BlockReader getLegacyBlockReaderLocal(UserGroupInformation ugi, Configuration conf, String src, ExtendedBlock blk, Token<BlockTokenIdentifier> accessToken, DatanodeInfo chosenNode, int socketTimeout, long offsetIntoBlock, boolean connectToDnViaHostname) throws SecretManager.InvalidToken, IOException {
        try {
            return BlockReaderLocalLegacy.newBlockReader(ugi, conf, src, blk, accessToken, chosenNode, socketTimeout, offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, connectToDnViaHostname);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class, AccessControlException.class});
        }
    }
}

