/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
public class DataStorage
extends Storage {
    public static final String BLOCK_SUBDIR_PREFIX = "subdir";
    static final String BLOCK_FILE_PREFIX = "blk_";
    static final String COPY_FILE_PREFIX = "dncp_";
    static final String STORAGE_DIR_DETACHED = "detach";
    public static final String STORAGE_DIR_RBW = "rbw";
    public static final String STORAGE_DIR_FINALIZED = "finalized";
    public static final String STORAGE_DIR_TMP = "tmp";
    private String storageID;
    private boolean initilized = false;
    private Map<String, BlockPoolSliceStorage> bpStorageMap = Collections.synchronizedMap(new HashMap());

    DataStorage() {
        super(HdfsServerConstants.NodeType.DATA_NODE);
        this.storageID = "";
    }

    public StorageInfo getBPStorage(String bpid) {
        return this.bpStorageMap.get(bpid);
    }

    public DataStorage(StorageInfo storageInfo, String strgID) {
        super(HdfsServerConstants.NodeType.DATA_NODE, storageInfo);
        this.storageID = strgID;
    }

    public synchronized String getStorageID() {
        return this.storageID;
    }

    synchronized void setStorageID(String newStorageID) {
        this.storageID = newStorageID;
    }

    public synchronized void createStorageID(int datanodePort) {
        if (this.storageID != null && !this.storageID.isEmpty()) {
            return;
        }
        this.storageID = DataNode.createNewStorageId(datanodePort);
    }

    synchronized void recoverTransitionRead(DataNode datanode, NamespaceInfo nsInfo, Collection<File> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        if (this.initilized) {
            return;
        }
        assert (HdfsConstants.LAYOUT_VERSION == nsInfo.getLayoutVersion()) : "Data-node version " + HdfsConstants.LAYOUT_VERSION + " and name-node layout version " + nsInfo.getLayoutVersion() + " must be the same.";
        this.storageDirs = new ArrayList(dataDirs.size());
        ArrayList<Storage.StorageState> dataDirStates = new ArrayList<Storage.StorageState>(dataDirs.size());
        Iterator<File> it = dataDirs.iterator();
        block7: while (it.hasNext()) {
            Storage.StorageState curState;
            File dataDir = it.next();
            Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir);
            try {
                curState = sd.analyzeStorage(startOpt, this);
                switch (curState) {
                    case NORMAL: {
                        break;
                    }
                    case NON_EXISTENT: {
                        LOG.info((Object)("Storage directory " + dataDir + " does not exist"));
                        it.remove();
                        continue block7;
                    }
                    case NOT_FORMATTED: {
                        LOG.info((Object)("Storage directory " + dataDir + " is not formatted"));
                        LOG.info((Object)"Formatting ...");
                        this.format(sd, nsInfo);
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                LOG.warn((Object)("Ignoring storage directory " + dataDir + " due to an exception"), (Throwable)ioe);
                continue;
            }
            this.addStorageDir(sd);
            dataDirStates.add(curState);
        }
        if (dataDirs.size() == 0 || dataDirStates.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            this.doTransition(datanode, this.getStorageDir(idx), nsInfo, startOpt);
            assert (this.getLayoutVersion() == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
        }
        this.createStorageID(datanode.getXferPort());
        this.writeAll();
        this.initilized = true;
    }

    void recoverTransitionRead(DataNode datanode, String bpID, NamespaceInfo nsInfo, Collection<File> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        this.recoverTransitionRead(datanode, nsInfo, dataDirs, startOpt);
        ArrayList<File> bpDataDirs = new ArrayList<File>();
        for (File dnRoot : dataDirs) {
            File bpRoot = BlockPoolSliceStorage.getBpRoot(bpID, new File(dnRoot, "current"));
            bpDataDirs.add(bpRoot);
        }
        DataStorage.makeBlockPoolDataDir(bpDataDirs, null);
        BlockPoolSliceStorage bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), bpID, nsInfo.getCTime(), nsInfo.getClusterID());
        bpStorage.recoverTransitionRead(datanode, nsInfo, bpDataDirs, startOpt);
        this.addBlockPoolStorage(bpID, bpStorage);
    }

    static void makeBlockPoolDataDir(Collection<File> dataDirs, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        for (File data : dataDirs) {
            try {
                DiskChecker.checkDir((LocalFileSystem)localFS, (Path)new Path(data.toURI()), (FsPermission)permission);
            }
            catch (IOException e) {
                LOG.warn((Object)("Invalid directory in: " + data.getCanonicalPath() + ": " + e.getMessage()));
            }
        }
    }

    void format(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        sd.clearDirectory();
        this.layoutVersion = HdfsConstants.LAYOUT_VERSION;
        this.clusterID = nsInfo.getClusterID();
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        this.writeProperties(sd);
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("clusterID", this.clusterID);
        props.setProperty("cTime", String.valueOf(this.cTime));
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageID", this.getStorageID());
        if (!LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        }
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setFieldsFromProperties(props, sd, false, 0);
    }

    private void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd, boolean overrideLayoutVersion, int toLayoutVersion) throws IOException {
        String ssid;
        if (overrideLayoutVersion) {
            this.layoutVersion = toLayoutVersion;
        } else {
            this.setLayoutVersion(props, sd);
        }
        this.setcTime(props, sd);
        this.setStorageType(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
        if (!LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            this.setNamespaceID(props, sd);
        }
        if ((ssid = props.getProperty("storageID")) == null) {
            throw new InconsistentFSStateException(sd.getRoot(), "file VERSION is invalid.");
        }
        String sid = this.getStorageID();
        if (!(sid.equals("") || ssid.equals("") || sid.equals(ssid))) {
            throw new InconsistentFSStateException(sd.getRoot(), "has incompatible storage Id.");
        }
        if (sid.equals("")) {
            this.setStorageID(ssid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        File oldF = new File(sd.getRoot(), "storage");
        if (!oldF.exists()) {
            return false;
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        try {
            oldFile.seek(0L);
            int oldVersion = oldFile.readInt();
            if (oldVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        return true;
    }

    void readProperties(Storage.StorageDirectory sd, int rollbackLayoutVersion) throws IOException {
        Properties props = DataStorage.readPropertiesFile(sd.getVersionFile());
        this.setFieldsFromProperties(props, sd, true, rollbackLayoutVersion);
    }

    private void doTransition(DataNode datanode, Storage.StorageDirectory sd, NamespaceInfo nsInfo, HdfsServerConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK) {
            this.doRollback(sd, nsInfo);
        }
        this.readProperties(sd);
        DataStorage.checkVersionUpgradable(this.layoutVersion);
        assert (this.layoutVersion >= HdfsConstants.LAYOUT_VERSION) : "Future version is not allowed";
        boolean federationSupported = LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion);
        if (!federationSupported && this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.getRoot().getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (federationSupported && !this.getClusterID().equals(nsInfo.getClusterID())) {
            throw new IOException("Incompatible clusterIDs in " + sd.getRoot().getCanonicalPath() + ": namenode clusterID = " + nsInfo.getClusterID() + "; datanode clusterID = " + this.getClusterID());
        }
        if (this.layoutVersion == HdfsConstants.LAYOUT_VERSION) {
            return;
        }
        UpgradeManagerDatanode um = datanode.getUpgradeManagerDatanode(nsInfo.getBlockPoolID());
        this.verifyDistributedUpgradeProgress(um, nsInfo);
        if (this.layoutVersion > HdfsConstants.LAYOUT_VERSION) {
            this.doUpgrade(sd, nsInfo);
            return;
        }
        throw new IOException("BUG: The stored LV = " + this.getLayoutVersion() + " is newer than the supported LV = " + HdfsConstants.LAYOUT_VERSION + " or name node LV = " + nsInfo.getLayoutVersion());
    }

    void doUpgrade(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        if (LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            LOG.info((Object)("Updating layout version from " + this.layoutVersion + " to " + nsInfo.getLayoutVersion() + " for storage " + sd.getRoot()));
            this.layoutVersion = nsInfo.getLayoutVersion();
            this.writeProperties(sd);
            return;
        }
        LOG.info((Object)("Upgrading storage directory " + sd.getRoot() + ".\n   old LV = " + this.getLayoutVersion() + "; old CTime = " + this.getCTime() + ".\n   new LV = " + nsInfo.getLayoutVersion() + "; new CTime = " + nsInfo.getCTime()));
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        assert (curDir.exists()) : "Data node current directory must exist.";
        this.cleanupDetachDir(new File(curDir, STORAGE_DIR_DETACHED));
        if (prevDir.exists()) {
            DataStorage.deleteDir(prevDir);
        }
        File tmpDir = sd.getPreviousTmp();
        assert (!tmpDir.exists()) : "Data node previous.tmp directory must not exist.";
        DataStorage.rename(curDir, tmpDir);
        File curBpDir = BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), curDir);
        BlockPoolSliceStorage bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), nsInfo.getBlockPoolID(), nsInfo.getCTime(), nsInfo.getClusterID());
        bpStorage.format(curDir, nsInfo);
        this.linkAllBlocks(tmpDir, bbwDir, new File(curBpDir, "current"));
        this.layoutVersion = HdfsConstants.LAYOUT_VERSION;
        this.clusterID = nsInfo.getClusterID();
        this.writeProperties(sd);
        DataStorage.rename(tmpDir, prevDir);
        LOG.info((Object)("Upgrade of " + sd.getRoot() + " is complete"));
        this.addBlockPoolStorage(nsInfo.getBlockPoolID(), bpStorage);
    }

    private void cleanupDetachDir(File detachDir) throws IOException {
        if (!LayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, this.layoutVersion) && detachDir.exists() && detachDir.isDirectory()) {
            if (FileUtil.list((File)detachDir).length != 0) {
                throw new IOException("Detached directory " + detachDir + " is not empty. Please manually move each file under this " + "directory to the finalized directory if the finalized " + "directory tree does not have the file.");
            }
            if (!detachDir.delete()) {
                throw new IOException("Cannot remove directory " + detachDir);
            }
        }
    }

    void doRollback(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            if (LayoutVersion.supports(LayoutVersion.Feature.FEDERATION, HdfsConstants.LAYOUT_VERSION) && HdfsConstants.LAYOUT_VERSION == nsInfo.getLayoutVersion()) {
                this.readProperties(sd, nsInfo.getLayoutVersion());
                this.writeProperties(sd);
                LOG.info((Object)("Layout version rolled back to " + nsInfo.getLayoutVersion() + " for storage " + sd.getRoot()));
            }
            return;
        }
        DataStorage prevInfo = new DataStorage();
        prevInfo.readPreviousVersionProperties(sd);
        if (prevInfo.getLayoutVersion() < HdfsConstants.LAYOUT_VERSION || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(sd.getRoot(), "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
        }
        LOG.info((Object)("Rolling back storage directory " + sd.getRoot() + ".\n   target LV = " + nsInfo.getLayoutVersion() + "; target CTime = " + nsInfo.getCTime()));
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.rename(prevDir, curDir);
        DataStorage.deleteDir(tmpDir);
        LOG.info((Object)("Rollback of " + sd.getRoot() + " is complete"));
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.getRoot().getCanonicalPath();
        LOG.info((Object)("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        final File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    Storage.deleteDir(tmpDir);
                    if (bbwDir.exists()) {
                        Storage.deleteDir(bbwDir);
                    }
                }
                catch (IOException ex) {
                    Storage.LOG.error((Object)("Finalize upgrade for " + dataDirPath + " failed"), (Throwable)ex);
                }
                Storage.LOG.info((Object)("Finalize upgrade for " + dataDirPath + " is complete"));
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade(String bpID) throws IOException {
        for (Storage.StorageDirectory sd : this.storageDirs) {
            File prevDir = sd.getPreviousDir();
            if (prevDir.exists()) {
                this.doFinalize(sd);
                continue;
            }
            BlockPoolSliceStorage bpStorage = this.bpStorageMap.get(bpID);
            bpStorage.doFinalize(sd.getCurrentDir());
        }
    }

    private void linkAllBlocks(File fromDir, File fromBbwDir, File toDir) throws IOException {
        HardLink hardLink = new HardLink();
        int diskLayoutVersion = this.getLayoutVersion();
        if (LayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, diskLayoutVersion)) {
            DataStorage.linkBlocks(new File(fromDir, STORAGE_DIR_FINALIZED), new File(toDir, STORAGE_DIR_FINALIZED), diskLayoutVersion, hardLink);
            DataStorage.linkBlocks(new File(fromDir, STORAGE_DIR_RBW), new File(toDir, STORAGE_DIR_RBW), diskLayoutVersion, hardLink);
        } else {
            DataStorage.linkBlocks(fromDir, new File(toDir, STORAGE_DIR_FINALIZED), diskLayoutVersion, hardLink);
            if (fromBbwDir.exists()) {
                DataStorage.linkBlocks(fromBbwDir, new File(toDir, STORAGE_DIR_RBW), diskLayoutVersion, hardLink);
            }
        }
        LOG.info((Object)hardLink.linkStats.report());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void linkBlocks(File from, File to, int oldLV, HardLink hl) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (!from.isDirectory()) {
            block13: {
                if (from.getName().startsWith(COPY_FILE_PREFIX)) {
                    FileInputStream in = new FileInputStream(from);
                    try {
                        FileOutputStream out = new FileOutputStream(to);
                        try {
                            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)16384);
                            ++hl.linkStats.countPhysicalFileCopies;
                            break block13;
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                HardLink.createHardLink((File)from, (File)to);
                ++hl.linkStats.countSingleLinks;
            }
            return;
        }
        ++hl.linkStats.countDirs;
        if (!to.mkdirs()) {
            throw new IOException("Cannot create directory " + to);
        }
        String[] blockNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_FILE_PREFIX);
            }
        });
        if (blockNames.length > 0) {
            HardLink.createHardLinkMult((File)from, (String[])blockNames, (File)to);
            ++hl.linkStats.countMultLinks;
            hl.linkStats.countFilesMultLinks += blockNames.length;
        } else {
            ++hl.linkStats.countEmptyDirs;
        }
        String[] otherNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_SUBDIR_PREFIX) || name.startsWith(DataStorage.COPY_FILE_PREFIX);
            }
        });
        for (int i = 0; i < otherNames.length; ++i) {
            DataStorage.linkBlocks(new File(from, otherNames[i]), new File(to, otherNames[i]), oldLV, hl);
        }
    }

    private void verifyDistributedUpgradeProgress(UpgradeManagerDatanode um, NamespaceInfo nsInfo) throws IOException {
        assert (um != null) : "DataNode.upgradeManager is null.";
        um.setUpgradeState(false, this.getLayoutVersion());
        um.initializeUpgrade(nsInfo);
    }

    private void addBlockPoolStorage(String bpID, BlockPoolSliceStorage bpStorage) {
        if (!this.bpStorageMap.containsKey(bpID)) {
            this.bpStorageMap.put(bpID, bpStorage);
        }
    }

    synchronized void removeBlockPoolStorage(String bpId) {
        this.bpStorageMap.remove(bpId);
    }
}

