/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.agilebi.modeler.nodes.annotations.IMemberAnnotation;
import org.pentaho.agilebi.modeler.strategy.AutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.SimpleAutoModelStrategy;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;

public abstract class BaseModelerWorkspaceHelper
implements IModelerWorkspaceHelper {
    private static final List<AggregationType> DEFAULT_AGGREGATION_LIST = new ArrayList<AggregationType>();
    private static final List<AggregationType> DEFAULT_NON_NUMERIC_AGGREGATION_LIST = new ArrayList<AggregationType>();
    private static String locale;
    public static final String OLAP_SUFFIX = "_OLAP";
    public static final String AGILE_BI_VERSION = "3.0";
    private AutoModelStrategy autoModelStrategy;

    public BaseModelerWorkspaceHelper(String locale) {
        BaseModelerWorkspaceHelper.locale = locale;
        this.autoModelStrategy = new SimpleAutoModelStrategy(locale);
    }

    @Override
    public void populateDomain(ModelerWorkspace model) throws ModelerException {
        MainModelNode mainModelNode;
        Domain domain = model.getDomain();
        domain.setId(model.getModelName());
        LogicalModel logicalModel = model.getLogicalModel(ModelerPerspective.REPORTING);
        if (model.getModelSource() != null) {
            model.getModelSource().serializeIntoDomain(domain);
        }
        logicalModel.setId("MODEL_1");
        logicalModel.setName(new LocalizedString(locale, model.getModelName()));
        logicalModel.setProperty("AGILE_BI_VERSION", (Object)AGILE_BI_VERSION);
        this.populateCategories(model);
        if (model.supportsOlap(domain)) {
            logicalModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
            logicalModel.setId("MODEL_1_OLAP");
            logicalModel.setName(new LocalizedString(locale, model.getModelName() + OLAP_SUFFIX));
            logicalModel.setProperty("AGILE_BI_VERSION", (Object)AGILE_BI_VERSION);
        }
        if ((mainModelNode = model.getModel()) == null) {
            return;
        }
        DimensionMetaDataCollection dimensions = mainModelNode.getDimensions();
        if (dimensions.size() == 0) {
            return;
        }
        LogicalTable factTable = null;
        if (logicalModel.getLogicalTables().size() == 1) {
            factTable = (LogicalTable)logicalModel.getLogicalTables().get(0);
        } else {
            for (LogicalTable lTable : logicalModel.getLogicalTables()) {
                Object prop = lTable.getPhysicalTable().getProperty("FACT_TABLE");
                if (prop == null || !((Boolean)prop).booleanValue()) continue;
                factTable = lTable;
                break;
            }
        }
        if (factTable == null) {
            throw new IllegalStateException("Fact table is missing.");
        }
        ArrayList<OlapDimensionUsage> usages = new ArrayList<OlapDimensionUsage>();
        ArrayList<OlapDimension> olapDimensions = new ArrayList<OlapDimension>();
        ArrayList<OlapMeasure> measures = new ArrayList<OlapMeasure>();
        Iterator i$ = dimensions.iterator();
        while (i$.hasNext()) {
            DimensionMetaData dim = (DimensionMetaData)i$.next();
            OlapDimension dimension = new OlapDimension();
            String dimTitle = dim.getName();
            dimension.setName(dimTitle);
            boolean isTimeDimension = dim.isTimeDimension();
            dimension.setTimeDimension(isTimeDimension);
            ArrayList<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();
            Iterator i$2 = dim.iterator();
            while (i$2.hasNext()) {
                HierarchyMetaData hier = (HierarchyMetaData)i$2.next();
                OlapHierarchy hierarchy = new OlapHierarchy(dimension);
                hierarchy.setName(hier.getName());
                ArrayList<OlapHierarchyLevel> levels = new ArrayList<OlapHierarchyLevel>();
                Iterator i$3 = hier.iterator();
                while (i$3.hasNext()) {
                    LogicalColumn lCol;
                    TimeRole timeRole;
                    LevelMetaData lvl = (LevelMetaData)i$3.next();
                    OlapHierarchyLevel level = new OlapHierarchyLevel(hierarchy);
                    level.setName(lvl.getName());
                    if (isTimeDimension && (timeRole = (TimeRole)lvl.getDataRole()) != null) {
                        level.setLevelType(timeRole.getMondrianAttributeValue());
                    }
                    if ((lCol = lvl.getLogicalColumn()) != null) {
                        LogicalTable supposedLTable = lCol.getLogicalTable();
                        LogicalTable olapCloneLTable = this.findOlapCloneForTableInDomain(supposedLTable, domain);
                        hierarchy.setLogicalTable(olapCloneLTable);
                        if (!olapCloneLTable.getLogicalColumns().contains(lCol)) {
                            olapCloneLTable.addLogicalColumn(lCol);
                        }
                        for (IMemberAnnotation anno : lvl.getMemberAnnotations().values()) {
                            if (anno == null) continue;
                            anno.saveAnnotations(level);
                        }
                        level.setReferenceColumn(lCol);
                        hierarchy.setLogicalTable(olapCloneLTable);
                        if (logicalModel.getLogicalTables().size() > 1) {
                            hierarchy.setPrimaryKey(this.findPrimaryKeyFor(logicalModel, factTable, olapCloneLTable));
                        }
                        if ((lCol = lvl.getLogicalOrdinalColumn()) != null) {
                            level.setReferenceOrdinalColumn(lCol);
                        }
                        if ((lCol = lvl.getLogicalCaptionColumn()) != null) {
                            level.setReferenceCaptionColumn(lCol);
                        }
                    }
                    Iterator i$4 = lvl.iterator();
                    while (i$4.hasNext()) {
                        MemberPropertyMetaData memberProp = (MemberPropertyMetaData)i$4.next();
                        LogicalColumn lc = memberProp.getLogicalColumn();
                        if (lc == null || level.getLogicalColumns().contains(lc)) continue;
                        if (memberProp.getDescription() != null) {
                            lc.setDescription(new LocalizedString(this.getLocale(), memberProp.getDescription()));
                        }
                        level.getLogicalColumns().add(lc);
                    }
                    level.setHavingUniqueMembers(lvl.isUniqueMembers());
                    levels.add(level);
                }
                hierarchy.setHierarchyLevels(levels);
                hierarchies.add(hierarchy);
            }
            if (hierarchies.isEmpty()) {
                OlapHierarchy defaultHierarchy = new OlapHierarchy(dimension);
                defaultHierarchy.setLogicalTable(factTable);
                hierarchies.add(defaultHierarchy);
            }
            dimension.setHierarchies(hierarchies);
            olapDimensions.add(dimension);
            OlapDimensionUsage usage = new OlapDimensionUsage(dimension.getName(), dimension);
            usages.add(usage);
        }
        OlapCube cube = new OlapCube();
        cube.setLogicalTable(factTable);
        cube.setName(model.getModelName());
        cube.setOlapDimensionUsages(usages);
        HashMap<String, LogicalColumn> backingColumns = new HashMap<String, LogicalColumn>();
        Iterator i$5 = model.getModel().getMeasures().iterator();
        while (i$5.hasNext()) {
            MeasureMetaData f = (MeasureMetaData)i$5.next();
            LogicalColumn lCol = f.getLogicalColumn();
            LogicalTable lTable = lCol.getLogicalTable();
            OlapMeasure measure = new OlapMeasure();
            String colKey = lTable.getId() + "." + lCol.getId();
            if (backingColumns.containsKey(colKey)) {
                LogicalColumn clone = (LogicalColumn)lCol.clone();
                clone.setId(BaseModelerWorkspaceHelper.uniquify(clone.getId(), lTable.getLogicalColumns()));
                lCol = clone;
            } else {
                backingColumns.put(colKey, lCol);
            }
            if (!lTable.getLogicalColumns().contains(lCol)) {
                lTable.addLogicalColumn(lCol);
            }
            if (f.getDefaultAggregation() != null) {
                lCol.setAggregationType(f.getDefaultAggregation());
            }
            this.setLogicalColumnFormat(f.getFormat(), lCol);
            measure.setName(f.getName());
            measure.setLogicalColumn(lCol);
            measures.add(measure);
        }
        cube.setOlapMeasures(measures);
        if (olapDimensions.size() > 0) {
            logicalModel.setProperty("olap_dimensions", olapDimensions);
        }
        ArrayList<OlapCube> cubes = new ArrayList<OlapCube>();
        cubes.add(cube);
        logicalModel.setProperty("olap_cubes", cubes);
    }

    private LogicalTable findOlapCloneForTableInDomain(LogicalTable supposedLTable, Domain domain) {
        if (supposedLTable.getId().endsWith(OLAP_SUFFIX)) {
            return supposedLTable;
        }
        for (LogicalTable table : ((LogicalModel)domain.getLogicalModels().get(1)).getLogicalTables()) {
            if (!table.getId().equals(supposedLTable.getId() + OLAP_SUFFIX)) continue;
            return table;
        }
        throw new IllegalStateException("Unable to find a OLAP copy for table: " + supposedLTable.getId());
    }

    private LogicalColumn findPrimaryKeyFor(LogicalModel model, LogicalTable factTable, LogicalTable dimTable) {
        LogicalRelationship ship = model.findRelationshipUsing(dimTable, factTable);
        if (ship == null) {
            throw new IllegalStateException("Unable to find a primary key for table: " + dimTable.getId());
        }
        if (ship.getFromTable().equals((Object)dimTable)) {
            return ship.getFromColumn();
        }
        return ship.getToColumn();
    }

    public static final String uniquify(String id, List<? extends IConcept> concepts) {
        boolean gotNew = false;
        boolean found = false;
        int conceptNr = 1;
        String newId = id;
        while (!gotNew) {
            for (IConcept iConcept : concepts) {
                if (!iConcept.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++conceptNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        return newId;
    }

    @Override
    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        BaseModelerWorkspaceHelper.locale = locale;
    }

    protected void populateCategories(ModelerWorkspace workspace) {
        RelationalModelNode model = workspace.getRelationalModel();
        LogicalModel logicalModel = (LogicalModel)workspace.getDomain().getLogicalModels().get(0);
        logicalModel.getCategories().clear();
        Iterator i$ = model.getCategories().iterator();
        while (i$.hasNext()) {
            CategoryMetaData catMeta = (CategoryMetaData)i$.next();
            Category cat = new Category();
            cat.setName(new LocalizedString(this.getLocale(), catMeta.getName()));
            cat.setId(catMeta.getName());
            Iterator i$2 = catMeta.iterator();
            while (i$2.hasNext()) {
                FieldMetaData fieldMeta = (FieldMetaData)i$2.next();
                LogicalColumn lCol = fieldMeta.getLogicalColumn();
                LogicalTable lTable = lCol.getLogicalTable();
                if (!lTable.getLogicalColumns().contains(lCol)) {
                    lTable.addLogicalColumn(lCol);
                }
                lCol.setName(new LocalizedString(locale, fieldMeta.getName()));
                AggregationType type = fieldMeta.getDefaultAggregation();
                lCol.setAggregationType(type);
                this.setLogicalColumnFormat(fieldMeta.getFormat(), lCol);
                HashSet<AggregationType> possibleAggs = new HashSet<AggregationType>();
                possibleAggs.add(fieldMeta.getDefaultAggregation());
                possibleAggs.addAll(fieldMeta.getSelectedAggregations());
                lCol.setAggregationList(Arrays.asList(possibleAggs.toArray(new AggregationType[possibleAggs.size()])));
                cat.addLogicalColumn(lCol);
            }
            logicalModel.addCategory(cat);
        }
    }

    private void setLogicalColumnFormat(String format, LogicalColumn lCol) {
        String formatMask = format;
        if ("NONE".equals(formatMask) || formatMask == null || formatMask.equals("")) {
            formatMask = null;
        }
        if (formatMask != null) {
            lCol.setProperty("mask", (Object)formatMask);
        } else if (lCol.getDataType() == DataType.NUMERIC) {
            lCol.setProperty("mask", (Object)"#");
        } else if (lCol.getChildProperty("mask") != null) {
            lCol.removeChildProperty("mask");
        }
    }

    @Override
    public void autoModelFlat(ModelerWorkspace workspace) throws ModelerException {
        this.autoModelStrategy.autoModelOlap(workspace, this.getMainModelNode(workspace));
    }

    @Override
    public void autoModelFlatInBackground(ModelerWorkspace workspace) throws ModelerException {
        this.autoModelFlat(workspace);
    }

    @Override
    public void sortFields(List<AvailableField> availableFields) {
        Collections.sort(availableFields, new Comparator<AvailableField>(){

            @Override
            public int compare(AvailableField o1, AvailableField o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                String name1 = o1.getDisplayName();
                String name2 = o2.getDisplayName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
    }

    @Override
    public void autoModelRelationalFlat(ModelerWorkspace workspace) throws ModelerException {
        this.autoModelStrategy.autoModelRelational(workspace, this.getRelationalModelNode(workspace));
    }

    @Override
    public void autoModelRelationalFlatInBackground(ModelerWorkspace workspace) throws ModelerException {
        this.autoModelRelationalFlat(workspace);
    }

    public static String getCleanCategoryName(String name, ModelerWorkspace workspace, int index) {
        if (name == null) {
            return "Category " + index;
        }
        if (name.equals("LOGICAL_TABLE_1") || name.equals("INLINE_SQL_1")) {
            if (workspace.getModel().getName() != null) {
                return workspace.getModel().getName();
            }
            return "Category " + index;
        }
        return name;
    }

    protected abstract MainModelNode getMainModelNode(ModelerWorkspace var1);

    protected abstract RelationalModelNode getRelationalModelNode(ModelerWorkspace var1);

    @Override
    public AutoModelStrategy getAutoModelStrategy() {
        return this.autoModelStrategy;
    }

    @Override
    public void setAutoModelStrategy(AutoModelStrategy autoModelStrategy) {
        this.autoModelStrategy = autoModelStrategy;
    }

    static {
        DEFAULT_AGGREGATION_LIST.add(AggregationType.NONE);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.SUM);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.AVERAGE);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.MINIMUM);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.MAXIMUM);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.COUNT);
        DEFAULT_AGGREGATION_LIST.add(AggregationType.COUNT_DISTINCT);
        DEFAULT_NON_NUMERIC_AGGREGATION_LIST.add(AggregationType.NONE);
        DEFAULT_NON_NUMERIC_AGGREGATION_LIST.add(AggregationType.COUNT);
        DEFAULT_NON_NUMERIC_AGGREGATION_LIST.add(AggregationType.COUNT_DISTINCT);
    }
}

