/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.agilebi.modeler.IDropTarget;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.DataRole;
import org.pentaho.agilebi.modeler.nodes.IRootModelNode;
import org.pentaho.agilebi.modeler.nodes.annotations.IMemberAnnotation;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelNode;

public abstract class AbstractMetaDataModelNode<T extends AbstractMetaDataModelNode>
extends AbstractModelNode<T>
implements Serializable,
IDropTarget {
    private static final long serialVersionUID = 1547202580713108254L;
    protected boolean valid = true;
    protected transient Set<String> validationMessages = new HashSet<String>();
    protected String image;
    protected boolean suppressEvents;
    protected boolean expanded;
    protected DataRole dataRole;
    protected Map<String, IMemberAnnotation> annotations = new AnnotationMap();
    protected String classname;
    protected String validClassname;
    protected String invalidClassname = "pentaho-warningbutton";
    protected transient PropertyChangeListener validListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            AbstractMetaDataModelNode.this.validateNode();
        }
    };
    protected transient PropertyChangeListener nameListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            AbstractMetaDataModelNode.this.validateNode();
        }
    };
    protected transient PropertyChangeListener childrenListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractMetaDataModelNode.this.fireCollectionChanged();
        }
    };
    private ModelerWorkspace workspace;

    public AbstractMetaDataModelNode(String classname) {
        this.image = this.getInvalidImage();
        this.classname = classname;
        this.validClassname = classname;
    }

    public void onAdd(T child) {
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateTree();
    }

    public void onRemove(T child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Bindable
    public String getValidationMessagesString() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (String msg : this.validationMessages) {
            if (i > 0) {
                str.append(", ");
            }
            str.append(msg);
            ++i;
        }
        return str.toString();
    }

    @Bindable
    public void setDataRole(DataRole dataRole) {
        if (this.dataRole == null && dataRole == null) {
            return;
        }
        if (this.dataRole != null && dataRole != null && this.dataRole.equals(dataRole)) {
            return;
        }
        DataRole oldDataRole = this.dataRole;
        this.dataRole = dataRole;
        if (this.suppressEvents) {
            return;
        }
        this.firePropertyChange("dataRole", oldDataRole, dataRole);
        this.validateNode();
    }

    @Bindable
    public DataRole getDataRole() {
        return this.dataRole;
    }

    @Bindable
    public Set<String> getValidationMessages() {
        return this.validationMessages;
    }

    protected void fireCollectionChanged() {
        if (!this.suppressEvents) {
            super.fireCollectionChanged();
        }
    }

    @Bindable
    public void setImage(String image) {
        if (this.image == null || !this.image.equals(image)) {
            String oldimg = this.image;
            this.image = image;
            if (!this.suppressEvents) {
                this.firePropertyChange("image", oldimg, image);
            }
        }
    }

    public abstract String getValidImage();

    @Bindable
    public final String getInvalidImage() {
        return "images/warning.png";
    }

    @Bindable
    public String getImage() {
        return this.valid ? this.getValidImage() : this.getInvalidImage();
    }

    @Bindable
    public String getClassname() {
        return this.classname;
    }

    @Bindable
    public void setClassname(String classname) {
        if (this.classname == null || !this.classname.equals(classname)) {
            String oldClassname = this.classname;
            this.classname = classname;
            if (!this.suppressEvents) {
                this.firePropertyChange("classname", oldClassname, classname);
            }
        }
    }

    public abstract void validate();

    public void validateNode() {
        AbstractModelNode root;
        boolean prevValid = this.valid;
        String prevMessages = this.getValidationMessagesString();
        this.validate();
        for (IMemberAnnotation anno : this.annotations.values()) {
            if (anno == null) continue;
            this.valid &= anno.isValid(this);
            List<String> messages = anno.getValidationMessages(this);
            if (messages == null) continue;
            this.validationMessages.addAll(messages);
        }
        if (!this.suppressEvents) {
            this.firePropertyChange("validationMessagesString", prevMessages, this.getValidationMessagesString());
            this.firePropertyChange("valid", prevValid, this.valid);
        }
        if (this.valid) {
            this.setImage(this.getValidImage());
            this.setClassname(this.validClassname);
        } else {
            this.setImage(this.getInvalidImage());
            this.setClassname(this.invalidClassname);
        }
        if (prevValid != this.valid && (root = this.getRoot()) != null && root instanceof AbstractMetaDataModelNode) {
            AbstractMetaDataModelNode rootNode = (AbstractMetaDataModelNode)root;
            rootNode.validateTree();
        }
    }

    public void validateTree() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            AbstractMetaDataModelNode t = (AbstractMetaDataModelNode)i$.next();
            t.validateTree();
        }
        this.validateNode();
    }

    public boolean isTreeValid() {
        if (!this.isValid()) {
            return false;
        }
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            AbstractMetaDataModelNode t = (AbstractMetaDataModelNode)i$.next();
            if (t.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        boolean prevValid = this.valid;
        this.valid = false;
        if (!this.suppressEvents) {
            this.firePropertyChange("valid", prevValid, this.valid);
        }
    }

    public abstract Class<? extends ModelerNodePropertiesForm> getPropertiesForm();

    public void setSupressEvents(boolean suppress) {
        this.suppressEvents = suppress;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            AbstractMetaDataModelNode child = (AbstractMetaDataModelNode)i$.next();
            child.setSupressEvents(suppress);
        }
    }

    @Bindable
    public boolean isExpanded() {
        return this.expanded;
    }

    @Bindable
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public abstract boolean acceptsDrop(Object var1);

    public ModelerWorkspace getWorkspace() {
        AbstractModelNode parent;
        if (this.workspace == null && (parent = this.getRoot()) != null) {
            this.workspace = ((IRootModelNode)parent).getWorkspace();
        }
        return this.workspace;
    }

    protected AbstractModelNode getRoot() {
        AbstractModelNode parent;
        for (parent = this.getParent(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
        }
        return parent;
    }

    public Map<String, IMemberAnnotation> getMemberAnnotations() {
        return this.annotations;
    }

    private class AnnotationMap
    extends HashMap<String, IMemberAnnotation> {
        private static final long serialVersionUID = -578588442907941576L;

        private AnnotationMap() {
        }

        @Override
        public IMemberAnnotation put(String s, IMemberAnnotation iMemberAnnotation) {
            IMemberAnnotation prevVal = (IMemberAnnotation)this.get(s);
            if (prevVal != null && prevVal != iMemberAnnotation) {
                prevVal.onDetach(AbstractMetaDataModelNode.this);
            }
            if ((prevVal == null || prevVal != iMemberAnnotation) && iMemberAnnotation != null) {
                iMemberAnnotation.onAttach(AbstractMetaDataModelNode.this);
            }
            return super.put(s, iMemberAnnotation);
        }

        @Override
        public void putAll(Map<? extends String, ? extends IMemberAnnotation> map) {
            for (String string : map.keySet()) {
                IMemberAnnotation prevVal = (IMemberAnnotation)this.get(string);
                if (prevVal != null && prevVal != map.get(string)) {
                    prevVal.onDetach(AbstractMetaDataModelNode.this);
                }
                if (prevVal != null && (prevVal == map.get(string) || map.get(string) == null)) continue;
                map.get(string).onAttach(AbstractMetaDataModelNode.this);
            }
            super.putAll(map);
        }

        @Override
        public IMemberAnnotation remove(Object o) {
            if (o instanceof IMemberAnnotation) {
                ((IMemberAnnotation)o).onDetach(AbstractMetaDataModelNode.this);
            }
            return (IMemberAnnotation)super.remove(o);
        }
    }
}

