/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.IRootModelNode;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.agilebi.modeler.propforms.RelationalModelNodePropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

public class RelationalModelNode
extends AbstractMetaDataModelNode<CategoryMetaDataCollection>
implements Serializable,
IRootModelNode {
    private static final String IMAGE = "images/sm_model_icon.png";
    private static final long serialVersionUID = 818429477176656590L;
    String name = "Untitled";
    private CategoryMetaDataCollection categories = new CategoryMetaDataCollection();
    private transient PropertyChangeListener listener;
    private ModelerWorkspace workspace;
    private static final String CLASSNAME = "pentaho-smallmodelbutton";

    public RelationalModelNode() {
        super(CLASSNAME);
        this.add(this.categories);
        this.setExpanded(true);
        this.categories.setExpanded(true);
    }

    public RelationalModelNode(ModelerWorkspace workspace) {
        this();
        this.workspace = workspace;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return ModelerMessagesHolder.getMessages().getString("Main.Model.Name.Template", this.getName());
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            String prevDisplay = this.getDisplayName();
            this.name = name;
            this.firePropertyChange("name", oldName, this.name);
            this.firePropertyChange("displayName", prevDisplay, this.getName());
            this.validateNode();
        }
    }

    @Override
    @Bindable
    public String getImage() {
        return IMAGE;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Override
    protected void fireCollectionChanged() {
        this.changeSupport.firePropertyChange("children", null, this);
    }

    @Override
    public void onAdd(CategoryMetaDataCollection child) {
        child.addPropertyChangeListener("children", this.getListener());
        child.addPropertyChangeListener("valid", this.validListener);
    }

    @Override
    public void onRemove(CategoryMetaDataCollection child) {
        child.removePropertyChangeListener(this.getListener());
        child.removePropertyChangeListener(this.validListener);
    }

    public CategoryMetaDataCollection getCategories() {
        return this.categories;
    }

    @Override
    public String getValidImage() {
        return IMAGE;
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.children.size() != 1) {
            this.valid = false;
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.relationalmodel.INVALID_STRUCTURE", new String[0]));
        }
        for (AbstractMetaDataModelNode child : this.children) {
            this.valid &= child.isValid();
            this.validationMessages.addAll(child.getValidationMessages());
        }
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return RelationalModelNodePropertiesForm.class;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return true;
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!RelationalModelNode.this.suppressEvents) {
                        RelationalModelNode.this.fireCollectionChanged();
                    }
                }
            };
        }
        return this.listener;
    }

    @Override
    public void setSupressEvents(boolean suppress) {
        super.setSupressEvents(suppress);
        if (!suppress) {
            this.firePropertyChange("valid", !this.isValid(), this.isValid());
        }
    }

    public boolean getSuppressEvents() {
        return this.suppressEvents;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        throw new ModelerException(new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0])));
    }

    @Override
    public ModelerWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(ModelerWorkspace workspace) {
        this.workspace = workspace;
    }
}

