/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianChangeSlicer
extends ExtensionSupport
implements ChangeSlicer {
    static Logger logger = Logger.getLogger(MondrianChangeSlicer.class);

    public MondrianChangeSlicer() {
        super.setId("changeSlicer");
    }

    @Override
    public Member[] getSlicer() {
        MondrianModel model = (MondrianModel)this.getModel();
        Result res = null;
        try {
            res = model.getResult();
        }
        catch (OlapException ex) {
            return new Member[0];
        }
        Axis slicer = res.getSlicer();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position pos : positions) {
            Member[] posMembers = pos.getMembers();
            for (int i = 0; i < posMembers.length; ++i) {
                if (members.contains(posMembers[i])) continue;
                members.add(posMembers[i]);
            }
        }
        return members.toArray(new Member[0]);
    }

    @Override
    public void setSlicer(Member[] members) {
        MondrianModel model = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
        Query monQuery = adapter.getMonQuery();
        boolean logInfo = logger.isInfoEnabled();
        if (members.length == 0) {
            monQuery.setSlicerAxis(null);
            if (logInfo) {
                logger.info((Object)"slicer set to null");
            }
        } else {
            ArrayList<Exp> collectedMemberExpressions = new ArrayList<Exp>();
            ArrayList<UnresolvedFunCall> conditions = new ArrayList<UnresolvedFunCall>();
            String prevHierarchyName = "";
            String hierarchyName = "";
            String mbrUniqueName = "";
            UnresolvedFunCall f = null;
            boolean firstCondition = true;
            for (int i = 0; i < members.length; ++i) {
                mbrUniqueName = ((MondrianMember)members[i]).getUniqueName();
                hierarchyName = mbrUniqueName.substring(1, mbrUniqueName.indexOf("]"));
                if (!hierarchyName.equals(prevHierarchyName)) {
                    if (collectedMemberExpressions.size() > 0) {
                        if (firstCondition) {
                            f = new UnresolvedFunCall("{}", Syntax.Braces, collectedMemberExpressions.toArray(new Exp[collectedMemberExpressions.size()]));
                        } else {
                            conditions.add(new UnresolvedFunCall("{}", Syntax.Braces, collectedMemberExpressions.toArray(new Exp[collectedMemberExpressions.size()])));
                            f = new UnresolvedFunCall("CrossJoin", Syntax.Function, conditions.toArray(new Exp[conditions.size()]));
                            conditions.clear();
                        }
                        conditions.add(f);
                        firstCondition = false;
                        if (logInfo) {
                            logger.info((Object)("Added a new filter condition for Hierarchy: " + prevHierarchyName + ", Conditions number: " + collectedMemberExpressions.size()));
                        }
                        collectedMemberExpressions.clear();
                        if (logInfo) {
                            logger.info((Object)("Clear conditions list. Size = " + collectedMemberExpressions.size()));
                        }
                    }
                    prevHierarchyName = hierarchyName;
                    if (logInfo) {
                        logger.info((Object)("Collecting filters on member: " + hierarchyName));
                    }
                }
                collectedMemberExpressions.add(this.createExpressionFor(monQuery, (MondrianMember)members[i]));
            }
            if (collectedMemberExpressions.size() > 0) {
                conditions.add(new UnresolvedFunCall("{}", Syntax.Braces, collectedMemberExpressions.toArray(new Exp[collectedMemberExpressions.size()])));
                if (logInfo) {
                    logger.info((Object)("Added a new filter condition for Hierarchy: " + hierarchyName));
                }
            }
            if (conditions.size() == 1) {
                monQuery.setSlicerAxis(new QueryAxis(false, (Exp)conditions.get(0), (AxisOrdinal)AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined));
            } else {
                UnresolvedFunCall intersectConditions = new UnresolvedFunCall("Crossjoin", Syntax.Function, conditions.toArray(new Exp[conditions.size()]));
                monQuery.setSlicerAxis(new QueryAxis(false, (Exp)intersectConditions, (AxisOrdinal)AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined));
            }
        }
        model.fireModelChanged();
    }

    protected Exp createExpressionFor(Query monQuery, MondrianMember member) {
        return new MemberExpr(member.getMonMember());
    }
}

