/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Alignable;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.jpivot.olap.query.MDXMember;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;

public class MondrianMember
implements Member,
MDXMember {
    private mondrian.olap.Member monMember;
    private MondrianLevel level;
    private MondrianModel model;
    private com.tonbeller.jpivot.olap.model.Property[] properties = null;

    protected MondrianMember(mondrian.olap.Member monMember, MondrianLevel level, MondrianModel model) {
        this.monMember = monMember;
        this.level = level;
        this.model = model;
        level.addMember(this);
        Property[] props = monMember.getLevel().getProperties();
        if (props != null) {
            this.properties = new com.tonbeller.jpivot.olap.model.Property[props.length];
            for (int i = 0; i < props.length; ++i) {
                MondrianProp prop = new MondrianProp();
                if (props[i].getType() == Property.Datatype.TYPE_NUMERIC) {
                    prop.setAlignment(Alignable.Alignment.RIGHT);
                }
                String propName = props[i].getName();
                prop.setName(propName);
                String caption = props[i].getCaption();
                if (caption != null && !caption.equals(propName)) {
                    prop.setLabel(caption);
                    prop.setMondrianName(propName);
                    prop.setNormalizable(false);
                } else {
                    prop.setLabel(propName);
                }
                String propValue = monMember.getPropertyFormattedValue(propName);
                prop.setValue(propValue);
                this.properties[i] = prop;
            }
        }
    }

    @Override
    public String getLabel() {
        return this.monMember.getCaption();
    }

    @Override
    public int getRootDistance() {
        SchemaReader scr = this.model.getSchemaReader();
        mondrian.olap.Member m = this.monMember;
        int rootDistance = 0;
        while ((m = scr.getMemberParent(m)) != null) {
            ++rootDistance;
        }
        return rootDistance;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public com.tonbeller.jpivot.olap.model.Property[] getProperties() {
        if (this.properties == null || this.properties.length == 0) {
            return new com.tonbeller.jpivot.olap.model.Property[0];
        }
        return this.properties;
    }

    @Override
    public Member getParent() {
        mondrian.olap.Member monParent = this.monMember.getParentMember();
        MondrianMember parent = this.model.addMember(monParent);
        return parent;
    }

    @Override
    public String getParentUniqueName() {
        return this.monMember.getParentUniqueName();
    }

    @Override
    public boolean isAll() {
        return this.monMember.isAll();
    }

    @Override
    public com.tonbeller.jpivot.olap.model.Property getProperty(String name) {
        if (this.properties == null || this.properties.length == 0) {
            return null;
        }
        for (int i = 0; i < this.properties.length; ++i) {
            if (!name.equals(this.properties[i].getName())) continue;
            return this.properties[i];
        }
        return null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMember(this);
    }

    public mondrian.olap.Member getMonMember() {
        return this.monMember;
    }

    @Override
    public String getUniqueName() {
        return this.monMember.getUniqueName();
    }

    @Override
    public boolean isCalculated() {
        return this.monMember.isCalculated();
    }

    @Override
    public Object getRootDecoree() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MondrianMember)) {
            return false;
        }
        mondrian.olap.Member mm = ((MondrianMember)obj).getMonMember();
        return this.monMember.equals(mm);
    }

    public int hashCode() {
        return this.monMember.hashCode();
    }

    public static class MondrianProp
    extends PropertyImpl {
        String mondrianName = null;

        public String getMondrianName() {
            return this.mondrianName;
        }

        public void setMondrianName(String mondrianName) {
            this.mondrianName = mondrianName;
        }
    }
}

