/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.navigator.hierarchy.HierarchyItem;
import com.tonbeller.jpivot.navigator.hierarchy.HierarchyNavigator;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.MemberDeleter;
import com.tonbeller.wcf.catedit.Category;
import com.tonbeller.wcf.catedit.Item;
import com.tonbeller.wcf.controller.RequestContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCategory
implements Category {
    HierarchyNavigator navi;
    String name;
    String icon;
    boolean dirty;
    List items = new ArrayList();

    public AbstractCategory(HierarchyNavigator navi, String name, String icon) {
        this.navi = navi;
        this.name = name;
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public List getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void addItem(Item item) {
        HierarchyItem hi = (HierarchyItem)item;
        this.items.add(hi);
        hi.setCategory(this);
        this.setDirty(true);
    }

    public void changeOrder(List items) {
        this.items.clear();
        this.items.addAll(items);
        this.setDirty(true);
    }

    public void removeItem(Item item) {
        this.items.remove(item);
        this.setDirty(true);
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.navi.setEditing(true);
        }
    }

    HierarchyNavigator getNavigator() {
        return this.navi;
    }

    public abstract void itemClicked(RequestContext var1, HierarchyItem var2);

    public HierarchyItem findItemFor(Hierarchy hier) {
        for (HierarchyItem item : this.items) {
            if (!hier.equals(item.getHierarchy())) continue;
            return item;
        }
        return null;
    }

    abstract void prepareApplyChanges();

    abstract void applyChanges();

    abstract void setSelection(HierarchyItem var1, Collection var2);

    abstract String validateSelection(HierarchyItem var1, Collection var2);

    public abstract boolean isSlicer();

    public void deleteDeleted() {
        MemberDeleter md = this.navi.getDeleterExtension();
        if (md == null) {
            return;
        }
        for (HierarchyItem item : this.items) {
            Iterator mi = item.getDeleted().iterator();
            while (mi.hasNext()) {
                md.delete((Member)mi.next());
            }
        }
    }
}

