/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.hierarchy;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.span.PropertySpanBuilder;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.catedit.CategoryEditor;
import com.tonbeller.wcf.catedit.CategoryModel;
import com.tonbeller.wcf.catedit.CategoryModelSupport;
import com.tonbeller.wcf.catedit.CategorySupport;
import com.tonbeller.wcf.catedit.Item;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SelectProperties
extends CategoryEditor
implements ModelChangeListener {
    private String acceptButtonId;
    private String cancelButtonId;
    private RequestListener acceptHandler;
    private RequestListener revertHandler;
    private String okButtonId;
    private String revertButtonId;
    private List categories = new ArrayList();
    private Resources resources;
    private boolean editing = false;
    private TableComponent tableComponent;
    private CategoryModelSupport categoryModel;
    private Dispatcher tempDispatcher = new DispatcherSupport();
    private static Logger logger = Logger.getLogger(SelectProperties.class);
    private PropertySpanBuilder propertyConfig;
    private List visiblePropertyMetas = null;
    private List[] availablePropertiesColumns;
    private CategorySupport categorySupportVisible;
    private CategorySupport categorySupportAvailable;
    private Map scopeMap;

    private void sortCategory() {
        if (this.categorySupportVisible == null) {
            return;
        }
        ArrayList items = this.categorySupportVisible.getItems();
        int scopeSize = this.scopeMap.size();
        List[] tempItems = new List[scopeSize];
        for (int i = 0; i < scopeSize; ++i) {
            tempItems[i] = new ArrayList();
        }
        for (MpmItem mpmItem : items) {
            Integer index = (Integer)this.scopeMap.get(mpmItem.getMpm().getScope());
            if (index == null) continue;
            tempItems[index].add(mpmItem);
        }
        items = new ArrayList();
        for (int i = 0; i < scopeSize; ++i) {
            Iterator iterator = tempItems[i].iterator();
            while (iterator.hasNext()) {
                items.add(iterator.next());
            }
        }
        this.categorySupportVisible.setItems(items);
    }

    public SelectProperties(String id, Component parent, TableComponent tableComponent) {
        super(id, parent);
        logger.info((Object)("creating instance: " + this));
        this.acceptButtonId = id + ".accept";
        this.cancelButtonId = id + ".cancel";
        this.okButtonId = id + ".ok";
        this.revertButtonId = id + ".revert";
        this.tableComponent = tableComponent;
        OlapModel olapModel = tableComponent.getOlapModel();
        olapModel.addModelChangeListener(this);
        this.acceptHandler = new OkHandler(false);
        this.revertHandler = new CancelHandler(false);
        super.getDispatcher().addRequestListener(this.acceptButtonId, null, this.acceptHandler);
        super.getDispatcher().addRequestListener(this.revertButtonId, null, this.revertHandler);
        super.getDispatcher().addRequestListener(this.okButtonId, null, (RequestListener)new OkHandler(true));
        super.getDispatcher().addRequestListener(this.cancelButtonId, null, (RequestListener)new CancelHandler(true));
        super.getDispatcher().addRequestListener(null, null, (RequestListener)this.tempDispatcher);
        this.categoryModel = new CategoryModelSupport(){

            public List getCategories() {
                return SelectProperties.this.categories;
            }
        };
        super.setModel((CategoryModel)this.categoryModel);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.resources = context.getResources(SelectProperties.class);
    }

    Dispatcher getTempDispatcher() {
        return this.tempDispatcher;
    }

    void initializeCategories() throws OlapException {
        logger.info((Object)"SelectProperties.initializeCategories()");
        this.categories.clear();
        this.scopeMap = new HashMap();
        this.categorySupportVisible = new CategorySupport(this.resources.getString("properties.visible"), "cat-visible.png");
        this.categorySupportAvailable = new CategorySupport(this.resources.getString("properties.available"), "cat-available.png");
        this.categories.add(this.categorySupportVisible);
        this.categories.add(this.categorySupportAvailable);
        this.propertyConfig = (PropertySpanBuilder)this.tableComponent.getPropertyConfig();
        this.visiblePropertyMetas = this.propertyConfig.getVisiblePropertyMetas();
        this.availablePropertiesColumns = this.propertyConfig.getAvailablePropertiesColumns();
        if (this.availablePropertiesColumns == null) {
            return;
        }
        ArrayList<MpmItem> itemListVisible = new ArrayList<MpmItem>();
        ArrayList<MpmItem> itemListAvailable = new ArrayList<MpmItem>();
        if (this.visiblePropertyMetas != null) {
            for (MemberPropertyMeta mpm : this.visiblePropertyMetas) {
                itemListVisible.add(new MpmItem(mpm));
            }
        }
        int index = 0;
        for (int i = 0; i < this.availablePropertiesColumns.length; ++i) {
            for (MemberPropertyMeta mpm : this.availablePropertiesColumns[i]) {
                if (!this.scopeMap.containsKey(mpm.getScope())) {
                    this.scopeMap.put(mpm.getScope(), new Integer(index++));
                }
                MpmItem mpmItem = new MpmItem(mpm);
                if (this.visiblePropertyMetas == null) {
                    itemListVisible.add(mpmItem);
                    continue;
                }
                if (this.existsInList(this.visiblePropertyMetas, mpmItem)) continue;
                itemListAvailable.add(mpmItem);
            }
        }
        this.categorySupportVisible.setEmptyAllowed(true);
        this.categorySupportVisible.setOrderSignificant(true);
        this.categorySupportVisible.setItems(itemListVisible);
        this.categorySupportAvailable.setEmptyAllowed(true);
        this.categorySupportAvailable.setOrderSignificant(true);
        this.categorySupportAvailable.setItems(itemListAvailable);
    }

    private boolean existsInList(List visiblePropertyMetas, MpmItem mpmItem) {
        if (visiblePropertyMetas == null) {
            return false;
        }
        for (MemberPropertyMeta mpm : visiblePropertyMetas) {
            String tempString = mpm.getScope() + " [ " + mpm.getLabel() + " ]";
            if (!tempString.equals(mpmItem.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public Element render(RequestContext context, Document factory) throws Exception {
        logger.info((Object)"SelectProperties.render()");
        if (!this.editing) {
            this.tempDispatcher.clear();
            this.initializeCategories();
            this.editing = true;
        }
        this.sortCategory();
        Element elem = super.render(context, factory);
        elem.setAttribute("accept-id", this.acceptButtonId);
        elem.setAttribute("accept-title", this.resources.getString("accept.title"));
        elem.setAttribute("revert-id", this.revertButtonId);
        elem.setAttribute("revert-title", this.resources.getString("revert.title"));
        elem.setAttribute("ok-id", this.okButtonId);
        elem.setAttribute("ok-title", this.resources.getString("ok.title"));
        elem.setAttribute("cancel-id", this.cancelButtonId);
        elem.setAttribute("cancel-title", this.resources.getString("cancel.title"));
        return elem;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.editing = false;
        this.categories.clear();
        this.categoryModel.fireModelChanged();
        this.setVisible(false);
    }

    @Override
    public void structureChanged(ModelChangeEvent e) {
        this.modelChanged(e);
    }

    class MpmItem
    implements Item {
        String label;
        MemberPropertyMeta mpm;

        public MpmItem(MemberPropertyMeta mpm) {
            this.label = mpm.getScope() + " [ " + mpm.getLabel() + " ]";
            this.mpm = mpm;
        }

        public MemberPropertyMeta getMpm() {
            return this.mpm;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isMovable() {
            return true;
        }
    }

    public class OkHandler
    implements RequestListener {
        private boolean hide;

        public OkHandler(boolean hide) {
            this.hide = hide;
        }

        public void request(RequestContext context) throws Exception {
            SelectProperties.this.editing = false;
            boolean valid = SelectProperties.this.validate(context);
            CategorySupport cs = (CategorySupport)SelectProperties.this.categories.get(0);
            if (cs.getItems().size() == 0) {
                SelectProperties.this.visiblePropertyMetas = null;
            } else {
                List items = cs.getItems();
                SelectProperties.this.visiblePropertyMetas = new ArrayList();
                for (MpmItem mpmItem : items) {
                    SelectProperties.this.visiblePropertyMetas.add(mpmItem.getMpm());
                }
            }
            SelectProperties.this.propertyConfig.setVisiblePropertyMetas(SelectProperties.this.visiblePropertyMetas);
            if (valid && this.hide) {
                SelectProperties.this.setVisible(false);
            }
        }
    }

    public class CancelHandler
    implements RequestListener {
        private boolean hide;

        public CancelHandler(boolean hide) {
            this.hide = hide;
        }

        public void request(RequestContext context) throws Exception {
            SelectProperties.this.editing = false;
            SelectProperties.this.revert(context);
            if (this.hide) {
                SelectProperties.this.setVisible(false);
            }
        }
    }
}

