/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.query.QuaxUti;
import com.tonbeller.jpivot.util.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class ExpGenerator {
    TreeNode rootNode = null;
    int nDimension;
    Hierarchy[] hiers;
    QuaxUti uti;

    public ExpGenerator(QuaxUti uti) {
        this.uti = uti;
    }

    public void init(TreeNode rootNode, Hierarchy[] hiers) {
        this.rootNode = rootNode;
        this.hiers = hiers;
        this.nDimension = hiers.length;
    }

    public Object genExp() {
        Object exp = null;
        List nodes = this.rootNode.getChildren();
        ArrayList<Object> openSet = new ArrayList<Object>();
        for (TreeNode node : nodes) {
            Object expForNode = null;
            expForNode = this.genExpForNode(node, this.nDimension);
            boolean closeOpenSet = false;
            if (this.nDimension == 1) {
                if (this.uti.isMember(expForNode)) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            } else {
                if (this.uti.isFunCallTo(expForNode, "()")) {
                    openSet.add(expForNode);
                    continue;
                }
                closeOpenSet = true;
            }
            if (closeOpenSet && openSet.size() > 0) {
                Object[] expArray = openSet.toArray(new Object[0]);
                Object set = this.uti.createFunCall("{}", expArray, 2);
                exp = exp == null ? set : this.uti.createFunCall("Union", new Object[]{exp, set}, 0);
                openSet.clear();
            }
            if (exp == null) {
                exp = expForNode;
                continue;
            }
            exp = this.uti.createFunCall("Union", new Object[]{exp, expForNode}, 0);
        }
        if (openSet.size() > 0) {
            Object[] expArray = openSet.toArray(new Object[0]);
            Object set = this.uti.createFunCall("{}", expArray, 2);
            exp = exp == null ? set : this.uti.createFunCall("Union", new Object[]{exp, set}, 0);
            openSet.clear();
        }
        return exp;
    }

    private Object genExpForNode(TreeNode node, int untilIndex) {
        Object eNode = node.getReference();
        if (node.getLevel() == untilIndex) {
            return eNode;
        }
        Object[] tuple = this.genTuple(node);
        if (tuple != null) {
            if (tuple.length == 1) {
                return tuple[0];
            }
            return this.uti.createFunCall("()", tuple, 3);
        }
        Object exp = null;
        List childNodes = node.getChildren();
        for (TreeNode childNode : childNodes) {
            Object childExp = this.genExpForNode(childNode, untilIndex);
            Object eSet = !this.uti.isMember(eNode) ? eNode : this.uti.createFunCall("{}", new Object[]{eNode}, 2);
            if (childExp == null) {
                exp = eSet;
                continue;
            }
            Object childSet = this.bracesAround(childExp);
            Object cj = this.uti.createFunCall("CrossJoin", new Object[]{eSet, childSet}, 0);
            if (exp == null) {
                exp = cj;
                continue;
            }
            exp = this.uti.createFunCall("Union", new Object[]{exp, cj}, 0);
        }
        return exp;
    }

    private Object genUnion(Object[] oExps) {
        if (oExps.length == 1) {
            return oExps[0];
        }
        Object oUnion = this.uti.createFunCall("Union", new Object[]{oExps[0], oExps[1]}, 0);
        for (int i = 2; i < oExps.length; ++i) {
            oUnion = this.uti.createFunCall("Union", new Object[]{oUnion, oExps[i]}, 0);
        }
        return oUnion;
    }

    private Object bracesAround(Object oExp) {
        Object oSet = this.uti.isMember(oExp) || this.uti.isFunCallTo(oExp, "()") ? this.uti.createFunCall("{}", new Object[]{oExp}, 2) : oExp;
        return oSet;
    }

    private Object[] genTuple(TreeNode node) {
        if (!this.uti.isMember(node.getReference())) {
            return null;
        }
        int size = this.nDimension - node.getLevel() + 1;
        if (size == 1) {
            return new Object[]{node.getReference()};
        }
        List childNodes = node.getChildren();
        if (childNodes.size() != 1) {
            return null;
        }
        Object[] nextTuple = this.genTuple((TreeNode)childNodes.get(0));
        if (nextTuple == null) {
            return null;
        }
        Object[] tupleMembers = new Object[size];
        tupleMembers[0] = node.getReference();
        for (int i = 1; i < tupleMembers.length; ++i) {
            tupleMembers[i] = nextTuple[i - 1];
        }
        return tupleMembers;
    }
}

