/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Alignable;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.table.AxisHeaderBuilder;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.wcf.popup.Item;
import com.tonbeller.wcf.popup.MenuItem;
import com.tonbeller.wcf.popup.MenuItemSupport;
import com.tonbeller.wcf.popup.PopUp;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class AxisHeaderBuilderSupport
implements AxisHeaderBuilder {
    private SpanBuilder spanBuilder;

    public AxisHeaderBuilderSupport(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
    }

    @Override
    public void build(Element row, Span span, int rowspan, int colspan, boolean even, boolean memberIndent) {
        MySBContext sbctx = new MySBContext();
        Element elem = this.spanBuilder.build(sbctx, span, even);
        sbctx.render();
        elem.setAttribute("rowspan", Integer.toString(rowspan));
        elem.setAttribute("colspan", Integer.toString(colspan));
        if (elem.getAttribute("style").length() == 0) {
            String style = colspan > 1 || rowspan > 1 ? "span" : (even ? "even" : "odd");
            if (this.isRightAligned(span)) {
                style = style + "-right";
            }
            elem.setAttribute("style", style);
        }
        if (memberIndent && span.isMember()) {
            elem.setAttribute("indent", Integer.toString(span.getIndent()));
        }
        row.appendChild(elem);
    }

    private boolean isRightAligned(Span span) {
        Displayable obj = span.getObject();
        if (obj instanceof Alignable) {
            return ((Alignable)((Object)obj)).getAlignment() == Alignable.Alignment.RIGHT;
        }
        return false;
    }

    class MySBContext
    implements SpanBuilder.SBContext {
        Element captionElem;
        String captionLabel;
        List clickables = new ArrayList();

        MySBContext() {
        }

        @Override
        public void setCaption(Element elem, String label) {
            this.captionElem = elem;
            this.captionLabel = label;
        }

        @Override
        public void addClickable(String href, String label) {
            MenuItemSupport mis = new MenuItemSupport(href);
            mis.setLabel(label);
            this.clickables.add(mis);
        }

        void render() {
            if (this.clickables.isEmpty()) {
                return;
            }
            if (this.clickables.size() == 1) {
                MenuItem mi = (MenuItem)this.clickables.get(0);
                this.captionElem.setAttribute("href", mi.getHref());
                return;
            }
            PopUp pu = new PopUp();
            pu.setLabel(this.captionLabel);
            for (MenuItem mi : this.clickables) {
                pu.addItem((Item)mi);
            }
            Element e = pu.render(this.captionElem.getOwnerDocument());
            this.captionElem.appendChild(e);
        }
    }
}

