/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.navi.AbstractClickableMember;
import com.tonbeller.wcf.charset.CharsetFilter;
import com.tonbeller.wcf.controller.RequestContext;
import java.text.MessageFormat;

public class UrlClickableMember
extends AbstractClickableMember {
    private String urlPattern;
    private String menuLabel;

    protected UrlClickableMember(String uniqueName, String menuLabel, String urlPattern) {
        super(uniqueName);
        this.menuLabel = menuLabel;
        this.urlPattern = urlPattern;
    }

    private String getPatternUrl(Member member) {
        String pattern = this.urlPattern == null ? "?param={0}" : this.urlPattern;
        String uname = CharsetFilter.urlEncode((String)this.parser.unparse(member));
        Object[] args = new Object[]{uname};
        return MessageFormat.format(pattern, args);
    }

    @Override
    public void decorate(SpanBuilder.SBContext sbctx, Displayable obj) {
        if (!(obj instanceof Member)) {
            return;
        }
        Member m = (Member)obj;
        if (this.match(m)) {
            sbctx.addClickable(this.getPatternUrl(m), this.menuLabel);
        }
    }

    public void request(RequestContext context) throws Exception {
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
    }

    @Override
    public void structureChanged(ModelChangeEvent e) {
    }
}

