/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.span;

import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.EmptyMember;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.model.VisitorSupportStrict;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanHeaderFactory;
import com.tonbeller.jpivot.table.span.SpanVisitor;

public class HierarchyHeaderFactory
extends VisitorSupportStrict
implements SpanVisitor,
SpanHeaderFactory {
    Span header;

    @Override
    public Span create(Span span) {
        this.header = (Span)span.clone();
        span.getObject().accept(this);
        return this.header;
    }

    @Override
    public void visitDimension(Dimension v) {
        this.header.setObject(v);
    }

    @Override
    public void visitHierarchy(Hierarchy v) {
        this.header.setObject(v);
    }

    @Override
    public void visitLevel(Level v) {
        this.header.setObject(v.getHierarchy());
    }

    @Override
    public void visitMember(Member v) {
        this.header.setObject(v.getLevel().getHierarchy());
    }

    @Override
    public void visitProperty(Property v) {
        this.header.setObject(new PropertyHeading(v.getLabel()));
    }

    @Override
    public void visitPropertyHeading(PropertyHeading heading) {
        this.header.setObject(new PropertyHeading(heading.getLabel()));
    }

    @Override
    public void visitEmptyMember(EmptyMember v) {
        this.header.setObject(v);
    }
}

